<?php

function xmlrpc_call( &$xmlrpc_array, &$request ) {
	$len = strlen( $request );
	$headers = "CONTENT_LENGTH\0{$len}\0";
	$headers .= "SCGI\01\0";
	$len = strlen( $headers );
	$out = "{$len}:{$headers},{$request}";

	$fp = fsockopen( $xmlrpc_array["host"], $xmlrpc_array["port"], $errno, $errstr, $xmlrpc_array["timeout"] );
	if ( $fp ) {
		fwrite( $fp, $out );
		do {
			$line = fgets( $fp );
		} while ( trim( $line ) != "" );
		
		$ret = stream_get_contents( $fp );
	} else {
		$ret = $errno;
	}

	return $ret;
}

error_reporting( E_ALL );
//error_reporting( E_ALL ^ E_NOTICE );

session_start();
if ( !isset( $_SESSION["rtwi_rights"] ) ) {
	$_SESSION["rtwi_rights"] = 0;
}

require_once( "includes/config.inc.php" );
require_once( "{$include_path}/tools/functions.time.inc.php" );
require_once( "{$include_path}/classes/bittorrent_handler.inc.php" );

$st = getmicrotime();

if ( isset( $_REQUEST["mod"] ) ) {
	$mod = $_REQUEST["mod"];
} else {
	$mod = "";
}

if ( isset( $_REQUEST["hash"] ) ) {
	$hash = $_REQUEST["hash"];
} else {
	$hash = "";
}

if ( ( !isset( $_SESSION["rtwi_auth"] ) || $_SESSION["rtwi_auth"] !== 1 ) && $_REQUEST["mod"] != "login" ) {
	header( "location: {$url["index"]}" );
	exit;
} elseif ( $_REQUEST["mod"] != "login" ) {
	$xmlrpc_array["port"] = $users[$_SESSION["rtwi_nick"]]["port"];
}

$xml = new DOMDocument( "1.0", "utf-8" );
$xml->formatOutput = true;

$root = $xml->appendChild( $xml->createElement( "root" ) );

//print_r( $_SESSION );
//print_r( $_REQUEST );

switch ( $_REQUEST["mod"] ) {
	case "login" : { // login
		if ( isset( $_REQUEST["loginname"] ) && isset( $_REQUEST["loginpass"] ) && $_REQUEST["loginname"] != "" && $_REQUEST["loginpass"] != "" && $users[$_REQUEST["loginname"]]["pass"] == sha1( $_REQUEST["loginpass"] ) ) {
			$_SESSION["rtwi_auth"] = 1;
			$_SESSION["rtwi_nick"] = $_REQUEST["loginname"];
			$_SESSION["rtwi_port"] = $users[$_REQUEST["loginname"]];

			settype( $_SESSION["rtwi_port"], "int" );

			$_SESSION["rtwi_err"] = "succlogin";
			header( "location: {$url["index"]}" );
			exit;
		} else {
			$_SESSION["rtwi_err"] = "badlogin";
			header( "location: {$url["index"]}" );
			exit;
		}

		break;
	}
	case "logout" : { // logout
		$_SESSION["rtwi_auth"] = 0;
		$_SESSION["rtwi_nick"] = "";
		$_SESSION["rtwi_port"] = 0;
		$_SESSION["rtwi_view"] = "";
		$_SESSION["rtwi_refresh"] = 0;

		unset( $_SESSION["rtwi_auth"] );
		unset( $_SESSION["rtwi_nick"] );
		unset( $_SESSION["rtwi_port"] );
		unset( $_SESSION["rtwi_view"] );
		unset( $_SESSION["rtwi_refresh"] );

		$_SESSION["rtwi_err"] = "succlogout";
		header( "location: {$url["index"]}" );
		exit;

		break;
	}
	case "changeview" : { // change view
		if ( isset( $_REQUEST["viewtype"] ) && $_REQUEST["viewtype"] != "" ) {
			switch ( $_REQUEST["viewtype"] ) {
				case "name" : {
					$_SESSION["rtwi_view"] = "name";
					break;
				}
				case "started" : {
					$_SESSION["rtwi_view"] = "started";
					break;
				}
				case "stopped" : {
					$_SESSION["rtwi_view"] = "stopped";
					break;
				}
				case "complete" : {
					$_SESSION["rtwi_view"] = "complete";
					break;
				}
				case "incomplete" : {
					$_SESSION["rtwi_view"] = "incomplete";
					break;
				}
				case "hashing" : {
					$_SESSION["rtwi_view"] = "hashing";
					break;
				}
				case "seeding" : {
					$_SESSION["rtwi_view"] = "seeding";
					break;
				}
				default : {
					$_SESSION["rtwi_view"] = "default";
					break;
				}
			}

			setcookie( "rtwi_view", $_SESSION["rtwi_view"], time() + 60 * 60 * 24 * 30 );

			$_SESSION["rtwi_err"] = "succviewchange";
			header( "location: {$url["index"]}" );
			exit;
		} else {
			$_SESSION["rtwi_err"] = "badviewtype";
			header( "location: {$url["index"]}" );
			exit;
		}

		break;
	}
	case "changerefresh" : { // change view
		if ( isset( $_REQUEST["refreshrate"] ) && $_REQUEST["refreshrate"] != "" ) {
			$refreshrate = $_REQUEST["refreshrate"];
			settype( $refreshrate, "int" );
			if ( $refreshrate < 5 ) {
				$refreshrate = 0;
			}

			$_SESSION["rtwi_refresh"] = $refreshrate;

			setcookie( "rtwi_refresh", $_SESSION["rtwi_refresh"], time() + 60 * 60 * 24 * 30 );

			$_SESSION["rtwi_err"] = "succrefreshchange";
			header( "location: {$_SESSION["rtwi_lastpage"]}" );
			exit;
		} else {
			$_SESSION["rtwi_err"] = "badrefreshrate";
			header( "location: {$_SESSION["rtwi_lastpage"]}" );
			exit;
		}

		break;
	}
	case "addtorrent" : { // add a torrent
		if ( !isset( $_REQUEST["tfmethod"] ) || !in_array( $_REQUEST["tfmethod"], array( "url", "file" ) ) ) {
			$_SESSION["rtwi_err"] = "badtfmethod";
			header( "location: {$url["index"]}?mod=addtorrent" );
			exit;
		}

		$request = xmlrpc_encode_request( "get_directory", array() );
		$response = xmlrpc_call( $xmlrpc_array, $request );
		$response = str_replace( "i8", "double", $response );
		$directory = xmlrpc_decode( $response );
		if ( substr( $directory, -1 ) == "/" ) {
			$directory = substr( $directory, 0, -1 );
		}
		if ( in_array( "..", split( "/", $directory ) ) || in_array( ".", split( "/", $directory ) ) ) {
			$_SESSION["rtwi_err"] = "badrtdirectory";
			header( "location: {$url["index"]}?mod=addtorrent" );
			exit;
		} elseif ( substr( $directory, 0, 2 ) == "./" ) {
			$directory = substr( $directory, 2 );
			$directory = "{$home_path}{$_SESSION["rtwi_nick"]}/{$directory}";
		} elseif ( substr( $directory, 0, strlen( "{$home_path}{$_SESSION["rtwi_nick"]}" ) ) == "{$home_path}{$_SESSION["rtwi_nick"]}" ) {
			$directory = "{$directory}";
		} else {
			$_SESSION["rtwi_err"] = "badrtdirectory";
			header( "location: {$url["index"]}?mod=addtorrent" );
			exit;
		}
		$directory = str_replace( "//", "/", $directory );

		if ( $_REQUEST["tfmethod"] == "url" ) {
			if ( !isset( $_REQUEST["torrenturl"] ) || $_REQUEST["torrenturl"] == "" ) {
				$_SESSION["rtwi_err"] = "notorrenturl";
				header( "location: {$url["index"]}?mod=addtorrent" );
				exit;
			} elseif ( substr( $_REQUEST["torrenturl"], 0, 7 ) != "http://" ) {
				$_SESSION["rtwi_err"] = "notanurl";
				header( "location: {$url["index"]}?mod=addtorrent" );
				exit;
			}
			$torrent = $_REQUEST["torrenturl"];

			$bt_data = new bittorrent_handler( file_get_contents( $torrent ), "" );
			$bt_data->decode_data();
			$torrent_content = $bt_data->fetch_content();

			$bt_content = new bittorrent_handler( "", $torrent_content["value"]["info"] );
			$bt_content->encode_content();
			$newhash = strtoupper( sha1( $bt_content->fetch_data() ) );
		} else {
			if ( !isset( $_FILES ) || !is_array( $_FILES ) ) {
				$_SESSION["rtwi_err"] = "notorrentfileuploaded";
				header( "location: {$url["index"]}?mod=addtorrent" );
				exit;
			}
			switch ( $_FILES["torrentfile"]["error"] ) {
				case 0 : {
					if ( is_uploaded_file( $_FILES["torrentfile"]["tmp_name"] ) ) {
						$prefix = time() . mt_rand();
						$uploadpath = "{$directory}/!rtwi_files/{$prefix}_{$_FILES["torrentfile"]["name"]}";

						if ( !is_dir( $directory ) && !@mkdir( $directory, 0777 ) ) {
							$_SESSION["rtwi_err"] = "notrtfdircreated";
							header( "location: {$url["index"]}?mod=addtorrent" );
							exit;
						}

						if ( @copy( $_FILES["torrentfile"]["tmp_name"], $uploadpath ) ) {
							chmod( $uploadpath, 0666 );
							$torrent = $uploadpath;
						} else {
							if ( !is_dir( $directory ) ) {
								$_SESSION["rtwi_err"] = "notrtfdircreated";
								header( "location: {$url["index"]}?mod=addtorrent" );
								exit;
							} else {
								$_SESSION["rtwi_err"] = "notrtfdirwriteright";
								header( "location: {$url["index"]}?mod=addtorrent" );
								exit;
							}
						}
					} else {
						print "Possible file upload attack!\n";
					}

					break;
				}
				case 1 : {
					$_SESSION["rtwi_err"] = "rtfileinisize";
					header( "location: {$url["index"]}?mod=addtorrent" );
					exit;
				
					break;
				}
				case 2 : {
					$_SESSION["rtwi_err"] = "rtfileformsize";
					header( "location: {$url["index"]}?mod=addtorrent" );
					exit;
				
					break;
				}
				case 3 : {
					$_SESSION["rtwi_err"] = "rtfilepartial";
					header( "location: {$url["index"]}?mod=addtorrent" );
					exit;
				
					break;
				}
				case 4 : {
					$_SESSION["rtwi_err"] = "rtfilenofile";
					header( "location: {$url["index"]}?mod=addtorrent" );
					exit;
				
					break;
				}
				case 6 : {
					$_SESSION["rtwi_err"] = "rtfilenotmpdir";
					header( "location: {$url["index"]}?mod=addtorrent" );
					exit;
				
					break;
				}
				case 7 : {
					$_SESSION["rtwi_err"] = "rtfilenowrite";
					header( "location: {$url["index"]}?mod=addtorrent" );
					exit;
				
					break;
				}
				default : {
					$_SESSION["rtwi_err"] = "rtfileother";
					header( "location: {$url["index"]}?mod=addtorrent" );
					exit;
				
					break;
				}
			}

			$bt_data = new bittorrent_handler( file_get_contents( $uploadpath ), "" );
			$bt_data->decode_data();
			$torrent_content = $bt_data->fetch_content();

			$bt_content = new bittorrent_handler( "", $torrent_content["value"]["info"] );
			$bt_content->encode_content();
			$newhash = strtoupper( sha1( $bt_content->fetch_data() ) );
		}

		$request = xmlrpc_encode_request( "load", array( $torrent ) );
		$response = xmlrpc_call( $xmlrpc_array, $request );

		$i = 0;
		do {
			$request = xmlrpc_encode_request( "d.get_directory", array( $newhash ) );
			$response = xmlrpc_call( $xmlrpc_array, $request );
			$response = str_replace( "i8", "double", $response );
			$response = xmlrpc_decode( $response );
			sleep( 1 );
			$i++;
		} while ( $i < 10 && is_array( $response ) );

		$dlpath = $_REQUEST["dlpath"];
		if ( substr( $dlpath, 0, 1 ) == "/" ) {
			$dlpath = substr( $dlpath, 1 );
		}
		if ( substr( $dlpath, -1 ) == "/" ) {
			$dlpath = substr( $dlpath, 0, -1 );
		}
		if ( in_array( "..", split( "/", $dlpath ) ) || in_array( ".", split( "/", $dlpath ) ) ) {
			$_SESSION["rtwi_err"] = "badatpath";
			header( "location: {$url["index"]}?mod=addtorrent" );
			exit;
		}

		if ( $dlpath != "" ) {
			$dlpath = "{$directory}/{$dlpath}";
			$request = xmlrpc_encode_request( "d.set_directory", array( $newhash, $dlpath ) );
			$response = xmlrpc_call( $xmlrpc_array, $request );
		}

		if ( isset( $_REQUEST["torrentstart"] ) && $_REQUEST["torrentstart"] == "start" ) {
			$request = xmlrpc_encode_request( "d.start", array( $newhash ) );
			$response = xmlrpc_call( $xmlrpc_array, $request );
		}

		$_SESSION["rtwi_err"] = "succtorrentload";
		header( "location: {$url["index"]}" );
		exit;

		break;
	}
	case "torrentstart" : { // start a torrent
		$request = xmlrpc_encode_request( "download_list", array() );
		$response = xmlrpc_call( $xmlrpc_array, $request );
		$response = str_replace( "i8", "double", $response );
		$torrents = xmlrpc_decode( $response );

		if ( !in_array( $hash, $torrents ) ) {
			$_SESSION["rtwi_err"] = "nohashfound";
			header( "location: {$url["index"]}" );
			exit;
		}

		$request = xmlrpc_encode_request( "d.start", array( $hash ) );
		$response = xmlrpc_call( $xmlrpc_array, $request );

		sleep( 1 );

		$_SESSION["rtwi_err"] = "succtorrentstart";
		header( "location: {$url["index"]}" );
		exit;

		break;
	}
	case "torrentopen" : { // open a torrent
		$request = xmlrpc_encode_request( "download_list", array() );
		$response = xmlrpc_call( $xmlrpc_array, $request );
		$response = str_replace( "i8", "double", $response );
		$torrents = xmlrpc_decode( $response );

		if ( !in_array( $hash, $torrents ) ) {
			$_SESSION["rtwi_err"] = "nohashfound";
			header( "location: {$url["index"]}" );
			exit;
		}

		$request = xmlrpc_encode_request( "d.open", array( $hash ) );
		$response = xmlrpc_call( $xmlrpc_array, $request );

		sleep( 1 );

		$_SESSION["rtwi_err"] = "succtorrentopen";
		header( "location: {$url["index"]}" );
		exit;

		break;
	}
	case "torrentstop" : { // stop a torrent
		$request = xmlrpc_encode_request( "download_list", array() );
		$response = xmlrpc_call( $xmlrpc_array, $request );
		$response = str_replace( "i8", "double", $response );
		$torrents = xmlrpc_decode( $response );

		if ( !in_array( $hash, $torrents ) ) {
			$_SESSION["rtwi_err"] = "nohashfound";
			header( "location: {$url["index"]}" );
			exit;
		}

		$request = xmlrpc_encode_request( "d.stop", array( $hash ) );
		$response = xmlrpc_call( $xmlrpc_array, $request );

		sleep( 1 );

		$_SESSION["rtwi_err"] = "succtorrentstop";
		header( "location: {$url["index"]}" );
		exit;

		break;
	}
	case "torrentclose" : { // close a torrent
		$request = xmlrpc_encode_request( "download_list", array() );
		$response = xmlrpc_call( $xmlrpc_array, $request );
		$response = str_replace( "i8", "double", $response );
		$torrents = xmlrpc_decode( $response );

		if ( !in_array( $hash, $torrents ) ) {
			$_SESSION["rtwi_err"] = "nohashfound";
			header( "location: {$url["index"]}" );
			exit;
		}

		$request = xmlrpc_encode_request( "d.close", array( $hash ) );
		$response = xmlrpc_call( $xmlrpc_array, $request );

		sleep( 1 );

		$_SESSION["rtwi_err"] = "succtorrentclose";
		header( "location: {$url["index"]}" );
		exit;

		break;
	}
	case "torrentcheckhash" : { // check hash for a torrent
		$request = xmlrpc_encode_request( "download_list", array() );
		$response = xmlrpc_call( $xmlrpc_array, $request );
		$response = str_replace( "i8", "double", $response );
		$torrents = xmlrpc_decode( $response );

		if ( !in_array( $hash, $torrents ) ) {
			$_SESSION["rtwi_err"] = "nohashfound";
			header( "location: {$url["index"]}" );
			exit;
		}

		$request = xmlrpc_encode_request( "d.check_hash", array( $hash ) );
		$response = xmlrpc_call( $xmlrpc_array, $request );

		sleep( 1 );

		$_SESSION["rtwi_err"] = "succtorrentcheckhash";
		header( "location: {$url["index"]}" );
		exit;

		break;
	}
	case "torrenterase" : { // erase a torrent
		$request = xmlrpc_encode_request( "download_list", array() );
		$response = xmlrpc_call( $xmlrpc_array, $request );
		$response = str_replace( "i8", "double", $response );
		$torrents = xmlrpc_decode( $response );

		if ( !in_array( $hash, $torrents ) ) {
			$_SESSION["rtwi_err"] = "nohashfound";
			header( "location: {$url["index"]}" );
			exit;
		}

		$request = xmlrpc_encode_request( "d.erase", array( $hash ) );
		$response = xmlrpc_call( $xmlrpc_array, $request );

		sleep( 1 );

		$_SESSION["rtwi_err"] = "succtorrenterase";
		header( "location: {$url["index"]}" );
		exit;

		break;
	}
	case "changepriority" : { // set priority
		$request = xmlrpc_encode_request( "download_list", array() );
		$response = xmlrpc_call( $xmlrpc_array, $request );
		$response = str_replace( "i8", "double", $response );
		$torrents = xmlrpc_decode( $response );

		if ( !in_array( $hash, $torrents ) ) {
			$_SESSION["rtwi_err"] = "nohashfound";
			header( "location: {$url["index"]}" );
			exit;
		}

		if ( isset( $_REQUEST["priority"] ) ) {
			$priority = $_REQUEST["priority"];
		} else {
			$_SESSION["rtwi_err"] = "nopriorityfound";
			header( "location: {$url["index"]}" );
			exit;
		}

		if ( !in_array( $priority, array( 0, 1, 2, 3 ) ) ) {
			$_SESSION["rtwi_err"] = "badpriorityfoiund";
			header( "location: {$url["index"]}" );
			exit;
		}

		$request = xmlrpc_encode_request( "d.set_priority", array( $hash, $priority ) );
		$response = xmlrpc_call( $xmlrpc_array, $request );

		sleep( 1 );

		$_SESSION["rtwi_err"] = "succprioritychange";
		header( "location: {$url["index"]}" );
		exit;

		break;
	}
	case "changefilepriority" : { // set file priority
		$request = xmlrpc_encode_request( "download_list", array() );
		$response = xmlrpc_call( $xmlrpc_array, $request );
		$response = str_replace( "i8", "double", $response );
		$torrents = xmlrpc_decode( $response );

		if ( isset( $_REQUEST["ajax"] ) && $_REQUEST["ajax"] == "true" ) {
			$tourl = "{$url["index"]}?mod=torrent&hash={$hash}&page=files&ajax=true";
		} else {
			$tourl = "{$url["index"]}?mod=torrent&hash={$hash}&page=files";
		}

		if ( !in_array( $hash, $torrents ) ) {
			$_SESSION["rtwi_err"] = "nohashfound";
			header( "location: {$tourl}" );
			exit;
		}

		if ( isset( $_REQUEST["id"] ) ) {
			$id = $_REQUEST["id"];
			settype( $id, "int" );
		} else {
			$_SESSION["rtwi_err"] = "noidfound";
			header( "location: {$tourl}" );
			exit;
		}

		$request = xmlrpc_encode_request( "d.get_size_files", array( $hash ) );
		$response = xmlrpc_call( $xmlrpc_array, $request );
		$response = str_replace( "i8", "double", $response );
		$response = xmlrpc_decode( $response );

		if ( $id < 0 || $id > $response ) {
			$_SESSION["rtwi_err"] = "badidfound";
			header( "location: {$tourl}" );
			exit;
		}

		if ( isset( $_REQUEST["filepriority"] ) ) {
			$filepriority = $_REQUEST["filepriority"];
			settype( $fpriority, "int" );
		} else {
			$_SESSION["rtwi_err"] = "nopriorityfound";
			header( "location: {$tourl}" );
			exit;
		}

		if ( !in_array( $filepriority, array( 0, 1, 2 ) ) ) {
			$_SESSION["rtwi_err"] = "badpriorityfound";
			header( "location: {$tourl}" );
			exit;
		}

		$request = xmlrpc_encode_request( "f.set_priority", array( $hash, $id, $filepriority ) );
		$response = xmlrpc_call( $xmlrpc_array, $request );

		$request = xmlrpc_encode_request( "d.update_priorities ", array( $hash ) );
		$response = xmlrpc_call( $xmlrpc_array, $request );

		sleep( 1 );

		$_SESSION["rtwi_err"] = "succfileprioritychange";
		header( "location: {$tourl}" );
		exit;

		break;
	}
	case "changetrackerenabled" : { // set if tracker is enabled
		$request = xmlrpc_encode_request( "download_list", array() );
		$response = xmlrpc_call( $xmlrpc_array, $request );
		$response = str_replace( "i8", "double", $response );
		$torrents = xmlrpc_decode( $response );

		if ( isset( $_REQUEST["ajax"] ) && $_REQUEST["ajax"] == "true" ) {
			$tourl = "{$url["index"]}?mod=torrent&hash={$hash}&page=trackers&ajax=true";
		} else {
			$tourl = "{$url["index"]}?mod=torrent&hash={$hash}&page=trackers";
		}

		if ( !in_array( $hash, $torrents ) ) {
			$_SESSION["rtwi_err"] = "nohashfound";
			header( "location: {$tourl}" );
			exit;
		}

		if ( isset( $_REQUEST["id"] ) ) {
			$id = $_REQUEST["id"];
			settype( $id, "int" );
		} else {
			$_SESSION["rtwi_err"] = "noidfound";
			header( "location: {$tourl}" );
			exit;
		}

		$request = xmlrpc_encode_request( "d.get_size_trackers", array( $hash ) );
		$response = xmlrpc_call( $xmlrpc_array, $request );
		$response = str_replace( "i8", "double", $response );
		$response = xmlrpc_decode( $response );

		if ( $id < 0 || $id > $response ) {
			$_SESSION["rtwi_err"] = "badidfound";
			header( "location: {$tourl}" );
			exit;
		}

		if ( isset( $_REQUEST["trackerenabled"] ) ) {
			$trackerenabled = $_REQUEST["trackerenabled"];
			settype( $trackerenabled, "int" );
		} else {
			$_SESSION["rtwi_err"] = "novaluefound";
			header( "location: {$tourl}" );
			exit;
		}

		if ( !in_array( $trackerenabled, array( 0, 1 ) ) ) {
			$_SESSION["rtwi_err"] = "badvaluefound";
			header( "location: {$tourl}" );
			exit;
		}

		$request = xmlrpc_encode_request( "t.set_enabled", array( $hash, $id, $trackerenabled ) );
		$response = xmlrpc_call( $xmlrpc_array, $request );

		sleep( 1 );

		$_SESSION["rtwi_err"] = "succtrackerenabledchange";
		header( "location: {$tourl}" );
		exit;

		break;
	}
	default : {
		$_SESSION["rtwi_err"] = "noinputmod";
		header( "location: {$url["index"]}" );
		exit;

		break;
	}
}

?>
