﻿<xsl:stylesheet version="1.1"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                lang="hu">
 <xsl:output method="xml"
             indent="no"
	     encoding="utf-8" />

 <xsl:template match="root">
  <xsl:apply-templates select="err" />
  <xsl:apply-templates select="torrents" />
 </xsl:template>

 <xsl:template match="err">
  <div id="aerr">
   <span title="Click to hide" onmouseover="this.style.cursor='pointer';" onclick="document.getElementById( 'aerr' ).style.display='none';">
    <xsl:value-of select="errmsg" />
   </span>
  </div>
 </xsl:template>

 <xsl:template match="torrents">
  <ul>
   <xsl:apply-templates select="torrent_info_root" />
   <xsl:apply-templates select="torrent_files_root" />
   <xsl:apply-templates select="torrent_trackers_root" />
  </ul>
 </xsl:template>

 <xsl:template match="torrent_info_root">
  <xsl:apply-templates select="torrent_info" />
 </xsl:template>

 <xsl:template match="torrent_info">
  <li class="line">
   <div class="infoleft">
    <xsl:text>Name:</xsl:text>
   </div>
   <div class="inforight">
    <xsl:value-of select="d_name" />
   </div>
   <div class="clr"></div>
  </li>
  <li class="line spacer">
   <div class="infoleft">
    <xsl:text>Info hash:</xsl:text>
   </div>
   <div class="inforight">
    <xsl:value-of select="d_hash" />
   </div>
   <div class="clr"></div>
  </li>
  <li class="line">
   <div class="infoleft">
    <xsl:text>Directory:</xsl:text>
   </div>
   <div class="inforight">
    <xsl:value-of select="d_directory/@value" />
   </div>
   <div class="clr"></div>
  </li>
  <li class="line">
   <div class="infoleft">
    <xsl:text>Tied to file:</xsl:text>
   </div>
   <div class="inforight">
    <xsl:choose>
     <xsl:when test="d_tied_to_file != ''">
      <xsl:value-of select="d_tied_to_file" />
     </xsl:when>
     <xsl:otherwise>
      <xsl:text>No</xsl:text>
     </xsl:otherwise>
    </xsl:choose>
   </div>
   <div class="clr"></div>
  </li>
  <li class="line spacer">
   <div class="infoleft">
    <xsl:text>File stats:</xsl:text>
   </div>
   <div class="inforight">
    <xsl:value-of select="d_is_multi_file/@value" />
    <xsl:choose>
     <xsl:when test="d_is_multi_file != 0">
      <xsl:text> </xsl:text>
      <xsl:value-of select="d_size_files" />
      <xsl:text> files</xsl:text>
     </xsl:when>
    </xsl:choose>
   </div>
   <div class="clr"></div>
  </li>
  <li class="line">
   <div class="infoleft">
    <xsl:text>Chunks:</xsl:text>
   </div>
   <div class="inforight">
    <xsl:value-of select="d_completed_chunks" />
    <xsl:text> / </xsl:text>
    <xsl:value-of select="d_chunks_hashed" />
    <xsl:text> * </xsl:text>
    <xsl:value-of select="d_chunk_size/@value" />
    <xsl:text> </xsl:text>
    <xsl:value-of select="d_chunk_size/@suffix" />
   </div>
   <div class="clr"></div>
  </li>
  <li class="line">
   <div class="infoleft">
    <xsl:text>Priority:</xsl:text>
   </div>
   <div class="inforight">
    <xsl:value-of select="d_priority/@value" />
   </div>
   <div class="clr"></div>
  </li>
  <li class="line spacer">
   <div class="infoleft">
    <xsl:text>State changed:</xsl:text>
   </div>
   <div class="inforight">
    <xsl:value-of select="d_state_changed/@value" />
   </div>
   <div class="clr"></div>
  </li>
  <li class="line spacer">
   <div class="infoleft">
    <xsl:text>Free diskspace:</xsl:text>
   </div>
   <div class="inforight">
    <xsl:value-of select="d_free_diskspace/@value" />
    <xsl:text> </xsl:text>
    <xsl:value-of select="d_free_diskspace/@suffix" />
   </div>
   <div class="clr"></div>
  </li>
  <li class="line">
   <div class="infoleft">
    <xsl:text>Connection type:</xsl:text>
   </div>
   <div class="inforight">
    <xsl:value-of select="d_connection_current/@value" />
   </div>
   <div class="clr"></div>
  </li>
  <li class="line">
   <div class="infoleft">
    <xsl:text>Leechers:</xsl:text>
   </div>
   <div class="inforight">
    <xsl:value-of select="d_peers_accounted" />
   </div>
   <div class="clr"></div>
  </li>
  <li class="line spacer">
   <div class="infoleft">
    <xsl:text>Seeders:</xsl:text>
   </div>
   <div class="inforight">
    <xsl:value-of select="d_peers_complete" />
   </div>
   <div class="clr"></div>
  </li>
  <li class="line">
   <div class="infoleft">
    <xsl:text>Upload:</xsl:text>
   </div>
   <div class="inforight">
    <xsl:value-of select="d_up_rate/@value" />
    <xsl:text> </xsl:text>
    <xsl:value-of select="d_up_rate/@suffix" />
    <xsl:text> / </xsl:text>
    <xsl:value-of select="d_up_total/@value" />
    <xsl:text> </xsl:text>
    <xsl:value-of select="d_up_total/@suffix" />
   </div>
   <div class="clr"></div>
  </li>
  <li class="line">
   <div class="infoleft">
    <xsl:text>Download:</xsl:text>
   </div>
   <div class="inforight">
    <xsl:value-of select="d_down_rate/@value" />
    <xsl:text> </xsl:text>
    <xsl:value-of select="d_down_rate/@suffix" />
    <xsl:text> / </xsl:text>
    <xsl:value-of select="d_down_total/@value" />
    <xsl:text> </xsl:text>
    <xsl:value-of select="d_down_total/@suffix" />
   </div>
   <div class="clr"></div>
  </li>
  <li class="line">
   <div class="infoleft">
    <xsl:text>Skipped:</xsl:text>
   </div>
   <div class="inforight">
    <xsl:value-of select="d_skip_rate/@value" />
    <xsl:text> </xsl:text>
    <xsl:value-of select="d_skip_rate/@suffix" />
    <xsl:text> / </xsl:text>
    <xsl:value-of select="d_skip_total/@value" />
    <xsl:text> </xsl:text>
    <xsl:value-of select="d_skip_total/@suffix" />
   </div>
   <div class="clr"></div>
  </li>
 </xsl:template>

 <xsl:template match="torrent_files_root">
  <xsl:apply-templates select="torrent_files" />
 </xsl:template>

 <xsl:template match="torrent_files">
  <xsl:apply-templates select="files_root" />
 </xsl:template>

 <xsl:template match="torrent_trackers_root">
  <xsl:apply-templates select="torrent_trackers" />
 </xsl:template>

 <xsl:template match="torrent_trackers">
  <xsl:apply-templates select="tracker" />
 </xsl:template>

 <xsl:template match="files_root">
  <xsl:apply-templates select="directory" />
  <xsl:apply-templates select="file" />
 </xsl:template>

 <xsl:template match="directory">
  <li>
   <a title="Click to open" onmouseover="this.style.cursor='pointer';" onclick="if ( this.parentNode.getElementsByTagName( 'ul' ).item( 0 ).style.display == '' ) {{ this.parentNode.getElementsByTagName( 'ul' ).item( 0 ).style.display = 'none' }} else {{ this.parentNode.getElementsByTagName( 'ul' ).item( 0 ).style.display = '' }};"><xsl:value-of select="@dirname" /></a>
   <ul class="directory" style="display: none;">
    <xsl:apply-templates select="directory" />
    <xsl:apply-templates select="file" />
   </ul>
  </li>
 </xsl:template>

 <xsl:template match="file">
  <li onmouseover="this.style.background='#eeeeee';" onmouseout="this.style.background='';">
   <div class="fname">
    <span title="Last touched: {f_last_touched}">
     <xsl:value-of select="@filename" />
    </span>
   </div>
   <div class="fpercentage">
    <span title="{f_percentage/@value} percent completed">
     <xsl:text>[</xsl:text>
     <xsl:value-of select="f_percentage/@value" />
     <xsl:text> %]</xsl:text>
    </span>
   </div>
   <div class="fpriority">
    <form class="changefilepriorityform" name="changefilepriorityform_{@id}" method="post" action="{/root/iurl}?mod=changefilepriority&amp;hash={/root/hash}&amp;id={@id}">
     <xsl:text>[</xsl:text>
     <select class="whiteselect" name="filepriority" title="Select file priority" onchange="loadcontent_filepriority( '{/root/iurl}', '{/root/hash}', '{@id}', this.value );">
      <xsl:choose>
       <xsl:when test="f_priority = 0">
        <option value="0" title="Off" selected="selected">Off</option>
        <option value="1" title="Normal">Normal</option>
        <option value="2" title="High">High</option>
       </xsl:when>
       <xsl:when test="f_priority = 2">
        <option value="0" title="Off">Off</option>
        <option value="1" title="Normal">Normal</option>
        <option value="2" title="High" selected="selected">High</option>
       </xsl:when>
       <xsl:otherwise>
        <option value="0" title="Off">Off</option>
        <option value="1" title="Normal" selected="selected">Normal</option>
        <option value="2" title="High">High</option>
       </xsl:otherwise>
      </xsl:choose>
     </select>
     <xsl:text>]</xsl:text>
    </form>
   </div>
   <div class="fsize">
    <span title="File size">
     <xsl:value-of select="f_size_bytes/@value" />
     <xsl:text> </xsl:text>
     <xsl:value-of select="f_size_bytes/@suffix" />
    </span>
   </div>
   <div class="fchunks">
    <span title="Chunks">
     <xsl:choose>
      <xsl:when test="f_range_first != f_range_second">
       <xsl:value-of select="f_range_first" />
       <xsl:text> - </xsl:text>
       <xsl:value-of select="f_range_second" />
      </xsl:when>
      <xsl:otherwise>
       <xsl:value-of select="f_range_first" />
      </xsl:otherwise>
     </xsl:choose>
    </span>
   </div>
   <xsl:choose>
    <xsl:when test="f_percentage = 1">
     <div class="fdownload">
      <a href="?mod=getfile&amp;hash={/root/hash}&amp;id={@id}" title="Download file">Download</a>
     </div>
    </xsl:when>
   </xsl:choose>
   <div class="clr"></div>
  </li>
 </xsl:template>

 <xsl:template match="tracker">
  <li>
   <ul>
    <li>
     <div class="tgroup">
      <span title="Tracker group">
       <xsl:value-of select="t_group" />
       <xsl:text>:</xsl:text>
      </span>
     </div>
     <div class="turl">
      <span title="Type: {t_type/@value}">
       <xsl:value-of select="t_url" />
      </span>
     </div>
     <div class="clr"></div>
    </li>
    <li>
     <div class="tfocus">
      <xsl:choose>
       <xsl:when test="root/tottents/torrent_trackers_root/torrent_trackers/d_tracker_focus = @id">
        <xsl:text>Focus: Yes</xsl:text>
       </xsl:when>
       <xsl:otherwise>
        <xsl:text>Focus: No</xsl:text>
       </xsl:otherwise>
      </xsl:choose>
     </div>
     <div class="tenabled">
      <form class="changetrackerenabledform" name="changetrackerenabledfor_{@id}" method="post" action="{/root/iurl}?mod=changetrackerenabled&amp;hash={/root/hash}&amp;id={@id}">
       <xsl:text>Enabled: </xsl:text>
       <select class="whiteselect" name="rackerenabled" title="Select if tracker is enabled" onchange="loadcontent_trackerenabled( '{/root/iurl}', '{/root/hash}', '{@id}', this.value )">
        <xsl:choose>
         <xsl:when test="t_enabled = 0">
          <option value="1" title="Yes">Yes</option>
          <option value="0" title="No" selected="selected">No</option>
         </xsl:when>
         <xsl:otherwise>
          <option value="1" title="Yes" selected="selected">Yes</option>
          <option value="0" title="No">No</option>
         </xsl:otherwise>
        </xsl:choose>
       </select>
      </form>
     </div>
     <div class="topen">
      <xsl:text>Open: </xsl:text>
      <xsl:choose>
       <xsl:when test="t_open != 0">
        <xsl:text>Yes</xsl:text>
       </xsl:when>
       <xsl:otherwise>
        <xsl:text>No</xsl:text>
       </xsl:otherwise>
      </xsl:choose>
     </div>
     <div class="tpeers">
      <xsl:text>S/L: </xsl:text>
      <xsl:value-of select="t_scrape_complete" />
      <xsl:text> / </xsl:text>
      <xsl:value-of select="t_scrape_incomplete" />
     </div>
     <div class="clr"></div>
    </li>
    <li>
     <div class="tscrape">
      <span title="Minimum interval: {t_min_interval/@value} - Normal interval: {t_normal_interval/@value}">
       <xsl:text>Last time scraped: </xsl:text>
       <xsl:value-of select="t_scrape_time_last/@value" />
      </span>
     </div>
     <div class="clr"></div>
    </li>
   </ul>
  </li>
 </xsl:template>

</xsl:stylesheet>
