﻿<xsl:stylesheet version="1.1"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                lang="hu">
 <xsl:output method="xml"
             indent="no"
             encoding="utf-8"
             doctype-public="-//W3C//DTD XHTML 1.0 Transitional//EN"
             doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd" />

 <xsl:template match="root">
  <html lang="hu">
   <head>
    <meta http-equiv="content-type" content="text/html; charset=utf-8" />
    <meta http-equiv="content-language" content="hu" />
    <meta http-equiv="cache-control" content="no-store, no-cache, must-revalidate, post-check=0, pre-check=0" />
    <meta http-equiv="pragma" content="no-cache" />
    <meta http-equiv="expires" content="thu, 1 jan 1970 00:00:00 gmt" />
    <meta http-equiv="imagetoolbar" content="no" />  
    <xsl:choose>
     <xsl:when test="/root/torrents/@refreshrate != 0">
      <meta http-equiv="refresh" content="{/root/torrents/@refreshrate}; url={curl}" />  
     </xsl:when>
    </xsl:choose>
    <meta name="author" content="{/root/labels/author}" />
    <meta name="description" content="{/root/labels/description}" />
    <meta name="keywords" content="{/root/labels/keywords}" />
    <meta name="doc-type" content="web page" />
    <meta name="rating" content="general" />
    <meta name="robots" content="all" />
    <link rel="stylesheet" type="text/css" href="themes/default_ajax/inc/style.css" />
    <script type="text/javascript" src="themes/default_ajax/inc/afunc.js"></script>
    <script type="text/javascript" src="themes/default_ajax/inc/hfunc.js"></script>
    <title><xsl:value-of select="/root/labels/title" /></title>
   </head>
   <body onload="toggle( '{/root/mod}_{/root/page}' );">
    <div id="top">
    </div>
    <div id="main">
     <div id="balh">
      <div id="fomenu">
       <ul>
        <li class="first"><a href="{/root/url}" title="Torrents">Torrents</a></li>
        <xsl:choose>
         <xsl:when test="/root/mod = 'torrent'">
          <li class="submenu notshown">
           <a href="?mod=torrent&amp;hash={/root/hash}&amp;page=peers" title="Peer list">Peer list</a>
          </li>
          <li class="submenu">
           <a href="?mod=torrent&amp;hash={/root/hash}&amp;page=info" title="Info">Info</a>
          </li>
          <li class="submenu">
           <a href="?mod=torrent&amp;hash={/root/hash}&amp;page=files" title="File list">File list</a>
          </li>
          <li class="submenu">
           <a href="?mod=torrent&amp;hash={/root/hash}&amp;page=trackers" title="Tracker list">Tracker list</a>
          </li>
          <li class="submenu notshown">
           <a href="?mod=torrent&amp;hash={/root/hash}&amp;page=chunks" title="Chunks seen">Chunks seen</a>
          </li>
          <li class="submenu notshown">
           <a href="?mod=torrent&amp;hash={/root/hash}&amp;page=transfers" title="Transfer list">Transfer list</a>
          </li>
         </xsl:when>
        </xsl:choose>
        <li><a href="?mod=addtorrent" title="Add torrent">Add torrent</a></li>
        <li><a href="?mod=serverinfo" title="Server info">Server info</a></li>
        <li><a href="{/root/iurl}?mod=logout" title="Logout">Logout</a></li>
       </ul>
      </div>
     </div>
     <div id="kozeph">
      <xsl:apply-templates select="err" />
      <xsl:apply-templates select="addtorrent" />
      <xsl:apply-templates select="torrents" />
     </div>
     <div class="clr1"></div>
    </div>
   </body>
  </html>
 </xsl:template>

 <xsl:template match="err">
  <div id="err">
   <span title="Click to hide" onmouseover="this.style.cursor='pointer';" onclick="document.getElementById( 'err' ).style.display='none';">
    <xsl:value-of select="errmsg" />
   </span>
  </div>
 </xsl:template>

 <xsl:template match="addtorrent">
  <form id="addtorrent" name="addtorrent" enctype="multipart/form-data" method="post" action="{/root/iurl}?mod=addtorrent">
   <ul class="tuform">
    <li>
     <div class="tufleft">Open from:</div>
     <div class="tufright">
      <select name="tfmethod" title="Open from" onchange="if ( this.value == 'url' ) {{ document.getElementById( 'torrenturl' ).style.display=''; document.getElementById( 'torrentfile' ).style.display='none'; }} else {{ document.getElementById( 'torrenturl' ).style.display='none'; document.getElementById( 'torrentfile' ).style.display=''; }}">
       <option value="file">File upload</option>
       <option value="url">URL</option>
      </select>
     </div>
     <div class="clr"></div>
    </li>
    <li id="torrentfile">
     <div class="tufleft">Torrent file:</div>
     <div class="tufright">
      <input type="hidden" name="MAX_FILE_SIZE" value="1000000" />
      <input type="file" name="torrentfile" title="Torrent File" value="" />
     </div>
     <div class="clr"></div>
    </li>
    <li id="torrenturl">
     <div class="tufleft">Torrent URL:</div>
     <div class="tufright">
      <input type="text" name="torrenturl" title="Torrent url" value="" />
     </div>
     <div class="clr"></div>
    </li>
    <li>
     <div class="tufleft">Start torrent:</div>
     <div class="tufright">
      <input type="checkbox" name="torrentstart" title="Start torrent after added" value="start" checked="checked" />
     </div>
     <div class="clr"></div>
    </li>
    <li>
     <div class="tufleft">Download to:</div>
     <div class="tufright">
      <input type="hidden" name="dlpath" value="{@path}" />
      <ul class="tufupload">
       <li onmouseover="this.style.background='#eeeeee';" onmouseout="this.style.background='';">
        <div class="tufpath">
         <a href="?mod=addtorrent&amp;path={@ppath}">..</a>
        </div>
        <div class="tufspace">
         <xsl:value-of select="@freespace_value" />
         <xsl:text> </xsl:text>
         <xsl:value-of select="@freespace_suffix" />
        </div>
        <div class="clr"></div>
       </li>
       <xsl:apply-templates select="dlpath" />
      </ul>
     </div>
     <div class="clr"></div>
    </li>
    <li class="formsend">
     <input class="inputok" type="submit" name="addtorrent" title="Add torrent" value="Add torrent" />
    </li>
   </ul>
  </form>
 </xsl:template>

 <xsl:template match="torrents">
  <ul>
   <li class="tline first">
    <xsl:apply-templates select="viewtypes" />
    <xsl:apply-templates select="refreshrates" />
    <div class="clr"></div>
   </li>
   <xsl:apply-templates select="torrent" />
   <xsl:apply-templates select="torrent_info_root" />
   <xsl:apply-templates select="torrent_files_root" />
   <xsl:apply-templates select="torrent_trackers_root" />
   <xsl:apply-templates select="server_info" />
   <li class="tline last">
    <div class="tthrottle">
     <xsl:text>[Throttle </xsl:text>
     <xsl:choose>
      <xsl:when test="upload_rate != 0">
       <span title="Upload limit">
        <xsl:value-of select="upload_rate/@value" />
        <xsl:text> </xsl:text>
        <xsl:value-of select="upload_rate/@suffix" />
       </span>
      </xsl:when>
      <xsl:otherwise>
       <span title="No upload limit">off</span>
      </xsl:otherwise>
     </xsl:choose>
     <xsl:text> / </xsl:text>
     <xsl:choose>
      <xsl:when test="download_rate != 0">
       <span title="Download limit">
        <xsl:value-of select="download_rate/@value" />
        <xsl:text> </xsl:text>
        <xsl:value-of select="download_rate/@suffix" />
       </span>
      </xsl:when>
      <xsl:otherwise>
       <span title="No download limit">off</span>
      </xsl:otherwise>
     </xsl:choose>
     <xsl:text>]</xsl:text>
    </div>
    <div class="trates_total">
     <xsl:text>[Rate </xsl:text>
     <span title="Upload speed">
      <xsl:value-of select="bytes_up/@value" />
      <xsl:text> </xsl:text>
      <xsl:value-of select="bytes_up/@suffix" />
     </span>
     <xsl:text> / </xsl:text>
     <span title="Download speed">
      <xsl:value-of select="bytes_down/@value" />
      <xsl:text> </xsl:text>
      <xsl:value-of select="bytes_down/@suffix" />
     </span>
     <xsl:text>]</xsl:text>
    </div>
    <div class="clr"></div>
   </li>
  </ul>
 </xsl:template>

 <xsl:template match="viewtypes">
  <form id="changeviewform" name="changeviewform" method="post" action="{/root/iurl}?mod=changeview">
   <xsl:text>[View: </xsl:text>
   <select class="whiteselect" name="viewtype" title="Select view type" onchange="window.location='{/root/iurl}?mod=changeview&amp;viewtype='+this.value;">
    <xsl:apply-templates select="viewtype" />
   </select>
   <xsl:text>]</xsl:text>
   <noscript>
    <input class="submit" id="vtsubmit" type="submit" name="vtsubmit" title="OK" value="OK" />
   </noscript>
  </form>
 </xsl:template>

 <xsl:template match="viewtype">
  <xsl:choose>
   <xsl:when test="/root/torrents/@viewtype = @value">
    <option value="{@value}" title="{@title}" selected="selected"><xsl:value-of select="@title" /></option>
   </xsl:when>
   <xsl:otherwise>
    <option value="{@value}" title="{@title}"><xsl:value-of select="@title" /></option>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>

 <xsl:template match="refreshrates">
  <form id="changerefreshform" name="changerefreshform" method="post" action="{/root/iurl}?mod=changerefresh">
   <xsl:text>[Refresh: </xsl:text>
   <select class="whiteselect" name="refreshrate" title="Select refresh rate" onchange="window.location='{/root/iurl}?mod=changerefresh&amp;refreshrate='+this.value;">
    <xsl:apply-templates select="refreshrate" />
   </select>
   <xsl:text>]</xsl:text>
   <noscript>
    <input class="submit" id="rrsubmit" type="submit" name="rrsubmit" title="OK" value="OK" />
   </noscript>
  </form>
 </xsl:template>

 <xsl:template match="refreshrate">
  <xsl:choose>
   <xsl:when test="/root/torrents/@refreshrate = @value">
    <option value="{@value}" title="{@title}" selected="selected"><xsl:value-of select="@title" /></option>
   </xsl:when>
   <xsl:otherwise>
    <option value="{@value}" title="{@title}"><xsl:value-of select="@title" /></option>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>

 <xsl:template match="torrent">
  <li class="tline">
   <div class="ticon">
    <xsl:choose>
     <xsl:when test="d_active != 0">
      <img class="icon" src="themes/default_ajax/pics/{d_connection_current}ing.png" alt="{d_connection_current}" title="{d_connection_current/@value} since {d_state_changed/@value}" />
     </xsl:when>
     <xsl:when test="d_hashing != 0">
      <img class="icon" src="themes/default_ajax/pics/hashing.png" alt="hashing" title="Hashing since {d_state_changed/@value}" />
     </xsl:when>
     <xsl:when test="d_complete != 0">
      <img class="icon" src="themes/default_ajax/pics/finished.png" alt="finished" title="Finished since {d_state_changed/@value}" />
     </xsl:when>
     <xsl:when test="d_open != 0">
      <img class="icon" src="themes/default_ajax/pics/stopped.png" alt="stopped" title="Stopped since {d_state_changed/@value}" />
     </xsl:when>
     <xsl:otherwise>
      <img class="icon" src="themes/default_ajax/pics/closed.png" alt="closed" title="Closed since {d_state_changed/@value}" />
     </xsl:otherwise>
    </xsl:choose>
   </div>
   <div class="tname">
    <a href="?mod=torrent&amp;hash={d_hash}" title="Details" onclick="if ( document.getElementById( 'torrent_{d_hash}' ).style.display == '' ) {{ document.getElementById( 'torrent_{d_hash}' ).style.display = 'none' }} else {{ document.getElementById( 'torrent_{d_hash}' ).style.display = ''}} return false;"><xsl:value-of select="d_name" /></a>
   </div>
   <div class="tops">
    <xsl:choose>
     <xsl:when test="d_hashing != 0">
      <xsl:value-of select="d_hashing/@value" />
     </xsl:when>
     <xsl:otherwise>
      <a href="{/root/iurl}?mod=torrentcheckhash&amp;hash={d_hash}" title="Check hash">Check hash</a>
     </xsl:otherwise>
    </xsl:choose>
    <xsl:choose>
     <xsl:when test="d_active != 0">
      <a href="{/root/iurl}?mod=torrentstop&amp;hash={d_hash}" title="Stop">Stop</a>
     </xsl:when>
     <xsl:otherwise>
      <xsl:choose>
       <xsl:when test="d_hashing != 0">
        <a href="{/root/iurl}?mod=torrentstop&amp;hash={d_hash}" title="Stop">Stop</a>
       </xsl:when>
       <xsl:otherwise>
        <a href="{/root/iurl}?mod=torrentstart&amp;hash={d_hash}" title="Start">Start</a>
       </xsl:otherwise>
      </xsl:choose>
     </xsl:otherwise>
    </xsl:choose>
    <xsl:choose>
     <xsl:when test="d_open = 0">
      <a href="{/root/iurl}?mod=torrentopen&amp;hash={d_hash}" title="Open">Open</a>
     </xsl:when>
     <xsl:otherwise>
      <a href="{/root/iurl}?mod=torrentclose&amp;hash={d_hash}" title="Close">Close</a>
     </xsl:otherwise>
    </xsl:choose>
    <a href="{/root/iurl}?mod=torrenterase&amp;hash={d_hash}" title="Erase" onclick="var answer = confirm( 'Are you sure?' ); if ( !answer ) return false;">Erase</a>
   </div>
   <div class="clr"></div>
   <div class="tbytes">
    <xsl:choose>
     <xsl:when test="d_complete = 1">
      <span title="Download finished">done </span>
     </xsl:when>
     <xsl:otherwise>
      <span title="Downloaded data">
       <xsl:value-of select="d_bytes_done/@value" />
       <xsl:text> </xsl:text>
       <xsl:value-of select="d_bytes_done/@suffix" />
      </span>
      <xsl:text> / </xsl:text>
     </xsl:otherwise>
    </xsl:choose>
    <span title="Torrent size">
     <xsl:value-of select="d_size_bytes/@value" />
     <xsl:text> </xsl:text>
     <xsl:value-of select="d_size_bytes/@suffix" />
    </span>
   </div>
   <div class="trates">
    <xsl:text>Rate: </xsl:text>
    <span title="Upload speed">
     <xsl:value-of select="d_up_rate/@value" />
     <xsl:text> </xsl:text>
     <xsl:value-of select="d_up_rate/@suffix" />
    </span>
    <xsl:text> / </xsl:text>
    <span title="Download speed">
     <xsl:value-of select="d_down_rate/@value" />
     <xsl:text> </xsl:text>
     <xsl:value-of select="d_down_rate/@suffix" />
    </span>
   </div>
   <div class="tupbytes">
    <span>Uploaded: </span>
    <span title="Uploaded data">
     <xsl:value-of select="d_up_total/@value" />
     <xsl:text> </xsl:text>
     <xsl:value-of select="d_up_total/@suffix" />
    </span>
   </div>
   <xsl:choose>
    <xsl:when test="d_percentage != 1">
     <div class="tpercentage">
      <span title="{d_percentage/@value} percent completed">
       <xsl:text>[</xsl:text>
       <xsl:value-of select="d_percentage/@value" />
       <xsl:text> %]</xsl:text>
      </span>
     </div>
     <xsl:choose>
      <xsl:when test="d_estimated_time != ''">
       <div class="testimate">
        <span title="Estimated time remaining">
         <xsl:value-of select="d_estimated_time/@value" />
        </span>
       </div>
      </xsl:when>
     </xsl:choose>
    </xsl:when>
   </xsl:choose>
   <div class="tratio">
    <xsl:text>[</xsl:text>
    <xsl:choose>
     <xsl:when test="d_tied_to_file != ''">
      <span title="Tied to file">T</span>
     </xsl:when>
    </xsl:choose>
    <xsl:choose>
     <xsl:when test="d_ignore_commands != 0">
      <span title="Ignoring commands">I</span>
     </xsl:when>
    </xsl:choose>
    <span title="Ratio">
     <xsl:text> R: </xsl:text>
     <xsl:value-of select="d_ratio/@value" />
    </span>
    <xsl:text>]</xsl:text>
   </div>
   <div class="tpriority">
    <form class="changepriorityform" name="changepriorityform_{d_hash}" method="post" action="{/root/iurl}?mod=changepriority&amp;hash={d_hash}">
     <xsl:text>[</xsl:text>
     <select class="whiteselect" name="priority" title="Select priority" onchange="window.location='{/root/iurl}?mod=changepriority&amp;hash={d_hash}&amp;priority='+this.value;">
      <xsl:choose>
       <xsl:when test="d_priority = 0">
        <option value="0" title="Off" selected="selected">Off</option>
        <option value="1" title="Low">Low</option>
        <option value="2" title="Normal">Normal</option>
        <option value="3" title="High">High</option>
       </xsl:when>
       <xsl:when test="d_priority = 1">
        <option value="0" title="Off">Off</option>
        <option value="1" title="Low" selected="selected">Low</option>
        <option value="2" title="Normal">Normal</option>
        <option value="3" title="High">High</option>
       </xsl:when>
       <xsl:when test="d_priority = 3">
        <option value="0" title="Off">Off</option>
        <option value="1" title="Low">Low</option>
        <option value="2" title="Normal">Normal</option>
        <option value="3" title="High" selected="selected">High</option>
       </xsl:when>
       <xsl:otherwise>
        <option value="0" title="Off">Off</option>
        <option value="1" title="Low">Low</option>
        <option value="2" title="Normal" selected="selected">Normal</option>
        <option value="3" title="High">High</option>
       </xsl:otherwise>
      </xsl:choose>
     </select>
     <xsl:text>]</xsl:text>
     <noscript>
      <input class="submit" type="submit" name="submit" value="OK" title="OK" />
     </noscript>
    </form>
   </div>
   <div class="clr"></div>
   <div class="tmessage">
    <span>Message: <xsl:value-of select="d_message" /></span>
   </div>
   <div class="clr"></div>
   <div class="tcontainer" id="torrent_{d_hash}" style="display: none;">
    <a class="info" href="?mod=torrent&amp;hash={d_hash}&amp;page=info" title="Info" onclick="loadcontent( '{d_hash}', 'info' ); return false;">Info</a>
    <a class="files" href="?mod=torrent&amp;hash={d_hash}&amp;page=files" title="File list" onclick="loadcontent( '{d_hash}', 'files' ); return false;">File list</a>
    <a class="trackers" href="?mod=torrent&amp;hash={d_hash}&amp;page=trackers" title="Tracker list" onclick="loadcontent( '{d_hash}', 'trackers' ); return false;">Tracker list</a>
    <div class="clr"></div>
    <div class="tcontent" id="torrent_{d_hash}_content"></div>
   </div>
   <div class="clr"></div>
  </li>
 </xsl:template>

 <xsl:template match="torrent_info_root">
  <xsl:apply-templates select="torrent_info" />
 </xsl:template>

 <xsl:template match="torrent_info">
  <li class="line spacer">
   <div class="infoleft">
    <xsl:text>Name:</xsl:text>
   </div>
   <div class="inforight">
    <xsl:value-of select="d_name" />
   </div>
   <div class="clr"></div>
  </li>
  <li class="line">
   <div class="infoleft">
    <xsl:text>Info hash:</xsl:text>
   </div>
   <div class="inforight">
    <xsl:value-of select="d_hash" />
   </div>
   <div class="clr"></div>
  </li>
  <li class="line">
   <div class="infoleft">
    <xsl:text>Local ID:</xsl:text>
   </div>
   <div class="inforight">
    <xsl:value-of select="d_local_id" />
   </div>
   <div class="clr"></div>
  </li>
  <li class="line spacer">
   <div class="infoleft">
    <xsl:text>Local ID (html):</xsl:text>
   </div>
   <div class="inforight">
    <xsl:value-of select="d_local_id_html" />
   </div>
   <div class="clr"></div>
  </li>
  <li class="line">
   <div class="infoleft">
    <xsl:text>Directory:</xsl:text>
   </div>
   <div class="inforight">
    <xsl:value-of select="d_directory/@value" />
   </div>
   <div class="clr"></div>
  </li>
  <li class="line">
   <div class="infoleft">
    <xsl:text>Tied to file:</xsl:text>
   </div>
   <div class="inforight">
    <xsl:choose>
     <xsl:when test="d_tied_to_file != ''">
      <xsl:value-of select="d_tied_to_file/@value" />
     </xsl:when>
     <xsl:otherwise>
      <xsl:text>No</xsl:text>
     </xsl:otherwise>
    </xsl:choose>
   </div>
   <div class="clr"></div>
  </li>
  <li class="line">
   <div class="infoleft">
    <xsl:text>File stats:</xsl:text>
   </div>
   <div class="inforight">
    <xsl:value-of select="d_multi_file/@value" />
    <xsl:choose>
     <xsl:when test="d_multi_file != 0">
      <xsl:text> </xsl:text>
      <xsl:value-of select="d_size_files" />
      <xsl:text> files</xsl:text>
     </xsl:when>
    </xsl:choose>
   </div>
   <div class="clr"></div>
  </li>
  <li class="line spacer">
   <div class="infoleft">
    <xsl:text>Private:</xsl:text>
   </div>
   <div class="inforight">
    <xsl:value-of select="d_private/@value" />
   </div>
   <div class="clr"></div>
  </li>
  <li class="line">
   <div class="infoleft">
    <xsl:text>Chunks:</xsl:text>
   </div>
   <div class="inforight">
    <xsl:value-of select="d_completed_chunks" />
    <xsl:text> / </xsl:text>
    <xsl:value-of select="d_chunks_hashed" />
    <xsl:text> * </xsl:text>
    <xsl:value-of select="d_chunk_size/@value" />
    <xsl:text> </xsl:text>
    <xsl:value-of select="d_chunk_size/@suffix" />
   </div>
   <div class="clr"></div>
  </li>
  <li class="line">
   <div class="infoleft">
    <xsl:text>Priority:</xsl:text>
   </div>
   <div class="inforight">
    <xsl:value-of select="d_priority/@value" />
   </div>
   <div class="clr"></div>
  </li>
  <li class="line spacer">
   <div class="infoleft">
    <xsl:text>State changed:</xsl:text>
   </div>
   <div class="inforight">
    <xsl:value-of select="d_state_changed/@value" />
   </div>
   <div class="clr"></div>
  </li>
  <li class="line spacer">
   <div class="infoleft">
    <xsl:text>Free diskspace:</xsl:text>
   </div>
   <div class="inforight">
    <xsl:value-of select="d_free_diskspace/@value" />
    <xsl:text> </xsl:text>
    <xsl:value-of select="d_free_diskspace/@suffix" />
   </div>
   <div class="clr"></div>
  </li>
  <li class="line">
   <div class="infoleft">
    <xsl:text>Connection type:</xsl:text>
   </div>
   <div class="inforight">
    <xsl:value-of select="d_connection_current/@value" />
   </div>
   <div class="clr"></div>
  </li>
  <li class="line">
   <div class="infoleft">
    <xsl:text>Trackers:</xsl:text>
   </div>
   <div class="inforight">
    <xsl:value-of select="d_tracker_size" />
   </div>
   <div class="clr"></div>
  </li>
  <li class="line">
   <div class="infoleft">
    <xsl:text>Leechers:</xsl:text>
   </div>
   <div class="inforight">
    <xsl:value-of select="d_peers_accounted" />
   </div>
   <div class="clr"></div>
  </li>
  <li class="line spacer">
   <div class="infoleft">
    <xsl:text>Seeders:</xsl:text>
   </div>
   <div class="inforight">
    <xsl:value-of select="d_peers_complete" />
   </div>
   <div class="clr"></div>
  </li>
  <li class="line">
   <div class="infoleft">
    <xsl:text>Upload:</xsl:text>
   </div>
   <div class="inforight">
    <xsl:value-of select="d_up_rate/@value" />
    <xsl:text> </xsl:text>
    <xsl:value-of select="d_up_rate/@suffix" />
    <xsl:text> / </xsl:text>
    <xsl:value-of select="d_up_total/@value" />
    <xsl:text> </xsl:text>
    <xsl:value-of select="d_up_total/@suffix" />
   </div>
   <div class="clr"></div>
  </li>
  <li class="line">
   <div class="infoleft">
    <xsl:text>Download:</xsl:text>
   </div>
   <div class="inforight">
    <xsl:value-of select="d_down_rate/@value" />
    <xsl:text> </xsl:text>
    <xsl:value-of select="d_down_rate/@suffix" />
    <xsl:text> / </xsl:text>
    <xsl:value-of select="d_down_total/@value" />
    <xsl:text> </xsl:text>
    <xsl:value-of select="d_down_total/@suffix" />
   </div>
   <div class="clr"></div>
  </li>
  <li class="line">
   <div class="infoleft">
    <xsl:text>Skipped:</xsl:text>
   </div>
   <div class="inforight">
    <xsl:value-of select="d_skip_rate/@value" />
    <xsl:text> </xsl:text>
    <xsl:value-of select="d_skip_rate/@suffix" />
    <xsl:text> / </xsl:text>
    <xsl:value-of select="d_skip_total/@value" />
    <xsl:text> </xsl:text>
    <xsl:value-of select="d_skip_total/@suffix" />
   </div>
   <div class="clr"></div>
  </li>
 </xsl:template>

 <xsl:template match="torrent_files_root">
  <xsl:apply-templates select="torrent_files" />
 </xsl:template>

 <xsl:template match="torrent_files">
  <xsl:apply-templates select="files_root" />
 </xsl:template>

 <xsl:template match="torrent_trackers_root">
  <xsl:apply-templates select="torrent_trackers" />
 </xsl:template>

 <xsl:template match="torrent_trackers">
  <xsl:apply-templates select="tracker" />
 </xsl:template>

 <xsl:template match="server_info">
  <li class="line">
   <div class="infoleft">
    <xsl:text>Client version:</xsl:text>
   </div>
   <div class="inforight">
    <xsl:value-of select="client_version" />
   </div>
   <div class="clr"></div>
  </li>
  <li class="line spacer">
   <div class="infoleft">
    <xsl:text>Library version:</xsl:text>
   </div>
   <div class="inforight">
    <xsl:value-of select="library_version" />
   </div>
   <div class="clr"></div>
  </li>
  <li class="line">
   <div class="infoleft">
    <xsl:text>Working directory:</xsl:text>
   </div>
   <div class="inforight">
    <xsl:value-of select="get_cwd" />
   </div>
   <div class="clr"></div>
  </li>
  <li class="line">
   <div class="infoleft">
    <xsl:text>Download directory:</xsl:text>
   </div>
   <div class="inforight">
    <xsl:value-of select="directory/@value" />
   </div>
   <div class="clr"></div>
  </li>
  <li class="line spacer">
   <div class="infoleft">
    <xsl:text>Session directory:</xsl:text>
   </div>
   <div class="inforight">
    <xsl:value-of select="session/@value" />
   </div>
   <div class="clr"></div>
  </li>
  <li class="line">
   <div class="infoleft">
    <xsl:text>Hostname:</xsl:text>
   </div>
   <div class="inforight">
    <xsl:value-of select="hostname" />
   </div>
   <div class="clr"></div>
  </li>
  <li class="line">
   <div class="infoleft">
    <xsl:text>Listening IP address:</xsl:text>
   </div>
   <div class="inforight">
    <xsl:value-of select="ip/@value" />
   </div>
   <div class="clr"></div>
  </li>
  <li class="line">
   <div class="infoleft">
    <xsl:text>IP address reported to the tracker:</xsl:text>
   </div>
   <div class="inforight">
    <xsl:value-of select="bind/@value" />
   </div>
   <div class="clr"></div>
  </li>
  <li class="line">
   <div class="infoleft">
    <xsl:text>Port opened:</xsl:text>
   </div>
   <div class="inforight">
    <xsl:value-of select="port_open/@value" />
   </div>
   <div class="clr"></div>
  </li>
  <li class="line">
   <div class="infoleft">
    <xsl:text>Random port:</xsl:text>
   </div>
   <div class="inforight">
    <xsl:value-of select="port_random/@value" />
   </div>
   <div class="clr"></div>
  </li>
  <li class="line spacer">
   <div class="infoleft">
    <xsl:text>Port range:</xsl:text>
   </div>
   <div class="inforight">
    <xsl:value-of select="port_range/@value" />
   </div>
   <div class="clr"></div>
  </li>
  <li class="line">
   <div class="infoleft">
    <xsl:text>Maximum number of uploads:</xsl:text>
   </div>
   <div class="inforight">
    <xsl:value-of select="max_uploads/@value" />
   </div>
   <div class="clr"></div>
  </li>
  <li class="line">
   <div class="infoleft">
    <xsl:text>Minimum number of peers:</xsl:text>
   </div>
   <div class="inforight">
    <xsl:value-of select="min_peers/@value" />
   </div>
   <div class="clr"></div>
  </li>
  <li class="line">
   <div class="infoleft">
    <xsl:text>Maximum number of peers:</xsl:text>
   </div>
   <div class="inforight">
    <xsl:value-of select="max_peers/@value" />
   </div>
   <div class="clr"></div>
  </li>
  <li class="line spacer">
   <div class="infoleft">
    <xsl:text>Max memory usage:</xsl:text>
   </div>
   <div class="inforight">
    <xsl:value-of select="max_memory_usage/@value" />
    <xsl:text> </xsl:text>
    <xsl:value-of select="max_memory_usage/@suffix" />
   </div>
   <div class="clr"></div>
  </li>
  <li class="line">
   <div class="infoleft">
    <xsl:text>Check hash:</xsl:text>
   </div>
   <div class="inforight">
    <xsl:value-of select="check_hash/@value" />
   </div>
   <div class="clr"></div>
  </li>
  <li class="line">
   <div class="infoleft">
    <xsl:text>Safe sync:</xsl:text>
   </div>
   <div class="inforight">
    <xsl:value-of select="safe_sync/@value" />
   </div>
   <div class="clr"></div>
  </li>
  <li class="line">
   <div class="infoleft">
    <xsl:text>Send buffer:</xsl:text>
   </div>
   <div class="inforight">
    <xsl:value-of select="receive_buffer_size/@value" />
    <xsl:text> </xsl:text>
    <xsl:value-of select="receive_buffer_size/@suffix" />
   </div>
   <div class="clr"></div>
  </li>
  <li class="line">
   <div class="infoleft">
    <xsl:text>Receive buffer:</xsl:text>
   </div>
   <div class="inforight">
    <xsl:value-of select="receive_buffer_size/@value" />
    <xsl:text> </xsl:text>
    <xsl:value-of select="receive_buffer_size/@suffix" />
   </div>
   <div class="clr"></div>
  </li>
 </xsl:template>

 <xsl:template match="files_root">
  <xsl:apply-templates select="directory" />
  <xsl:apply-templates select="file" />
 </xsl:template>

 <xsl:template match="directory">
  <li>
   <a title="Click to open" onmouseover="this.style.cursor='pointer';" onclick="if ( this.parentNode.getElementsByTagName( 'ul' ).item( 0 ).style.display == '' ) {{ this.parentNode.getElementsByTagName( 'ul' ).item( 0 ).style.display = 'none' }} else {{ this.parentNode.getElementsByTagName( 'ul' ).item( 0 ).style.display = '' }};"><xsl:value-of select="@dirname" /></a>
   <ul class="directory">
    <xsl:apply-templates select="directory" />
    <xsl:apply-templates select="file" />
   </ul>
  </li>
 </xsl:template>

 <xsl:template match="file">
  <li onmouseover="this.style.background='#eeeeee';" onmouseout="this.style.background='';">
   <div class="fname">
    <span title="Last touched: {f_last_touched}">
     <xsl:value-of select="@filename" />
    </span>
   </div>
   <div class="fpercentage">
    <span title="{f_percentage/@value} percent completed">
     <xsl:text>[</xsl:text>
     <xsl:value-of select="f_percentage/@value" />
     <xsl:text> %]</xsl:text>
    </span>
   </div>
   <div class="fpriority">
    <form class="changefilepriorityform" name="changefilepriorityform_{@id}" method="post" action="{/root/iurl}?mod=changefilepriority&amp;hash={/root/hash}&amp;id={@id}">
     <xsl:text>[</xsl:text>
     <select class="whiteselect" name="filepriority" title="Select file priority" onchange="window.location='{/root/iurl}?mod=changefilepriority&amp;hash={/root/hash}&amp;id={@id}&amp;filepriority='+this.value;">
      <xsl:choose>
       <xsl:when test="f_priority = 0">
        <option value="0" title="Off" selected="selected">Off</option>
        <option value="1" title="Normal">Normal</option>
        <option value="2" title="High">High</option>
       </xsl:when>
       <xsl:when test="f_priority = 2">
        <option value="0" title="Off">Off</option>
        <option value="1" title="Normal">Normal</option>
        <option value="2" title="High" selected="selected">High</option>
       </xsl:when>
       <xsl:otherwise>
        <option value="0" title="Off">Off</option>
        <option value="1" title="Normal" selected="selected">Normal</option>
        <option value="2" title="High">High</option>
       </xsl:otherwise>
      </xsl:choose>
     </select>
     <xsl:text>]</xsl:text>
     <noscript>
      <input class="submit" type="submit" name="OK" value="OK" title="OK" />
     </noscript>
    </form>
   </div>
   <div class="fsize">
    <span title="File size">
     <xsl:value-of select="f_size_bytes/@value" />
     <xsl:text> </xsl:text>
     <xsl:value-of select="f_size_bytes/@suffix" />
    </span>
   </div>
   <div class="fchunks">
    <span title="Chunks">
     <xsl:choose>
      <xsl:when test="f_range_first != f_range_second">
       <xsl:value-of select="f_range_first" />
       <xsl:text> - </xsl:text>
       <xsl:value-of select="f_range_second" />
      </xsl:when>
      <xsl:otherwise>
       <xsl:value-of select="f_range_first" />
      </xsl:otherwise>
     </xsl:choose>
    </span>
   </div>
   <xsl:choose>
    <xsl:when test="f_percentage = 1">
     <div class="fdownload">
      <a href="?mod=getfile&amp;hash={/root/hash}&amp;id={@id}" title="Download file">Download</a>
     </div>
    </xsl:when>
   </xsl:choose>
   <div class="clr"></div>
  </li>
 </xsl:template>

 <xsl:template match="dlpath">
  <li onmouseover="this.style.background='#eeeeee';" onmouseout="this.style.background='';">
   <div class="tufpath">
    <a href="?mod=addtorrent&amp;path={@path}">
     <xsl:value-of select="@name" />
    </a>
   </div>
   <div class="tufspace">
    <xsl:value-of select="@freespace_value" />
    <xsl:text> </xsl:text>
    <xsl:value-of select="@freespace_suffix" />
   </div>
   <div class="clr"></div>
  </li>
 </xsl:template>

 <xsl:template match="tracker">
  <li>
   <ul>
    <li>
     <div class="tgroup">
      <span title="Tracker group">
       <xsl:value-of select="t_group" />
       <xsl:text>:</xsl:text>
      </span>
     </div>
     <div class="turl">
      <span title="Type: {t_type/@value}">
       <xsl:value-of select="t_url" />
      </span>
     </div>
     <div class="clr"></div>
    </li>
    <li>
     <div class="tfocus">
      <xsl:choose>
       <xsl:when test="root/tottents/torrent_trackers_root/torrent_trackers/d_tracker_focus = @id">
        <xsl:text>Focus: Yes</xsl:text>
       </xsl:when>
       <xsl:otherwise>
        <xsl:text>Focus: No</xsl:text>
       </xsl:otherwise>
      </xsl:choose>
     </div>
     <div class="tenabled">
      <form class="changetrackerenabledform" name="changetrackerenabledform_{@id}" method="post" action="{/root/iurl}?mod=changetrackerenabled&amp;hash={/root/hash}&amp;id={@id}">
       <xsl:text>Enabled: </xsl:text>
       <select class="whiteselect" name="trackerenabled" title="Select if tracker is enabled" onchange="window.location='{/root/iurl}?mod=changetrackerenabled&amp;hash={/root/hash}&amp;id={@id}&amp;trackerenabled='+this.value;">
        <xsl:choose>
         <xsl:when test="t_enabled = 0">
          <option value="1" title="Yes">Yes</option>
          <option value="0" title="No" selected="selected">No</option>
         </xsl:when>
         <xsl:otherwise>
          <option value="1" title="Yes" selected="selected">Yes</option>
          <option value="0" title="No">No</option>
         </xsl:otherwise>
        </xsl:choose>
       </select>
       <noscript>
        <input class="submit" type="submit" name="submit" value="OK" title="OK" />
       </noscript>
      </form>
     </div>
     <div class="topen">
      <xsl:text>Open: </xsl:text>
      <xsl:choose>
       <xsl:when test="t_open != 0">
        <xsl:text>Yes</xsl:text>
       </xsl:when>
       <xsl:otherwise>
        <xsl:text>No</xsl:text>
       </xsl:otherwise>
      </xsl:choose>
     </div>
     <div class="tpeers">
      <xsl:text>S/L: </xsl:text>
      <xsl:value-of select="t_scrape_complete" />
      <xsl:text> / </xsl:text>
      <xsl:value-of select="t_scrape_incomplete" />
     </div>
     <div class="clr"></div>
    </li>
    <li>
     <div class="tscrape">
      <span title="Minimum interval: {t_min_interval/@value} - Normal interval: {t_normal_interval/@value}">
       <xsl:text>Last time scraped: </xsl:text>
       <xsl:value-of select="t_scrape_time_last/@value" />
      </span>
     </div>
     <div class="clr"></div>
    </li>
   </ul>
  </li>
 </xsl:template>

</xsl:stylesheet>
