<xsl:stylesheet version="1.1"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                lang="en">
 <xsl:output method="xml"
             indent="no"
             encoding="utf-8" />

 <xsl:template match="root">
  <xsl:apply-templates select="err" />
  <xsl:apply-templates select="torrents" />
 </xsl:template>

 <xsl:template match="err">
  <div id="err" title="{/root/labels/clicktohide}" onmouseover="this.style.cursor='pointer';" onclick="this.parentNode.removeChild( this );">
   <xsl:apply-templates select="errmsg" />
  </div>
 </xsl:template>
 
 <xsl:template match="errmsg">
  <div>
   <xsl:value-of select="msg" />
  </div>
 </xsl:template>

 <xsl:template match="torrents">
  <ul>
   <xsl:apply-templates select="torrent_info_root" />
   <xsl:apply-templates select="torrent_files_root" />
   <xsl:apply-templates select="torrent_peers_root" />
   <xsl:apply-templates select="torrent_trackers_root" />
  </ul>
 </xsl:template>

 <xsl:template match="torrent_info_root">
  <xsl:apply-templates select="torrent_info" />
 </xsl:template>

 <xsl:template match="torrent_info">
  <li class="line spacer">
   <div class="infoleft">
    <xsl:value-of select="/root/labels/name" />
   </div>
   <div class="inforight">
    <xsl:value-of select="d_name" />
   </div>
   <div class="clr"></div>
  </li>
  <li class="line">
   <div class="infoleft">
    <xsl:value-of select="/root/labels/infohash" />
   </div>
   <div class="inforight">
    <xsl:value-of select="d_hash" />
   </div>
   <div class="clr"></div>
  </li>
  <li class="line">
   <div class="infoleft">
    <xsl:value-of select="/root/labels/localid" />
   </div>
   <div class="inforight">
    <xsl:value-of select="d_local_id" />
   </div>
   <div class="clr"></div>
  </li>
  <li class="line spacer">
   <div class="infoleft">
    <xsl:value-of select="/root/labels/localidhtml" />
   </div>
   <div class="inforight">
    <xsl:value-of select="d_local_id_html" />
   </div>
   <div class="clr"></div>
  </li>
  <li class="line">
   <div class="infoleft">
    <xsl:value-of select="/root/labels/directory" />
   </div>
   <div class="inforight">
    <xsl:value-of select="d_directory/@value" />
   </div>
   <div class="clr"></div>
  </li>
  <li class="line">
   <div class="infoleft">
    <xsl:value-of select="/root/labels/tiedtofile" />
   </div>
   <div class="inforight">
    <xsl:choose>
     <xsl:when test="d_tied_to_file != ''">
      <xsl:value-of select="d_tied_to_file/@value" />
     </xsl:when>
     <xsl:otherwise>
      <xsl:value-of select="/root/labels/no" />
     </xsl:otherwise>
    </xsl:choose>
   </div>
   <div class="clr"></div>
  </li>
  <li class="line">
   <div class="infoleft">
    <xsl:value-of select="/root/labels/filestats" />
   </div>
   <div class="inforight">
    <xsl:value-of select="d_multi_file/@value" />
    <xsl:choose>
     <xsl:when test="d_multi_file != 0">
      <xsl:text> </xsl:text>
      <xsl:value-of select="d_size_files" />
      <xsl:text> </xsl:text>
      <xsl:value-of select="/root/labels/files" />
     </xsl:when>
    </xsl:choose>
   </div>
   <div class="clr"></div>
  </li>
  <li class="line spacer">
   <div class="infoleft">
    <xsl:value-of select="/root/labels/private" />
   </div>
   <div class="inforight">
    <xsl:value-of select="d_private/@value" />
   </div>
   <div class="clr"></div>
  </li>
  <li class="line">
   <div class="infoleft">
    <xsl:value-of select="/root/labels/chunks" />
   </div>
   <div class="inforight">
    <xsl:value-of select="d_completed_chunks" />
    <xsl:text> / </xsl:text>
    <xsl:value-of select="d_chunks_hashed" />
    <xsl:text> * </xsl:text>
    <xsl:value-of select="d_chunk_size/@value" />
    <xsl:text> </xsl:text>
    <xsl:value-of select="d_chunk_size/@suffix" />
   </div>
   <div class="clr"></div>
  </li>
  <li class="line">
   <div class="infoleft">
    <xsl:value-of select="/root/labels/priority" />
   </div>
   <div class="inforight">
    <xsl:value-of select="d_priority/@value" />
   </div>
   <div class="clr"></div>
  </li>
  <li class="line spacer">
   <div class="infoleft">
    <xsl:value-of select="/root/labels/statechanged" />
   </div>
   <div class="inforight">
    <xsl:value-of select="d_state_changed/@value" />
   </div>
   <div class="clr"></div>
  </li>
  <li class="line spacer">
   <div class="infoleft">
    <xsl:value-of select="/root/labels/freediskspace" />
   </div>
   <div class="inforight">
    <xsl:value-of select="d_free_diskspace/@value" />
    <xsl:text> </xsl:text>
    <xsl:value-of select="d_free_diskspace/@suffix" />
   </div>
   <div class="clr"></div>
  </li>
  <li class="line">
   <div class="infoleft">
    <xsl:value-of select="/root/labels/connectiontype" />
   </div>
   <div class="inforight">
    <xsl:value-of select="d_connection_current/@value" />
   </div>
   <div class="clr"></div>
  </li>
  <li class="line">
   <div class="infoleft">
    <xsl:value-of select="/root/labels/trackers" />
   </div>
   <div class="inforight">
    <xsl:value-of select="d_tracker_size" />
   </div>
   <div class="clr"></div>
  </li>
  <li class="line">
   <div class="infoleft">
    <xsl:value-of select="/root/labels/peersconnected" />
   </div>
   <div class="inforight">
    <span title="{/root/labels/dminpeers}: {d_peers_min} - {/root/labels/dmaxpeers}: {d_peers_max}">
     <xsl:value-of select="d_peers_connected" />
    </span>
   </div>
   <div class="clr"></div>
  </li>
  <li class="line">
   <div class="infoleft">
    <xsl:value-of select="/root/labels/leechers" />
   </div>
   <div class="inforight">
    <xsl:value-of select="d_peers_accounted" />
   </div>
   <div class="clr"></div>
  </li>
  <li class="line spacer">
   <div class="infoleft">
    <xsl:value-of select="/root/labels/seeders" />
   </div>
   <div class="inforight">
    <xsl:value-of select="d_peers_complete" />
   </div>
   <div class="clr"></div>
  </li>
  <li class="line">
   <div class="infoleft">
    <xsl:value-of select="/root/labels/pexenabled" />
   </div>
   <div class="inforight">
    <xsl:value-of select="d_pex_active/@value" />
   </div>
   <div class="clr"></div>
  </li>
  <li class="line spacer">
   <div class="infoleft">
    <xsl:value-of select="/root/labels/pexsize" />
   </div>
   <div class="inforight">
    <xsl:value-of select="d_size_pex" />
    <xsl:text> / </xsl:text>
    <xsl:value-of select="d_max_size_pex" />
   </div>
   <div class="clr"></div>
  </li>
  <li class="line">
   <div class="infoleft">
    <xsl:value-of select="/root/labels/upload" />
   </div>
   <div class="inforight">
    <xsl:value-of select="d_up_rate/@value" />
    <xsl:text> </xsl:text>
    <xsl:value-of select="d_up_rate/@suffix" />
    <xsl:text> / </xsl:text>
    <xsl:value-of select="d_up_total/@value" />
    <xsl:text> </xsl:text>
    <xsl:value-of select="d_up_total/@suffix" />
   </div>
   <div class="clr"></div>
  </li>
  <li class="line">
   <div class="infoleft">
    <xsl:value-of select="/root/labels/download" />
   </div>
   <div class="inforight">
    <xsl:value-of select="d_down_rate/@value" />
    <xsl:text> </xsl:text>
    <xsl:value-of select="d_down_rate/@suffix" />
    <xsl:text> / </xsl:text>
    <xsl:value-of select="d_down_total/@value" />
    <xsl:text> </xsl:text>
    <xsl:value-of select="d_down_total/@suffix" />
   </div>
   <div class="clr"></div>
  </li>
  <li class="line">
   <div class="infoleft">
    <xsl:value-of select="/root/labels/skipped" />
   </div>
   <div class="inforight">
    <xsl:value-of select="d_skip_rate/@value" />
    <xsl:text> </xsl:text>
    <xsl:value-of select="d_skip_rate/@suffix" />
    <xsl:text> / </xsl:text>
    <xsl:value-of select="d_skip_total/@value" />
    <xsl:text> </xsl:text>
    <xsl:value-of select="d_skip_total/@suffix" />
   </div>
   <div class="clr"></div>
  </li>
 </xsl:template>

 <xsl:template match="torrent_files_root">
  <xsl:apply-templates select="torrent_files" />
 </xsl:template>

 <xsl:template match="torrent_files">
  <xsl:apply-templates select="files_root" />
 </xsl:template>

 <xsl:template match="torrent_trackers_root">
  <xsl:apply-templates select="torrent_trackers" />
 </xsl:template>

 <xsl:template match="torrent_trackers">
  <xsl:apply-templates select="tracker" />
 </xsl:template>

 <xsl:template match="torrent_peers_root">
  <xsl:apply-templates select="torrent_peers" />
 </xsl:template>

 <xsl:template match="torrent_peers">
  <li class="phead">
   <div class="paddress">
    <xsl:value-of select="/root/labels/address" />
   </div>
   <div class="pup">
    <xsl:value-of select="/root/labels/up_rate" />
   </div>
   <div class="pdown">
    <xsl:value-of select="/root/labels/down_rate" />
   </div>
   <div class="prate">
    <xsl:value-of select="/root/labels/peer_rate" />
   </div>
   <div class="pdone">
    <xsl:value-of select="/root/labels/done" />
   </div>
   <div class="pincoming">
    <xsl:value-of select="/root/labels/incoming" />
   </div>
   <div class="pencrypted">
    <xsl:value-of select="/root/labels/encrypted" />
   </div>
   <div class="pclient">
    <xsl:value-of select="/root/labels/pclientversion" />
   </div>
   <div class="clr"></div>
  </li>
  <xsl:apply-templates select="peer" />
 </xsl:template>

 <xsl:template match="files_root">
  <xsl:apply-templates select="directory" />
  <xsl:apply-templates select="file" />
 </xsl:template>

 <xsl:template match="directory">
  <li>
   <div class="dopenlink">
    <a title="{/root/labels/clicktoopenclose}" onmouseover="this.style.cursor='pointer';" onclick="if ( this.parentNode.parentNode.getElementsByTagName( 'ul' ).item( 0 ).style.display == '' ) {{ this.parentNode.parentNode.getElementsByTagName( 'ul' ).item( 0 ).style.display = 'none' }} else {{ this.parentNode.parentNode.getElementsByTagName( 'ul' ).item( 0 ).style.display = '' }};"><xsl:value-of select="@dirname" /></a>
   </div>
   <div class="dpriority">
    <form class="changedirpriorityform" name="changedirpriorityform_{@id}" method="post" action="{/root/iurl}?mod=changedirpriority&amp;hash={/root/hash}&amp;dir={@dirpath}">
     <select class="whiteselect" name="dirpriority" title="Select directory priority" onchange="RTWI.loadcontent_dirpriority('{/root/iurl}', '{/root/hash}', '{@dirpath}', this.value);">
      <option value="-1" title="{/root/labels/selectone}" selected="selected"><xsl:value-of select="/root/labels/selectone" /></option>
      <option value="0" title="{/root/labels/off}"><xsl:value-of select="/root/labels/off" /></option>
      <option value="1" title="{/root/labels/normal}"><xsl:value-of select="/root/labels/normal" /></option>
      <option value="2" title="{/root/labels/high}"><xsl:value-of select="/root/labels/high" /></option>
     </select>
     <noscript>
      <input class="submit" type="submit" name="OK" value="OK" title="OK" />
     </noscript>
    </form>
   </div>
   <div class="clr">_</div>
   <ul class="directory" style="display: none;">
    <xsl:apply-templates select="directory" />
    <xsl:apply-templates select="file" />
   </ul>
  </li>
 </xsl:template>

 <xsl:template match="file">
  <li onmouseover="this.style.background='#eeeeee';" onmouseout="this.style.background='';">
   <div class="fname">
    <span title="{/root/labels/lasttouched}: {f_last_touched}">
     <xsl:value-of select="@filename" />
    </span>
   </div>
   <div class="fpercentage">
    <span title="{f_percentage/@value} {/root/labels/percentcompleted}">
     <xsl:text>[</xsl:text>
     <xsl:value-of select="f_percentage/@value" />
     <xsl:text> %]</xsl:text>
    </span>
   </div>
   <div class="fpriority">
    <form class="changefilepriorityform" name="changefilepriorityform_{@id}" method="post" action="{/root/iurl}?mod=changefilepriority&amp;hash={/root/hash}&amp;id={@id}">
     <select class="whiteselect" name="filepriority" title="{/root/labels/selectfilepriority}" onchange="RTWI.loadcontent_filepriority('{/root/iurl}', '{/root/hash}', '{@id}', this.value);">
      <xsl:choose>
       <xsl:when test="f_priority = 0">
        <option value="0" title="{/root/labels/off}" selected="selected"><xsl:value-of select="/root/labels/off" /></option>
        <option value="1" title="{/root/labels/normal}"><xsl:value-of select="/root/labels/normal" /></option>
        <option value="2" title="{/root/labels/high}"><xsl:value-of select="/root/labels/high" /></option>
       </xsl:when>
       <xsl:when test="f_priority = 2">
        <option value="0" title="{/root/labels/off}"><xsl:value-of select="/root/labels/off" /></option>
        <option value="1" title="{/root/labels/normal}"><xsl:value-of select="/root/labels/normal" /></option>
        <option value="2" title="{/root/labels/high}" selected="selected"><xsl:value-of select="/root/labels/high" /></option>
       </xsl:when>
       <xsl:otherwise>
        <option value="0" title="{/root/labels/off}"><xsl:value-of select="/root/labels/off" /></option>
        <option value="1" title="{/root/labels/normal}" selected="selected"><xsl:value-of select="/root/labels/normal" /></option>
        <option value="2" title="{/root/labels/high}"><xsl:value-of select="/root/labels/high" /></option>
       </xsl:otherwise>
      </xsl:choose>
     </select>
    </form>
   </div>
   <div class="fsize">
    <span title="{/root/labels/filesize}">
     <xsl:value-of select="f_size_bytes/@value" />
     <xsl:text> </xsl:text>
     <xsl:value-of select="f_size_bytes/@suffix" />
    </span>
   </div>
   <div class="fchunks">
    <span title="{/root/labels/chunks}">
     <xsl:choose>
      <xsl:when test="f_range_first != f_range_second">
       <xsl:value-of select="f_range_first" />
       <xsl:text> - </xsl:text>
       <xsl:value-of select="f_range_second" />
      </xsl:when>
      <xsl:otherwise>
       <xsl:value-of select="f_range_first" />
      </xsl:otherwise>
     </xsl:choose>
    </span>
   </div>
   <xsl:choose>
    <xsl:when test="f_percentage = 1 and /root/allow_download = 'true'">
     <div class="fdownload">
      <a href="?mod=getfile&amp;hash={/root/hash}&amp;id={@id}" title="{/root/labels/downloadfile}"><xsl:value-of select="/root/labels/download" /></a>
     </div>
    </xsl:when>
   </xsl:choose>
   <div class="clr"></div>
  </li>
 </xsl:template>

 <xsl:template match="tracker">
  <li>
   <ul>
    <li>
     <xsl:value-of select="t_url" /><br />
     <xsl:value-of select="/root/labels/trackergroup" /><xsl:text>: </xsl:text><xsl:value-of select="t_group" /><br />
     <xsl:value-of select="/root/labels/type" /><xsl:text>: </xsl:text><xsl:value-of select="t_type/@value" /><br />
     <xsl:value-of select="/root/labels/focus" />
     <xsl:text>: </xsl:text>
     <xsl:choose>
      <xsl:when test="root/tottents/torrent_trackers_root/torrent_trackers/d_tracker_focus = @id">
       <xsl:value-of select="/root/labels/yes" />
      </xsl:when>
      <xsl:otherwise>
       <xsl:value-of select="/root/labels/no" />
      </xsl:otherwise>
     </xsl:choose>
     <br />
     <xsl:value-of select="/root/labels/enabled" />
     <xsl:text>: </xsl:text>
     <select class="whiteselect" name="trackerenabled" title="{/root/labels/selecttrackerenabled}" onchange="RTWI.loadcontent_trackerenabled('{/root/iurl}', '{/root/hash}', '{@id}', this.value)">
      <xsl:choose>
       <xsl:when test="t_enabled = 0">
        <option value="1" title="{/root/labels/yes}"><xsl:value-of select="/root/labels/yes" /></option>
        <option value="0" title="{/root/labels/no}" selected="selected"><xsl:value-of select="/root/labels/no" /></option>
       </xsl:when>
       <xsl:otherwise>
        <option value="1" title="{/root/labels/yes}" selected="selected"><xsl:value-of select="/root/labels/yes" /></option>
        <option value="0" title="{/root/labels/no}"><xsl:value-of select="/root/labels/no" /></option>
       </xsl:otherwise>
      </xsl:choose>
     </select>
     <br />
     <xsl:value-of select="/root/labels/opened" />
     <xsl:text>: </xsl:text>
     <xsl:choose>
      <xsl:when test="t_open != 0">
       <xsl:value-of select="/root/labels/yes" />
      </xsl:when>
      <xsl:otherwise>
       <xsl:value-of select="/root/labels/no" />
      </xsl:otherwise>
     </xsl:choose>
     <br />
     <xsl:value-of select="/root/labels/seedersleechers" />
     <xsl:text>: </xsl:text>
     <xsl:value-of select="t_scrape_complete" />
     <xsl:text> / </xsl:text>
     <xsl:value-of select="t_scrape_incomplete" />
     <br />
     <span title="{/root/labels/mininterval}: {t_min_interval/@value} - Normal interval: {t_normal_interval/@value}">
      <xsl:value-of select="/root/labels/lasttimescraped" />
      <xsl:text>: </xsl:text>
      <xsl:value-of select="t_scrape_time_last/@value" />
     </span>
    </li>
   </ul>
  </li>
 </xsl:template>

 <xsl:template match="peer">
  <li>
   <div class="paddress">
    <xsl:choose>
     <xsl:when test="p_country != ''">
      <img src="flags/{p_country}.gif" alt="flag" title="{p_country/@value}" />
     </xsl:when>
    </xsl:choose>
    <xsl:value-of select="p_address" />
   </div>
   <div class="pup">
    <xsl:value-of select="p_up_rate/@value" />
    <xsl:text> </xsl:text>
    <xsl:value-of select="p_up_rate/@suffix" />
   </div>
   <div class="pdown">
    <xsl:value-of select="p_down_rate/@value" />
    <xsl:text> </xsl:text>
    <xsl:value-of select="p_down_rate/@suffix" />
   </div>
   <div class="prate">
    <xsl:value-of select="p_peer_rate/@value" />
    <xsl:text> </xsl:text>
    <xsl:value-of select="p_peer_rate/@suffix" />
   </div>
   <div class="pdone">
    <xsl:value-of select="p_completed_percent" />
    <xsl:text> %</xsl:text>
   </div>
   <div class="pincoming">
    <xsl:value-of select="p_incoming/@value" />
   </div>
   <div class="pencrypted">
    <xsl:value-of select="p_encrypted/@value" />
   </div>
   <div class="pclient">
    <xsl:value-of select="p_client_version" />
   </div>
   <div class="clr"></div>
  </li>
 </xsl:template>

</xsl:stylesheet>
