<xsl:stylesheet version="1.1"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                lang="en">
 <xsl:output method="xml"
             indent="no"
             encoding="utf-8"
             doctype-public="-//W3C//DTD XHTML 1.0 Transitional//EN"
             doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd" />

 <xsl:template match="root">
  <html xml:lang="{language}" lang="{language}">
   <head>
    <meta http-equiv="content-type" content="text/html; charset=utf-8" />
    <meta http-equiv="content-language" content="{language}" />
    <meta http-equiv="cache-control" content="no-store, no-cache, must-revalidate, post-check=0, pre-check=0" />
    <meta http-equiv="pragma" content="no-cache" />
    <meta http-equiv="expires" content="thu, 1 jan 1970 00:00:00 gmt" />
    <meta http-equiv="imagetoolbar" content="no" />  
    <meta name="author" content="{labels/author}" />
    <meta name="description" content="{labels/description}" />
    <meta name="doc-type" content="web page" />
    <meta name="rating" content="general" />
    <meta name="robots" content="noindex, nofollow" />
    <link rel="stylesheet" type="text/css" href="themes/WordPressWidefat/inc/style.css" />
    <link rel="icon" type="image/x-icon" href="{favicon_url}" />
    <title><xsl:value-of select="labels/title" /></title>
   </head>
   <body onload="document.getElementById( 'lfname' ).focus();">
    <div id="top">
    </div>
    <div id="loginbox">
     <xsl:apply-templates select="err" />
     <xsl:apply-templates select="languages" />
     <form id="login" method="post" action="{iurl}?mod=login">
      <ul>
       <li>
        <div class="lftitle"><xsl:value-of select="labels/username" />:</div>
        <div class="lffield">
         <input id="lfname" type="text" title="{labels/username}" name="loginname" />
        </div>
       </li>
       <li>
        <div class="lftitle"><xsl:value-of select="labels/password" />:</div>
        <div class="lffield">
         <input id="lfpass" type="password" title="{labels/password}" name="loginpass" />
        </div>
       </li>
       <li>
        <div class="lftitle"><xsl:value-of select="labels/rememberme" />:</div>
        <div class="lffield">
         <input id="lfremember" type="checkbox" title="{labels/rememberme}" name="rememberme" />
        </div>
       </li>
       <li class="formsend">
        <input class="inputok" type="submit" title="{labels/login}" name="loginok" value="{labels/login}" />
       </li>
      </ul>
     </form>
    </div>
    <div id="footer">
     <span><a href="https://rtwi.jmk.hu/" title="{labels/homepage}"><xsl:value-of select="labels/homepage" /></a> (rTWi: <span title="build: {rtwi_version/build_number}"><xsl:value-of select="rtwi_version/version" /></span> - <xsl:value-of select="rtwi_version/released" />)</span>
    </div>
   </body>
  </html>
 </xsl:template>

 <xsl:template match="err">
  <div id="err">
   <span title="clicktohide" onmouseover="this.style.cursor='pointer';" onclick="document.getElementById( 'err' ).style.display='none';">
    <xsl:value-of select="errmsg" />
   </span>
  </div>
 </xsl:template>

 <xsl:template match="languages">
  <form id="changelanguageform" name="changelanguageform" method="post" action="{/root/iurl}?mod=changelanguage">
   <xsl:text>[</xsl:text>
   <xsl:value-of select="/root/labels/language" />
   <xsl:text>: </xsl:text>
   <select class="whiteselect" name="language" title="{/root/labels/selectlanguage}" onchange="window.location='{/root/iurl}?mod=changelanguage&amp;language='+this.value;">
    <xsl:apply-templates select="language" />
   </select>
   <noscript>
    <input class="submit" id="lsubmit" type="submit" name="lsubmit" title="{/root/labels/ok}" value="{/root/labels/ok}" />
   </noscript>
   <xsl:text>]</xsl:text>
  </form>
 </xsl:template>

 <xsl:template match="language">
  <xsl:choose>
   <xsl:when test="/root/@language = @value">
    <option value="{@value}" title="{@title}" selected="selected"><xsl:value-of select="@title" /></option>
   </xsl:when>
   <xsl:otherwise>
    <option value="{@value}" title="{@title}"><xsl:value-of select="@title" /></option>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>

</xsl:stylesheet>
