/*jslint browser: true */
/*global rtwi_strings*/


var RTWI = {};
RTWI.xmlHttp = null;


RTWI.getHttpReqestObject = function () {
    'use strict';
    var xmlHttp = null;

    try {
        xmlHttp = new window.XMLHttpRequest();
    } catch (exception) {
        window.alert(rtwi_strings.ajaxNotSupported); // "Your browser does not support AJAX!"
        return false;
    }
    return xmlHttp;
};


// Some AJAX operation changed state, show it...
RTWI.handleReadyStateChange = function () {
    'use strict';
    var node = document.getElementById('TB_content');

    switch (RTWI.xmlHttp.readyState) {
    case 0:
        node.innerHTML = 0;
        break;
    case 1:
        node.innerHTML = rtwi_strings.requesting; // 'Requesting...'
        break;
    case 2:
        node.innerHTML = 2;
        break;
    case 3:
        node.innerHTML = rtwi_strings.processing; // 'Processing...'
        break;
    case 4:
        node.innerHTML = RTWI.xmlHttp.responseText;
        RTWI.xmlHttp = null;
        break;
    default:
        node.innerHTML = '.';
        break;
    }
};


// Load: peer list, informations, file list or tracker list.
RTWI.loadcontent = function (page, node) {
    'use strict';
    var titleNode = document.getElementById('TB_title'),
        hash = titleNode.getAttribute('data-hash'),
        menuitems = null,
        i = 0,
        c = 0;

    // check if ajax request is already running
    if (RTWI.xmlHttp) {
        return;
    }
    RTWI.xmlHttp = RTWI.getHttpReqestObject();
    if (!RTWI.xmlHttp) {
        return;
    }
    // unselect all menuitems
    menuitems = document.getElementById('TB_menu').getElementsByClassName('menuitem');
    c = menuitems.length;
    for (i = 0; i < c; i += 1) {
        menuitems[i].className = 'menuitem';
    }
    // select clicked menuitem
    node.className = 'menuitem current';
    RTWI.xmlHttp.onreadystatechange = RTWI.handleReadyStateChange;
    RTWI.xmlHttp.open('GET', '?mod=torrent&hash=' + hash + '&page=' + page + '&ajax=true', true);
    RTWI.xmlHttp.send(null);
};


// Set directory priority.
RTWI.loadcontent_dirpriority = function (iurl, hash, dir, dirpriority) {
    'use strict';

    // check if AJAX call is already running
    if (RTWI.xmlHttp) {
        return;
    }
    RTWI.xmlHttp = RTWI.getHttpReqestObject();
    if (!RTWI.xmlHttp) {
        return;
    }
    RTWI.xmlHttp.onreadystatechange = RTWI.handleReadyStateChange;
    RTWI.xmlHttp.open('GET', iurl + '?mod=changedirpriority&hash=' + hash + '&dir=' + dir + '&dirpriority=' + dirpriority + '&ajax=true', true);
    RTWI.xmlHttp.send(null);
};


// Set file priority.
RTWI.loadcontent_filepriority = function (iurl, hash, id, filepriority) {
    'use strict';

    // check if AJAX call is already running
    if (RTWI.xmlHttp) {
        return;
    }
    RTWI.xmlHttp = RTWI.getHttpReqestObject();
    if (!RTWI.xmlHttp) {
        return;
    }
    RTWI.xmlHttp.onreadystatechange = RTWI.handleReadyStateChange;
    RTWI.xmlHttp.open('GET', iurl + '?mod=changefilepriority&hash=' + hash + '&id=' + id + '&filepriority=' + filepriority + '&ajax=true', true);
    RTWI.xmlHttp.send(null);
};


// Enable or disable torrent tracker.
RTWI.loadcontent_trackerenabled = function (iurl, hash, id, trackerenabled) {
    'use strict';

    // check if AJAX call is already running
    if (RTWI.xmlHttp) {
        return;
    }
    RTWI.xmlHttp = RTWI.getHttpReqestObject();
    if (!RTWI.xmlHttp) {
        return;
    }
    RTWI.xmlHttp.onreadystatechange = RTWI.handleReadyStateChange;
    RTWI.xmlHttp.open('GET', iurl + '?mod=changetrackerenabled&hash=' + hash + '&id=' + id + '&trackerenabled=' + trackerenabled + '&ajax=true', true);
    RTWI.xmlHttp.send(null);
};


// show popup divs
RTWI.hideDetailsPopup = function () {
    'use strict';
    var o = document.getElementById('TB_overlay'),
        w = document.getElementById('TB_window'),
        menuitems = null,
        i = 0,
        c = 0;

    o.style.display = 'none';
    w.style.visibility = 'hidden';
    document.getElementById('TB_content').innerHTML = '';
    // unselect all menuitems
    menuitems = document.getElementById('TB_menu').getElementsByClassName('menuitem');
    c = menuitems.length;
    for (i = 0; i < c; i += 1) {
        menuitems[i].className = 'menuitem';
    }
    // cancel any running ajax request
    if (RTWI.xmlHttp) {
        RTWI.xmlHttp.abort();
        RTWI.xmlHttp = null;
    }
};

// show popup divs
RTWI.showDetailsPopup = function (event) {
    'use strict';
    var o = document.getElementById('TB_overlay'),
        w = document.getElementById('TB_window'),
        t = document.getElementById('TB_title'),
        m = document.getElementById('TB_menu'),
        c = document.getElementById('TB_content'),
        node = event.target || event.srcElement,
        width = (window.innerWidth > 1000 ? 950 : window.innerWidth - 20),
        height = window.innerHeight - 60;

    event.preventDefault();
    t.setAttribute('data-hash', node.getAttribute('data-hash'));
    t.innerText = node.innerText;
    o.style.display = 'block';
    w.style.width = width + 'px';
    w.style.marginLeft = -1 * window.Math.round(width / 2) + 'px';
    w.style.height = height + 'px';
    w.style.top = 30 + 'px';
    w.style.visibility = 'visible';
    c.style.height = height - t.offsetHeight - m.offsetHeight - 2 * 16 + 'px';
};


// Called on body.onload and DOM node clicks,
// show and hide some DOM nodes.
RTWI.toggle = function (modpage) {
    'use strict';
    var uls = null,
        atts = null,
        i = 0,
        j = 0;

    switch (modpage) {
    case '_info':
    case 'torrent_info':
    case 'torrent_peers':
    case 'torrent_trackers':
        if (document.getElementById('changethrottleform')) {
            document.getElementById('throttleupinput').style.display = 'none';
            document.getElementById('throttledowninput').style.display = 'none';
            document.getElementById('tsubmit').style.display = 'none';
            document.getElementById('throttleup').style.display = '';
            document.getElementById('throttledown').style.display = '';
        }
        break;
    case 'serverinfo_info':
        if (document.getElementById('changethrottleform')) {
            document.getElementById('throttleupinput').style.display = 'none';
            document.getElementById('throttledowninput').style.display = 'none';
            document.getElementById('tsubmit').style.display = 'none';
            document.getElementById('throttleup').style.display = '';
            document.getElementById('throttledown').style.display = '';
        }
        document.getElementById('changedht').style.display = '';
        document.getElementById('changedhtselect').style.display = 'none';
        break;
    case '_info_restore':
        document.getElementById('throttleupinput').style.display = '';
        document.getElementById('throttledowninput').style.display = '';
        document.getElementById('tsubmit').style.display = '';
        document.getElementById('throttleup').style.display = 'none';
        document.getElementById('throttledown').style.display = 'none';
        break;
    case 'serverinfo_info_restore':
        if (document.getElementById('changethrottleform')) {
            document.getElementById('changedht').style.display = 'none';
            document.getElementById('changedhtselect').style.display = '';
        }
        break;
    case 'addtorrent_info':
        document.getElementById('torrenturl').style.display = 'none';
        break;
    case 'torrent_files':
        uls = document.getElementsByTagName('ul');
        for (i = 0; i < uls.length; i += 1) {
            atts = uls.item(i).attributes;
            for (j = 0; j < atts.length; j += 1) {
                if ('class' === atts[j].nodeName && 'directory' === atts[j].nodeValue) {
                    uls.item(i).style.display = 'none';
                }
            }
        }
        document.getElementById('throttleupinput').style.display = 'none';
        document.getElementById('throttledowninput').style.display = 'none';
        document.getElementById('tsubmit').style.display = 'none';
        document.getElementById('throttleup').style.display = '';
        document.getElementById('throttledown').style.display = '';
        break;
    }
};


// add click handlers when DOM is ready
RTWI.onDOMready = function () {
    'use strict';
    var arr = null,
        i = 0,
        c = 0,
        node = null;

    // open popup
    arr = document.getElementsByClassName('hasPopup');
    c = arr.length;
    for (i = 0; i < c; i += 1) {
        node = arr[i];
        node.addEventListener('click', RTWI.showDetailsPopup, false);
    }
    // close popup
    document.getElementById('TB_overlay').addEventListener('click', function () {
        RTWI.hideDetailsPopup();
    }, false);
    document.getElementById('TB_closeWindowButton').addEventListener('click', function (event) {
        event.preventDefault();
        RTWI.hideDetailsPopup();
    }, false);
};
document.addEventListener("DOMContentLoaded", RTWI.onDOMready);
