<?php

function myrealpath( $path, $home, $cwd ) {
	if ( substr( $path, 0, 2 ) == "~/" ) {
		$path = substr( $path, 2 );
		$path = "{$home}{$_SESSION["rtwi_nick"]}/{$path}";
	}

	$oldcwd = getcwd();
	chdir( $cwd );
	$newpath = realpath( $path );
	chdir( $oldcwd );

	return $newpath;
}

error_reporting( E_ALL );
error_reporting( E_ALL ^ E_NOTICE );

set_time_limit( 10 );

session_start();

$config = parse_ini_file( "includes/rtwi.conf", true );
$users = parse_ini_file( $config["user_conf"], true );

require_once( "includes/classes/xmlrpc_handler.inc.php" );
require_once( "includes/classes/bittorrent_handler.inc.php" );
require_once( "includes/tools/functions.time.inc.php" );

$st = getmicrotime();
$callnum = 0;
$calltime = 0;
$multicallnum = 0;

if ( isset( $_REQUEST["mod"] ) ) {
	$mod = $_REQUEST["mod"];
} else {
	$mod = "";
}

if ( isset( $_REQUEST["hash"] ) ) {
	$hash = $_REQUEST["hash"];
} else {
	$hash = "";
}

if ( ( !isset( $_SESSION["rtwi_auth"] ) || $_SESSION["rtwi_auth"] !== 1 ) && !in_array( $_REQUEST["mod"], array( "login", "changelanguage" ) ) ) {
	header( "location: {$config["index"]}" );
	exit;
} else {
	$xmlrpc = new xmlrpc_handler( $_SESSION["rtwi_cadr"], 10 );
}

$xml = new DOMDocument( "1.0", "utf-8" );
$xml->formatOutput = true;

$root = $xml->appendChild( $xml->createElement( "root" ) );

//print_r( $_SESSION );
//print_r( $_REQUEST );

switch ( $_REQUEST["mod"] ) {
	case "login" : { // login
		if ( isset( $_REQUEST["loginname"] ) && isset( $_REQUEST["loginpass"] ) && $_REQUEST["loginname"] != "" && $_REQUEST["loginpass"] != "" && array_key_exists( $_REQUEST["loginname"], $users ) && $users[$_REQUEST["loginname"]]["pass"] == sha1( $_REQUEST["loginpass"] ) ) {
			$_SESSION["rtwi_auth"] = 1;
			$_SESSION["rtwi_nick"] = $_REQUEST["loginname"];
			$_SESSION["rtwi_cadr"] = $users[$_REQUEST["loginname"]]["address"];

			// setting rtorrent's connection address
			if ( preg_match( "|^unix://(.+)$|", $_SESSION["rtwi_cadr"], $match ) ) {
				$_SESSION["rtwi_cadr"] = myrealpath( substr( $_SESSION["rtwi_cadr"], 7 ), $config["home_path"], "{$config["home_path"]}{$_SESSION["rtwi_nick"]}" );
				$_SESSION["rtwi_cadr"] = "unix://{$_SESSION["rtwi_cadr"]}";
			} elseif ( preg_match( "<^(http|https)://(.*)$>", $_SESSION["rtwi_cadr"], $match ) ) {
				$_SESSION["rtwi_password"] = $_REQUEST["loginpass"];
			}


			if ( isset( $_REQUEST["rememberme"] ) && $_REQUEST["rememberme"] == "on" ) {
				setcookie( "rtwi_auth", 1, time() + 60 * 60 * 24 * 365 );
				setcookie( "rtwi_nick", $_REQUEST["loginname"], time() + 60 * 60 * 24 * 365 );
			}

			$_SESSION["rtwi_err"] = "succlogin";
			header( "location: {$config["index"]}" );
			exit;
		} else {
			$_SESSION["rtwi_err"] = "badlogin";
			header( "location: {$config["index"]}" );
			exit;
		}

		break;
	}
	case "logout" : { // logout
		$_SESSION["rtwi_auth"] = 0;
		$_SESSION["rtwi_nick"] = "";
		$_SESSION["rtwi_cadr"] = "";
		$_SESSION["rtwi_view"] = "";
		$_SESSION["rtwi_refresh"] = 0;
		$_SESSION["rtwi_language"] = "";
		$_SESSION["rtwi_password"] = "";

		unset( $_SESSION["rtwi_auth"] );
		unset( $_SESSION["rtwi_nick"] );
		unset( $_SESSION["rtwi_cadr"] );
		unset( $_SESSION["rtwi_scgi"] );
		unset( $_SESSION["rtwi_view"] );
		unset( $_SESSION["rtwi_refresh"] );
		unset( $_SESSION["rtwi_language"] );
		unset( $_SESSION["rtwi_password"] );

		setcookie( "rtwi_auth", 0 );
		setcookie( "rtwi_nick", "" );

		$_SESSION["rtwi_err"] = "succlogout";
		header( "location: {$config["index"]}" );
		exit;

		break;
	}
	case "changeview" : { // change view
		if ( isset( $_REQUEST["viewtype"] ) && $_REQUEST["viewtype"] != "" ) {
			$xmlrpc->setrequest( "view_list", "" );
			$xmlrpc->call();
			$xmlrpc->parse();
			$viewtypes = $xmlrpc->fetch();

			if ( in_array( $_REQUEST["viewtype"], $viewtypes ) ) {
				$_SESSION["rtwi_view"] = $_REQUEST["viewtype"];
			} else {
				$_SESSION["rtwi_err"] = "badviewtype";
				header( "location: {$config["index"]}" );
				exit;
			}

			setcookie( "rtwi_view", $_SESSION["rtwi_view"], time() + 60 * 60 * 24 * 30 );

			$_SESSION["rtwi_err"] = "succviewchange";
			header( "location: {$config["index"]}" );
			exit;
		} else {
			$_SESSION["rtwi_err"] = "noviewtype";
			header( "location: {$config["index"]}" );
			exit;
		}

		break;
	}
	case "changerefresh" : { // change view
		if ( $config["refresh"] !== "1" ) {
			$_SESSION["rtwi_err"] = "refreshnotallowed";
			header( "location: {$config["index"]}" );
			exit;
		}
		if ( isset( $_REQUEST["refreshrate"] ) && $_REQUEST["refreshrate"] != "" ) {
			$refreshrate = $_REQUEST["refreshrate"];
			settype( $refreshrate, "int" );
			if ( $refreshrate < 60 ) {
				$refreshrate = 0;
			}

			$_SESSION["rtwi_refresh"] = $refreshrate;

			setcookie( "rtwi_refresh", $_SESSION["rtwi_refresh"], time() + 60 * 60 * 24 * 30 );

			$_SESSION["rtwi_err"] = "succrefreshchange";
			header( "location: {$_SESSION["rtwi_lastpage"]}" );
			exit;
		} else {
			$_SESSION["rtwi_err"] = "norefreshrate";
			header( "location: {$_SESSION["rtwi_lastpage"]}" );
			exit;
		}

		break;
	}
	case "changelanguage" : { // change language
		if ( $config["language"] !== "1" ) {
			$_SESSION["rtwi_err"] = "languagenotallowed";
			header( "location: {$config["index"]}" );
			exit;
		}
		if ( isset( $_REQUEST["language"] ) && $_REQUEST["language"] != "" ) {
			$language = $_REQUEST["language"];
			if ( is_readable( "includes/messages.{$language}.inc.php" ) ) {
				$_SESSION["rtwi_language"] = $language;

				setcookie( "rtwi_language", $_SESSION["rtwi_language"], time() + 60 * 60 * 24 * 30 );

				$_SESSION["rtwi_err"] = "succlanguagechange";
				header( "location: {$_SESSION["rtwi_lastpage"]}" );
				exit;
			} else {
				$_SESSION["rtwi_err"] = "badlanguage";
				header( "location: {$_SESSION["rtwi_lastpage"]}" );
				exit;
			}
		} else {
			$_SESSION["rtwi_err"] = "nolanguage";
			header( "location: {$_SESSION["rtwi_lastpage"]}" );
			exit;
		}

		break;
	}
	case "changethrottle" : { // change view
		if ( $config["throttle"] !== "1" ) {
			$_SESSION["rtwi_err"] = "throttlenotallowed";
			header( "location: {$config["index"]}" );
			exit;
		}
		if ( isset( $_REQUEST["upspeed"] ) && $_REQUEST["upspeed"] != "" && isset( $_REQUEST["downspeed"] ) && $_REQUEST["downspeed"] != "" ) {
			$upspeed = $_REQUEST["upspeed"];
			settype( $upspeed, "int" );
			if ( $upspeed < 0 ) {
				$upspeed = 0;
			}
			$downspeed = $_REQUEST["downspeed"];
			settype( $downspeed, "int" );
			if ( $downspeed < 0 ) {
				$downspeed = 0;
			}

			$xmlrpc->setrequest( "set_upload_rate", $upspeed * 1024 );
			$xmlrpc->call();
			$xmlrpc->setrequest( "set_download_rate", $downspeed * 1024 );
			$xmlrpc->call();

			$_SESSION["rtwi_err"] = "succthrottlechange";
			header( "location: {$_SESSION["rtwi_lastpage"]}" );
			exit;
		} else {
			$_SESSION["rtwi_err"] = "badthrottlevals";
			header( "location: {$_SESSION["rtwi_lastpage"]}" );
			exit;
		}

		break;
	}
	case "addtorrent" : { // add a torrent
		if ( !isset( $_REQUEST["tfmethod"] ) || !in_array( $_REQUEST["tfmethod"], array( "url", "file" ) ) ) {
			$_SESSION["rtwi_err"] = "badtfmethod";
			header( "location: {$config["index"]}?mod=addtorrent" );
			exit;
		}

		$xmlrpc->setrequest( "download_list", "" );
		$xmlrpc->call();
		$xmlrpc->parse();
		$torrents = $xmlrpc->fetch();

		$xmlrpc->setmrequest( array( "get_directory", "system.get_cwd" ) );
		$xmlrpc->call();
		$xmlrpc->parse();
		$directories = $xmlrpc->fetch();
		$directory = $directories[0][0];
		$cwd = $directories[1][0];

		$directory = myrealpath( $directory, $config["home_path"], $cwd );

		if ( $_REQUEST["tfmethod"] == "url" ) {
			if ( !isset( $_REQUEST["torrenturl"] ) || $_REQUEST["torrenturl"] == "" ) {
				$_SESSION["rtwi_err"] = "notorrenturl";
				header( "location: {$config["index"]}?mod=addtorrent" );
				exit;
			} elseif ( substr( $_REQUEST["torrenturl"], 0, 7 ) != "http://" ) {
				$_SESSION["rtwi_err"] = "notanurl";
				header( "location: {$config["index"]}?mod=addtorrent" );
				exit;
			}
			$torrent = $_REQUEST["torrenturl"];
		} else {
			if ( !isset( $_FILES ) || !is_array( $_FILES ) ) {
				$_SESSION["rtwi_err"] = "notorrentfileuploaded";
				header( "location: {$config["index"]}?mod=addtorrent" );
				exit;
			}
			switch ( $_FILES["torrentfile"]["error"] ) {
				case 0 : {
					if ( is_uploaded_file( $_FILES["torrentfile"]["tmp_name"] ) ) {
						$torrent = file_get_contents( $_FILES["torrentfile"]["tmp_name"] );
						$xmlrpc->set_type( &$torrent, "base64" );
					} else {
						$_SESSION["rtwi_err"] = "rtfileattack";
						header( "location: {$config["index"]}?mod=addtorrent" );
						exit;
					}

					break;
				}
				case 1 : {
					$_SESSION["rtwi_err"] = "rtfileinisize";
					header( "location: {$config["index"]}?mod=addtorrent" );
					exit;
				
					break;
				}
				case 2 : {
					$_SESSION["rtwi_err"] = "rtfileformsize";
					header( "location: {$config["index"]}?mod=addtorrent" );
					exit;
				
					break;
				}
				case 3 : {
					$_SESSION["rtwi_err"] = "rtfilepartial";
					header( "location: {$config["index"]}?mod=addtorrent" );
					exit;
				
					break;
				}
				case 4 : {
					$_SESSION["rtwi_err"] = "rtfilenofile";
					header( "location: {$config["index"]}?mod=addtorrent" );
					exit;
				
					break;
				}
				case 6 : {
					$_SESSION["rtwi_err"] = "rtfilenotmpdir";
					header( "location: {$config["index"]}?mod=addtorrent" );
					exit;
				
					break;
				}
				case 7 : {
					$_SESSION["rtwi_err"] = "rtfilenowrite";
					header( "location: {$config["index"]}?mod=addtorrent" );
					exit;
				
					break;
				}
				default : {
					$_SESSION["rtwi_err"] = "rtfileother";
					header( "location: {$config["index"]}?mod=addtorrent" );
					exit;
				
					break;
				}
			}
		}

		$dlpath = $_REQUEST["dlpath"];
		$dlpath = myrealpath( "{$directory}/{$dlpath}", $config["home_path"], $cwd );

		$param = array( $torrent );
		if ( $dlpath != "" ) {
			$param[] = "d.set_directory={$dlpath}";
		}
		if ( isset( $_REQUEST["torrentstart"] ) && $_REQUEST["torrentstart"] == "start" ) {
			$param[] = "d.start=";
		}

		if ( $_REQUEST["tfmethod"] == "url" || isset( $_REQUEST["keeptorrentfile"] ) && $_REQUEST["keeptorrentfile"] == "on"  ) {
			$xmlrpc->setrequest( "load_verbose", $param );
		} else {
			$xmlrpc->setrequest( "load_raw_verbose", $param );
		}
		$xmlrpc->call();

		$_SESSION["rtwi_err"] = "succtorrentload";
		header( "location: {$config["index"]}" );
		exit;

		break;
	}
	case "torrentstart" : { // start a torrent
		$xmlrpc->setrequest( "download_list", "" );
		$xmlrpc->call();
		$xmlrpc->parse();
		$torrents = $xmlrpc->fetch();

		if ( !in_array( $hash, $torrents ) ) {
			$_SESSION["rtwi_err"] = "nohashfound";
			header( "location: {$config["index"]}" );
			exit;
		}

		$xmlrpc->setrequest( "d.start", $hash );
		$xmlrpc->call();

		sleep( 1 );

		$_SESSION["rtwi_err"] = "succtorrentstart";
		header( "location: {$config["index"]}" );
		exit;

		break;
	}
	case "torrentopen" : { // open a torrent
		$xmlrpc->setrequest( "download_list", "" );
		$xmlrpc->call();
		$xmlrpc->parse();
		$torrents = $xmlrpc->fetch();

		if ( !in_array( $hash, $torrents ) ) {
			$_SESSION["rtwi_err"] = "nohashfound";
			header( "location: {$config["index"]}" );
			exit;
		}

		$xmlrpc->setrequest( "d.open", $hash );
		$xmlrpc->call();

		sleep( 1 );

		$_SESSION["rtwi_err"] = "succtorrentopen";
		header( "location: {$config["index"]}" );
		exit;

		break;
	}
	case "torrentstop" : { // stop a torrent
		$xmlrpc->setrequest( "download_list", "" );
		$xmlrpc->call();
		$xmlrpc->parse();
		$torrents = $xmlrpc->fetch();

		if ( !in_array( $hash, $torrents ) ) {
			$_SESSION["rtwi_err"] = "nohashfound";
			header( "location: {$config["index"]}" );
			exit;
		}

		$xmlrpc->setrequest( "d.stop", $hash );
		$xmlrpc->call();

		sleep( 1 );

		$_SESSION["rtwi_err"] = "succtorrentstop";
		header( "location: {$config["index"]}" );
		exit;

		break;
	}
	case "torrentclose" : { // close a torrent
		$xmlrpc->setrequest( "download_list", "" );
		$xmlrpc->call();
		$xmlrpc->parse();
		$torrents = $xmlrpc->fetch();

		if ( !in_array( $hash, $torrents ) ) {
			$_SESSION["rtwi_err"] = "nohashfound";
			header( "location: {$config["index"]}" );
			exit;
		}

		$xmlrpc->setrequest( "d.close", $hash );
		$xmlrpc->call();

		sleep( 1 );

		$_SESSION["rtwi_err"] = "succtorrentclose";
		header( "location: {$config["index"]}" );
		exit;

		break;
	}
	case "torrentcheckhash" : { // check hash for a torrent
		$xmlrpc->setrequest( "download_list", "" );
		$xmlrpc->call();
		$xmlrpc->parse();
		$torrents = $xmlrpc->fetch();

		if ( !in_array( $hash, $torrents ) ) {
			$_SESSION["rtwi_err"] = "nohashfound";
			header( "location: {$config["index"]}" );
			exit;
		}

		$xmlrpc->setrequest( "d.check_hash", $hash );
		$xmlrpc->call();

		sleep( 1 );

		$_SESSION["rtwi_err"] = "succtorrentcheckhash";
		header( "location: {$config["index"]}" );
		exit;

		break;
	}
	case "torrentremove" : { // remove a torrent
		$xmlrpc->setrequest( "download_list", "" );
		$xmlrpc->call();
		$xmlrpc->parse();
		$torrents = $xmlrpc->fetch();

		if ( !in_array( $hash, $torrents ) ) {
			$_SESSION["rtwi_err"] = "nohashfound";
			header( "location: {$config["index"]}" );
			exit;
		}

		$xmlrpc->setrequest( "d.erase", $hash );
		$xmlrpc->call();

		sleep( 1 );

		$_SESSION["rtwi_err"] = "succtorrentremove";
		header( "location: {$config["index"]}" );
		exit;

		break;
	}
	case "torrenterase" : { // erase a torrent and delete the data
		if ( $config["erase"] !== "1" ) {
			$_SESSION["rtwi_err"] = "erasenotallowed";
			header( "location: {$config["index"]}" );
			exit;
		}
		$xmlrpc->setrequest( "download_list", "" );
		$xmlrpc->call();
		$xmlrpc->parse();
		$torrents = $xmlrpc->fetch();

		if ( !in_array( $hash, $torrents ) ) {
			$_SESSION["rtwi_err"] = "nohashfound";
			header( "location: {$config["index"]}" );
			exit;
		}

		$xmlrpc->setrequest( "d.multicall", array( "", "d.get_hash=", "d.get_directory=", "d.get_size_files=" ) );
		$xmlrpc->call();
		$xmlrpc->parse();
		$response = $xmlrpc->fetch();
		foreach ( $response as $key => $val ) {
			if ( $val[0] == $hash ) {
				$response = $val;
			}
		}
		$directory = $response[1];
		$size_files = $response[2];

		$xmlrpc->setmrequest( array( "get_directory", "system.get_cwd" ) );
		$xmlrpc->call();
		$xmlrpc->parse();
		$directories = $xmlrpc->fetch();
		$dd = $directories[0][0];
		$cwd = $directories[1][0];

		$directory = myrealpath( $directory, $config["home_path"], $cwd );
		$dd = myrealpath( $dd, $config["home_path"], $cwd );

		$xmlrpc->setrequest( "f.multicall", array( $hash, 0, "f.get_frozen_path=" ) );
		$xmlrpc->call();
		$xmlrpc->parse();
		$files = $xmlrpc->fetch();

		$unlink_num = 0;
		$dirs = array();
		foreach ( $files as $key => $val ) {
			$dirs[] = dirname( $val[0] );
			if ( is_writable( $val[0] ) ) {
				if ( @unlink( $val[0] ) ) {
					$unlink_num++;
				}
			}
		}

		$dirs = array_unique( $dirs );
		foreach ( $dirs as $key => $val ) {
			$pattern = "'({$directory}.*?)(/[^/]*)$'";
			if ( preg_match( $pattern, $val, $match ) ) {
				$dirs[] = $match[1];
			}
		}
		$dirs = array_unique( $dirs );
		if ( in_array( $dd, $dirs ) ) {
			$key = array_search( $dd, $dirs );
			unset( $dirs[$key] );
		}
		rsort( $dirs );
		//print_r( $dirs );

		$size_dirs = $size_files == 1 ? 0 : count( $dirs );
		$rmdir_num = 0;
		foreach ( $dirs as $key => $val ) {
			if ( is_writable( $val ) ) {
				if ( @rmdir( $val ) ) {
					$rmdir_num++;
				}
			}
		}

		$xmlrpc->setrequest( "d.erase", $hash );
		$xmlrpc->call();

		sleep( 1 );

		if ( $unlink_num != $size_files || $rmdir_num != $size_dirs ) {
			$_SESSION["rtwi_err"] = "warntorrenterase";
			header( "location: {$config["index"]}" );
			exit;
		} else {
			$_SESSION["rtwi_err"] = "succtorrenterase";
			header( "location: {$config["index"]}" );
			exit;
		}

		break;
	}
	case "doonalltorrent" : { // do some task on all torrent
		switch ( $_REQUEST["task"] ) {
			case "start" : {
				$xmlrpc->setrequest( "d.multicall", array( "", "d.start=" ) );
				$xmlrpc->call();

				sleep( 1 );

				$_SESSION["rtwi_err"] = "succtorrentsstart";
				header( "location: {$config["index"]}" );
				exit;

				break;
			}
			case "stop" : {
				$xmlrpc->setrequest( "d.multicall", array( "", "d.stop=" ) );
				$xmlrpc->call();

				sleep( 1 );

				$_SESSION["rtwi_err"] = "succtorrentsstop";
				header( "location: {$config["index"]}" );
				exit;

				break;
			}
			case "open" : {
				$xmlrpc->setrequest( "d.multicall", array( "", "d.open=" ) );
				$xmlrpc->call();

				sleep( 1 );

				$_SESSION["rtwi_err"] = "succtorrentsopen";
				header( "location: {$config["index"]}" );
				exit;

				break;
			}
			case "close" : {
				$xmlrpc->setrequest( "d.multicall", array( "", "d.close=" ) );
				$xmlrpc->call();

				sleep( 1 );

				$_SESSION["rtwi_err"] = "succtorrentsclose";
				header( "location: {$config["index"]}" );
				exit;

				break;
			}
			case "checkhash" : {
				$xmlrpc->setrequest( "d.multicall", array( "", "d.check_hash=" ) );
				$xmlrpc->call();

				sleep( 1 );

				$_SESSION["rtwi_err"] = "succtorrentscheckhash";
				header( "location: {$config["index"]}" );
				exit;

				break;
			}
			case "remove" : {
				$xmlrpc->setrequest( "d.multicall", array( "", "d.erase=" ) );
				$xmlrpc->call();

				sleep( 1 );

				$_SESSION["rtwi_err"] = "succtorrentsremove";
				header( "location: {$config["index"]}" );
				exit;

				break;
			}
			default : {
				$_SESSION["rtwi_err"] = "nooponalltorrent";
				header( "location: {$config["index"]}" );
				exit;

				break;
			}
		}
		
		break;
	}
	case "changepriority" : { // set priority
		$xmlrpc->setrequest( "download_list", "" );
		$xmlrpc->call();
		$xmlrpc->parse();
		$torrents = $xmlrpc->fetch();

		if ( !in_array( $hash, $torrents ) ) {
			$_SESSION["rtwi_err"] = "nohashfound";
			header( "location: {$config["index"]}" );
			exit;
		}

		if ( isset( $_REQUEST["priority"] ) ) {
			$priority = $_REQUEST["priority"];
		} else {
			$_SESSION["rtwi_err"] = "nopriorityfound";
			header( "location: {$config["index"]}" );
			exit;
		}

		if ( !in_array( $priority, array( 0, 1, 2, 3 ) ) ) {
			$_SESSION["rtwi_err"] = "badpriorityfoiund";
			header( "location: {$config["index"]}" );
			exit;
		}

		$xmlrpc->setrequest( "d.set_priority", array( $hash, $priority ) );
		$xmlrpc->call();

		sleep( 1 );

		$_SESSION["rtwi_err"] = "succprioritychange";
		header( "location: {$config["index"]}" );
		exit;

		break;
	}
	case "changefilepriority" : { // set file priority
		$xmlrpc->setrequest( "download_list", "" );
		$xmlrpc->call();
		$xmlrpc->parse();
		$torrents = $xmlrpc->fetch();

		if ( isset( $_REQUEST["ajax"] ) && $_REQUEST["ajax"] == "true" ) {
			$tourl = "{$config["index"]}?mod=torrent&hash={$hash}&page=files&ajax=true";
		} else {
			$tourl = "{$config["index"]}?mod=torrent&hash={$hash}&page=files";
		}

		if ( !in_array( $hash, $torrents ) ) {
			$_SESSION["rtwi_err"] = "nohashfound";
			header( "location: {$tourl}" );
			exit;
		}

		if ( isset( $_REQUEST["id"] ) ) {
			$id = $_REQUEST["id"];
			settype( $id, "int" );
		} else {
			$_SESSION["rtwi_err"] = "noidfound";
			header( "location: {$tourl}" );
			exit;
		}

		$xmlrpc->setrequest( "d.get_size_files", $hash );
		$xmlrpc->call();
		$xmlrpc->parse();
		$response = $xmlrpc->fetch();

		if ( $id < 0 || $id > $response ) {
			$_SESSION["rtwi_err"] = "badidfound";
			header( "location: {$tourl}" );
			exit;
		}

		if ( isset( $_REQUEST["filepriority"] ) ) {
			$filepriority = $_REQUEST["filepriority"];
			settype( $filepriority, "int" );
		} else {
			$_SESSION["rtwi_err"] = "nopriorityfound";
			header( "location: {$tourl}" );
			exit;
		}

		if ( !in_array( $filepriority, array( 0, 1, 2 ) ) ) {
			$_SESSION["rtwi_err"] = "badpriorityfound";
			header( "location: {$tourl}" );
			exit;
		}

		$xmlrpc->setrequest( "f.set_priority", array( $hash, $id, $filepriority ) );
		$xmlrpc->call();

		$xmlrpc->setrequest( "d.update_priorities", $hash );
		$xmlrpc->call();

		sleep( 1 );

		$_SESSION["rtwi_err"] = "succfileprioritychange";
		header( "location: {$tourl}" );
		exit;

		break;
	}
	case "changedirpriority" : { // set file priority
		$xmlrpc->setrequest( "download_list", "" );
		$xmlrpc->call();
		$xmlrpc->parse();
		$torrents = $xmlrpc->fetch();

		if ( isset( $_REQUEST["ajax"] ) && $_REQUEST["ajax"] == "true" ) {
			$tourl = "{$config["index"]}?mod=torrent&hash={$hash}&page=files&ajax=true";
		} else {
			$tourl = "{$config["index"]}?mod=torrent&hash={$hash}&page=files";
		}

		if ( !in_array( $hash, $torrents ) ) {
			$_SESSION["rtwi_err"] = "nohashfound";
			header( "location: {$tourl}" );
			exit;
		}

		if ( isset( $_REQUEST["dirpriority"] ) ) {
			$dirpriority = $_REQUEST["dirpriority"];
			settype( $dirpriority, "int" );
		} else {
			$_SESSION["rtwi_err"] = "nopriorityfound";
			header( "location: {$tourl}" );
			exit;
		}

		if ( !in_array( $dirpriority, array( 0, 1, 2 ) ) ) {
			$_SESSION["rtwi_err"] = "badpriorityfound";
			header( "location: {$tourl}" );
			exit;
		}

		if ( isset( $_REQUEST["dir"] ) ) {
			$dir = $_REQUEST["dir"];
		} else {
			$_SESSION["rtwi_err"] = "nodirfound";
			header( "location: {$tourl}" );
			exit;
		}

		if ( substr( $dir, -1 ) != "/" ) {
			$dir = "{$dir}/";
		}
		$len = strlen( $dir );

		$xmlrpc->setrequest( "f.multicall", array( $hash, 0, "f.get_frozen_path=" ) );
		$xmlrpc->call();
		$xmlrpc->parse();
		$files = $xmlrpc->fetch();

		$badpath = true;
		$request = array();
		$params = array();
		foreach ( $files as $key => $val ) {
			if ( strpos( $val[0], $dir ) === 0 ) {
				$request[] = "f.set_priority";
				$params[] = array( $hash, $key, $dirpriority );
				$filestochange[] = array( $key, $val[0] );
				if ( $badpath == true ) {
					$badpath = false;
				}
			}
		}

		if ( $badpath === true ) {
			$_SESSION["rtwi_err"] = "baddirfound";
			header( "location: {$tourl}" );
			exit;
		}

		$xmlrpc->setumrequest( $request, $params );
		$xmlrpc->call();
		$xmlrpc->parse();
		$torrents = $xmlrpc->fetch();

		$xmlrpc->setrequest( "d.update_priorities", $hash );
		$xmlrpc->call();
		$xmlrpc->parse();
		$torrents = $xmlrpc->fetch();

		sleep( 1 );

		$_SESSION["rtwi_err"] = "succdirprioritychange";
		header( "location: {$tourl}" );
		exit;

		break;
	}
	case "changetrackerenabled" : { // set if tracker is enabled
		$xmlrpc->setrequest( "download_list", "" );
		$xmlrpc->call();
		$xmlrpc->parse();
		$torrents = $xmlrpc->fetch();

		if ( isset( $_REQUEST["ajax"] ) && $_REQUEST["ajax"] == "true" ) {
			$tourl = "{$config["index"]}?mod=torrent&hash={$hash}&page=trackers&ajax=true";
		} else {
			$tourl = "{$config["index"]}?mod=torrent&hash={$hash}&page=trackers";
		}

		if ( !in_array( $hash, $torrents ) ) {
			$_SESSION["rtwi_err"] = "nohashfound";
			header( "location: {$tourl}" );
			exit;
		}

		if ( isset( $_REQUEST["id"] ) ) {
			$id = $_REQUEST["id"];
			settype( $id, "int" );
		} else {
			$_SESSION["rtwi_err"] = "noidfound";
			header( "location: {$tourl}" );
			exit;
		}

		$xmlrpc->setrequest( "d.get_size_trackers", $hash );
		$xmlrpc->call();
		$xmlrpc->parse();
		$response = $xmlrpc->fetch();

		if ( $id < 0 || $id > $response ) {
			$_SESSION["rtwi_err"] = "badidfound";
			header( "location: {$tourl}" );
			exit;
		}

		if ( isset( $_REQUEST["trackerenabled"] ) ) {
			$trackerenabled = $_REQUEST["trackerenabled"];
			settype( $trackerenabled, "int" );
		} else {
			$_SESSION["rtwi_err"] = "novaluefound";
			header( "location: {$tourl}" );
			exit;
		}

		if ( !in_array( $trackerenabled, array( 0, 1 ) ) ) {
			$_SESSION["rtwi_err"] = "badvaluefound";
			header( "location: {$tourl}" );
			exit;
		}

		$xmlrpc->setrequest( "t.set_enabled", array( $hash, $id, $trackerenabled ) );
		$xmlrpc->call();

		sleep( 1 );

		$_SESSION["rtwi_err"] = "succtrackerenabledchange";
		header( "location: {$tourl}" );
		exit;

		break;
	}
	case "changedhtstatus" : { // start/stop dht server
		if ( !isset( $_REQUEST["dhtstatus"] ) || $_REQUEST["dhtstatus"] == "" ) {
			$_SESSION["rtwi_err"] = "novaluefound";
			header( "location: {$config["index"]}?mod=serverinfo" );
			exit;
		}

		$dhtstatus = $_REQUEST["dhtstatus"];
		settype( $dhtstatus, "int" );
		if ( $dhtstatus != 0 && $dhtstatus != 1 ) {
			$_SESSION["rtwi_err"] = "badvaluefound";
			header( "location: {$config["index"]}?mod=serverinfo" );
			exit;
		}

		$dhtstatus = $dhtstatus == 1 ? "on" : "off";

		$xmlrpc->setrequest( "dht", $dhtstatus );
		$xmlrpc->call();

		$_SESSION["rtwi_err"] = $dhtstatus == "on" ? "succdhtstart" : "succdhtstop";

		sleep( 1 );

		header( "location: {$config["index"]}?mod=serverinfo" );
		exit;

		break;
	}
	default : {
		$_SESSION["rtwi_err"] = "noinputmod";
		header( "location: {$_SESSION["rtwi_lastpage"]}" );
		exit;

		break;
	}
}

?>
