<?php

/*
2 info
1 error
0 none
*/

class net_handler {

	private $net_host;
	private $net_url;
	private $net_port;
	private $net_tmpfile;
	private $net_cookie;
	private $net_charset;
	private $net_errno;
	private $net_errmsg;
	private $net_debugmode;

	private $net_reply;

	private $net_connection;
	private $net_lasterrorcode = 0;

	function net_handler( &$net ) {
		if ( $net["allownameres"] === true ) {
			$this->net_host		= gethostbyname( $net["host"] );
		} else {
			$this->net_host		= $net["host"];
		}
		$this->net_port			= $net["port"];
		$this->net_tmpfile		= $net["tmpfile"];
		$this->net_timeout		= $net["timeout"];
		$this->net_url			= $net["url"];
		$this->net_cookie		= $net["cookie"];
		$this->net_debugmode		= $net["debugmode"];
	}

	function net_connect() {
		if ( $this->net_debugmode === 2 ) {
			print "Connecting to {$this->net_host} on port {$this->net_port} (timeout: {$this->net_timeout}).";
		}
		do {
			if ( $this->net_debugmode === 2 ) {
				print "\r\nTrying...";
			}
			$this->net_connection = @pfsockopen( $this->net_host, $this->net_port, $this->net_errno, $this->net_errstr, $this->net_timeout );
			if ( $this->net_connection === false && $this->net_debugmode > 0 ) {
				print trim( $this->net_errstr );
			}
		} while ( $this->net_connection === false );

		if ( $this->net_debugmode === 2 ) {
			print "done.\r\n";
		}

		return true;
	}

	function net_seturl( $url ) {
		$this->net_url = $url;
		return true;
	}

	function net_request() {
		if ( $this->net_debugmode === 2 ) {
			print "Sending data...";
		}

		$out  = "GET {$this->net_url} HTTP/1.1\r\n";
		$out .= "Host: {$this->net_host}\r\n";
		$out .= "User-Agent: Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.8.1) Gecko/20060918 Firefox/2.0\r\n";
		$out .= "Accept: text/xml,application/xml,application/xhtml+xml,text/html,text/plain,image/png,*/*;\r\n";
		$out .= "Accept-Language: hu,en-us,en;q=0.5\r\n";
		$out .= "Accept-Encoding: gzip,deflate\r\n";
		$out .= "Accept-Charset: ISO-8859-2,utf-8;*\r\n";
		$out .= "Keep-Alive: 300\r\n";
		$out .= "Connection: keep-alive\r\n";
		if ( $this->net_cookie !== "" ) {
			$out .= "Cookie: {$this->net_cookie}\r\n";
		}
		$out .= "\r\n";

		$ret = fwrite( $this->net_connection, $out );
		if ( $this->net_debugmode === 2 ) {
			print "done, {$ret} byte(s) sent.\r\n";
		}

		fflush( $this->net_connection );
		if ( $this->net_debugmode === 2 ) {
			print "Data flushed.\r\n";
		}
	}

	function net_readreply() {
		if ( $this->net_debugmode === 2 ) {
			print "Recieving reply...";
		}

		if ( isset( $this->net_reply ) ) {
			unset( $this->net_reply );
		}

		$ret = 0;
		$this->net_reply["status"] = fgets( $this->net_connection );
		$ret += strlen( $this->net_reply["status"] );
		$this->net_reply["status"] = trim( $this->net_reply["status"] );

		do {
			$content = fgets( $this->net_connection );
			$ret += strlen( $content );
			$content = trim( $content );
			$contents = split( ": ", $content );

			if( $content !== "" ) {
				$this->net_reply["header"][strtolower( $contents[0] )] = $contents[1];
			}

		} while ( $content !== "" );

		if ( $this->net_debugmode === 2 ) {
			print "done, {$ret} byte(s) recieved for headers.\r\n";
			print_r( $this->net_reply );
		}

		return $ret;
	}

	function net_readcontent( $file = "" ) {
		if ( $file == "" ) {
			$file = $this->net_tmpfile;
		}
		if ( $this->net_reply["status"] === "HTTP/1.1 200 OK" ) {

			if ( $this->net_debugmode === 2 ) {
				print "Reading message body.\r\n";
			}

			if ( isset ( $this->net_reply["header"]["transfer-encoding"] ) && $this->net_reply["header"]["transfer-encoding"] === "chunked" ) {
				$ret = $this->net_readchunkedcontent( $file );
			} else {
				$ret = $this->net_readsimplecontent( $file );
			}

			if ( $this->net_debugmode === 2 ) {
				print "\r\nDone, {$ret} byte(s) was recieved for message body, and has been written to file.\r\n\r\n";
			}
		}
	}

	function net_disconnect() {
		if ( $this->net_debugmode === 2 ) {
			print "Closing connection...";
		}
		fclose( $this->net_connection );
		if ( $this->net_debugmode === 2 ) {
			print "done.\r\n";
		}
	}

	private function net_readsimplecontent( &$file ) {
		if ( $this->net_debugmode === 2 ) {
			print "\r\nOpening file...";
		}
		$filehandle = fopen( $file, "wb+" );
		if ( $this->net_debugmode === 2 ) {
			print "done.\r\n";
			print "Trying to read data as 8192 byte blocks in \"simple\" mode...\r\n";
		}

		if ( isset ( $this->net_reply["header"]["content-length"] ) ) {
			settype( $this->net_reply["header"]["content-length"], "int" );
			$block = $this->net_reply["header"]["content-length"];

			$ret = 0;
			$done = false;
			while ( $done === false ) {
				if ( $block < 8192 ) {
					$content = fread( $this->net_connection, $block );
				} else {
					$content = fread( $this->net_connection, 8192 );
				}

				$len = fwrite( $filehandle, $content );
				$ret += $len;

				if ( $block < 8192 ) {
					$block -= $len;
				}

				if ( $this->net_debugmode === 2 ) {
					print "{$len} byte(s) was recieved, and has been written to file.\r\n";
				}

				fflush( $filehandle );
				if ( $this->net_debugmode === 2 ) {
					print "File flushed.\r\n";
				}

				if ( $block === 0 || feof( $this->net_connection ) ) {
					$done = true;
				}
			}
		} else {
			$ret = 0;
			while ( !feof( $this->net_connection ) ) {
				$content = fread( $this->net_connection, 8192 );

				$len = fwrite( $filehandle, $content );
				$ret += $len;

				if ( $this->net_debugmode === 2 ) {
					print "{$len} byte(s) was recieved, and has been written to file.\r\n";
				}

				fflush( $filehandle );
				if ( $this->net_debugmode === 2 ) {
					print "File flushed.\r\n";
				}
			}
		}

		if ( $this->net_debugmode === 2 ) {
			print "Closing file...";
		}
		fclose( $filehandle );
		if ( $this->net_debugmode === 2 ) {
			print "done.\r\n";
		}

		return $ret;
	}

	private function net_readchunkedcontent( &$file ) {
		if ( $this->net_debugmode === 2 ) {
			print "\r\nOpening file...";
		}
		$filehandle = fopen( $file, "wb+" );
		if ( $this->net_debugmode === 2 ) {
			print "done.\r\n";
		}

		$ret = 0;
		$done = false;
		while ( $done === false ) {
			$chunklength = hexdec( trim( fgets( $this->net_connection ) ) );
			if ( $chunklength === 0 ) {
				fgets( $this->net_connection );
				$done = true;
			} else {
				if ( $this->net_debugmode === 2 ) {
					print "Trying to read {$chunklength} byte(s) in \"chunked\" mode...";
				}

				$contents = "";
				$len = 0;
				$flen = 0;
				while ( $chunklength > 0 ) {
					$content = fread( $this->net_connection, $chunklength  );
					//if ( $content === false ) { exit; };
					$contents .= $content;

					$len = strlen( $content );
					$chunklength -= $len;
					$flen += $len;
					$ret += $len;

					if ( $this->net_debugmode === 2 ) {
						if ( $chunklength === 0 ) {
							print "done.\r\n";
						} else {
							print "recieved {$len} byte(s).\r\nNeed to get another {$chunklength} byte(s)....";
						}
					}
				}
				fgets( $this->net_connection );

				fwrite( $filehandle, $contents );
				if ( $this->net_debugmode === 2 ) {
					print "{$flen} byte(s) has been written to file.\r\n";
				}

				fflush( $filehandle );
				if ( $this->net_debugmode === 2 ) {
					print "File flushed.\r\n";
				}
			}
		}

		if ( $this->net_debugmode === 2 ) {
			print "Closing file...";
		}
		fclose( $filehandle );
		if ( $this->net_debugmode === 2 ) {
			print "done.\r\n";
		}

		return $ret;
	}
}

?>