<?php

class sql_handler {
	var $sql_host;
	var $sql_db;
	var $sql_user;
	var $sql_pass;

	var $data;
	var $result;

	function __construct( &$sql ) {
		$this->data = new db_handler( $sql );
		$this->data->db_connect();
	}

	function get_info() {
		return $this->data->db_info();
	}

	function load_content( &$sel_array ) {
		$query = "SELECT {$sel_array["sel_what"]} FROM {$sel_array["sel_table"]}";

		if ( isset( $sel_array["sel_where"] ) ) {
			$query .= " WHERE {$sel_array["sel_where"]}";
		}

		if ( isset( $sel_array["sel_orderby"] ) ) {
			$query .= " ORDER BY {$sel_array["sel_orderby"]}";

			if ( isset( $sel_array["sel_how"] ) ) {
				$query .= " {$sel_array["sel_how"]}";
			} else {
				$query .= " ASC";
			}
		}

		if ( isset( $sel_array["sel_limit"] ) ) {
			$query .= " LIMIT {$sel_array["sel_limit"]}";
		}

		$query .= ";";

		$this->result = $this->data->db_query( $query );

		return $this->result;
	}

	function add_content( &$add_array ) {
		$query = "INSERT INTO {$add_array["add_table"]} ({$add_array["add_fields"]}) VALUES ({$add_array["add_what"]});";
		$this->result = $this->data->db_query( $query );
		return $this->result;
	}

	function set_content( &$set_array ) {
		$query = "UPDATE {$set_array["set_table"]} SET {$set_array["set_changes"]} WHERE {$set_array["set_where"]};";
		$this->result = $this->data->db_query( $query );
		return $this->result;
	}

	function del_content( &$del_array ) {
		$query = "DELETE FROM {$del_array["del_table"]} WHERE {$del_array["del_where"]};";
		$this->result = $this->data->db_query( $query );
		return $this->result;
	}

	function describe_table( &$desc_array ) {
		$query = "DESCRIBE {$desc_array["desc_table"]} {$desc_array["desc_field"]};";
		$this->result = $this->data->db_query( $query );
		return $this->result;
	}

	function alter_table( &$alt_array ) {
		$query = "ALTER TABLE {$alt_array["alt_table"]} CHANGE {$alt_array["alt_field"]} {$alt_array["alt_field"]} {$alt_array["alt_value"]} CHARACTER SET {$alt_array["alt_charset"]} COLLATE {$alt_array["alt_collate"]} {$alt_array["alt_null"]};";
		$this->result = $this->data->db_query( $query );
		return $this->result;
	}

	function get_content( &$xml, &$node, $nodename ) {
		$this->content = $this->data->db_fetch( $xml, $node, $nodename );
		return $this->content;
	}

	function __destruct() {
	}

}

?>
