<?php

function ip_to_long( $from ) {
	list( $_1, $_2, $_3, $_4 ) = explode( ".", $from );

	$to = 0.0 + ( ( ( ( ( $_1 * 256 ) + $_2 ) * 256) + $_3 ) * 256 ) + $_4;
	return $to;
}

function long_to_ip( $from ) {
	if ( $from >= 2147483648 ) {
		$from -= 2147483648;
		$_1 = $from % 256;
		$from = ( $from - $_1 ) / 256;
		$_2 = $from % 256;
		$from = ( $from - $_2 ) / 256;
		$_3 = $from % 256;
		$from = ( $from - $_3 ) / 256;
		$_4 = $from % 256 + 128;
	} else {
		$_1 = $from % 256;
		$from = ( $from - $_1 ) / 256;
		$_2 = $from % 256;
		$from = ( $from - $_2 ) / 256;
		$_3 = $from % 256;
		$from = ( $from - $_3 ) / 256;
		$_4 = $from % 256;
	}

	$to = "{$_4}.{$_3}.{$_2}.{$_1}";
	return $to;
}

function ip_to_hex( $from, $spacer ) {
	$_ip = $from;
	$tok = strtok( $_ip, "." );
	$_1 = $tok;
	$tok = strtok( "." );
	$_2 = $tok;
	$tok = strtok( "." );
	$_3 = $tok;
	$tok = strtok( "." );
	$_4 = $tok;

	if ( strlen( $_1 ) < 2 ) {
		$_1h = "0".dechex( $_1 );
	} else {
		$_1h = dechex( $_1 );
	}

	if ( strlen( $_2 ) < 2 ) {
		$_2h = "0".dechex( $_2 );
	} else {
		$_2h = dechex( $_2 );
	}

	if ( strlen( $_3 ) < 2 ) {
		$_3h = "0".dechex( $_3 );
	} else {
		$_3h = dechex( $_3 );
	}

	if ( strlen( $_4 ) < 2 ) {
		$_4h = "0".dechex( $_4 );
	} else {
		$_4h = dechex( $_4 );
	}

	$to = "{$_1h}{$spacer}{$_2h}{$spacer}{$_3h}{$spacer}{$_4h}";
	return $to;
}

function hex_to_ip( $from ) {
	$_1 = substr( $from, 0, 2 );
	$_2 = substr( $from, 2, 2 );
	$_3 = substr( $from, 4, 2 );
	$_4 = substr( $from, 6, 2 );

	$to = hexdec( $_1 ).".".hexdec( $_2 ).".".hexdec( $_3 ).".".hexdec( $_4 );
	return $to;
}

function hex_to_long( $from ) {
	$to = ip_to_long( hex_to_ip( $from ) );
	return $to;
}

function long_to_hex( $from ) {
	$to = ip_to_hex( long_to_ip( $from), "" );
	return $to;
}

$addr = isset( $_SERVER["REMOTE_ADDR"] ) ? $_SERVER["REMOTE_ADDR"] : "127.0.0.1";

?>
