<?php

declare(strict_types=1);

namespace hu\jmk\rtwi;

Class Request {
  const EMPTY = "";

  const AJAX = "ajax";

  const FORMAT = "format";
  const FORMAT_HTML = "html";
  const FORMAT_XML = "xml";
  const FORMATS = [self::FORMAT_HTML, self::FORMAT_XML];

  const HASH = "hash";

  const ID = "id";

  const MOD = "mod";
  const MOD_ADDTORRENT = "addtorrent";
  const MOD_GETFILE = "getfile";
  const MOD_LOGIN = "login";
  const MOD_SERVERINFO = "serverinfo";
  const MOD_TORRENT = "torrent";
  const MOD_TORRENTS = "torrents";
  const MODS = [self::MOD_ADDTORRENT, self::MOD_GETFILE, self::MOD_LOGIN, self::MOD_SERVERINFO, self::MOD_TORRENT, self::MOD_TORRENTS];

  const PAGE = "page";
  const PAGE_CHUNKS = "chunks";
  const PAGE_FILES = "files";
  const PAGE_INFO = "info";
  const PAGE_PEERS = "peers";
  const PAGE_TRACKERS = "trackers";
  const PAGE_TRANSFERS = "transfers";
  const PAGES = [self::PAGE_CHUNKS, self::PAGE_FILES, self::PAGE_INFO, self::PAGE_PEERS, self::PAGE_TRACKERS, self::PAGE_TRANSFERS];

  const PATH = "path";

  private bool $ajax;
  private string $format;
  private ?string $hash;
  private int $id;
  private string $mod;
  private string $page;
  private ?string $path;

  public function __construct($request) {
    $this->ajax = boolval($request[self::AJAX]);
    $this->format = in_array($request[self::FORMAT], self::FORMATS) ? $request[self::FORMAT] : self::FORMAT_HTML;
    $this->hash = !is_null($request[self::HASH]) ? $request[self::HASH] : null;
    $this->id = is_numeric($request[self::ID]) ? intval($request[self::ID]) : -1;
    $this->setMod($request[self::MOD]);
    $this->page = in_array($request[self::PAGE], self::PAGES) ? $request[self::PAGE] : self::PAGE_INFO;
    $this->path = !is_null($request[self::PATH]) ? $request[self::PATH] : null;
  }

  public function isAjax():bool {
    return $this->ajax;
  }

  public function getFormat():string {
    return $this->format;
  }

  public function hasHash():bool {
    return !is_null($this->hash);
  }

  public function getHash():string {
    return $this->hash;
  }

  public function hasId():bool {
    return $this->id != -1;
  }

  public function getId():int {
    return $this->id;
  }

  public function getMod():string {
    return $this->mod;
  }

  public function setMod(?string $mod):string {
    return $this->mod = in_array($mod, self::MODS) ? $mod : self::MOD_TORRENTS;
  }

  public function getPage():string {
    return $this->page;
  }

  public function hasPath():bool {
    return !is_null($this->path);
  }

  public function getPath():String {
    return $this->path;
  }
}
