<?php

class xmlrpc_handler {
	var $conntype;
	var $host;
	var $port;
	var $timeout;
	var $request;
	var $response;
	var $calls;
	var $mcalls;
	var $times;
	var $mtimes;
	var $user;
	var $password;

	function __construct( $address, $timeout ) {
		if ( preg_match( "|^unix://(.+)$|", $address, $match ) ) {
			$this->conntype = "socket";
			$this->host = $match[1];
			$this->port = 0;
			if ( ( $perms = @fileperms( $this->host ) ) === false ) {
				$this->conntype = "";
				$this->host = "";
			} else {
				if ( ( fileperms( $this->host ) & 0xC000 ) !== 0xC000 ) {
					$this->conntype = "";
					$this->host = "";
				} elseif ( !is_writable( $this->host ) ) {
					$this->conntype = "";
					$this->host = "";
				} else {
					$this->host = $match[0];
				}
			}
		} elseif ( preg_match( "<^(http|https)://(.*)$>", $address, $match ) ) {
			$this->conntype = "http";
			$this->host = $match[0];
			$this->port = 0;
		} elseif ( preg_match( "|^:(\d{1,5})$|", $address, $match ) ) {
			$this->conntype = "localport";
			$this->port = $match[1];
			settype( $this->port, "int" );
			if ( $this->port < 1 || $this->port > 65535 ) {
				$this->conntype = "";
				$this->host = "";
				$this->port = 0;
			} else {
				$this->host = "127.0.0.1";
			}
		} elseif ( preg_match( "|^(\d{1,3})\.(\d{1,3})\.(\d{1,3})\.(\d{1,3}):(\d{1,5})$|", $address, $match ) ) {
			$this->conntype = "port";
			$this->host = "{$match[1]}.{$match[2]}.{$match[3]}.{$match[4]}";
			$this->port = $match[5];
			settype( $this->port, "int" );
			if ( ip2long( $this->host ) === false ) {
				$this->conntype = "";
				$this->host = "";
				$this->port = 0;
			} elseif ( $this->host != long2ip( ip2long( $this->host ) ) ) {
				$this->conntype = "";
				$this->host = "";
				$this->port = 0;
			}
			if ( $this->port < 1 || $this->port > 65535 ) {
				$this->conntype = "";
				$this->host = "";
				$this->port = 0;
			}
		} else {
			$this->conntype = "";
			$this->host = "";
			$this->port = 0;
		}

		$this->timeout	= $timeout;
		$this->request	= null;
		$this->response	= null;
		$this->calls	= 0;
		$this->mcalls	= 0;
	}

	function set_type( &$value, $xmlrpc_type ) {
		switch ( $xmlrpc_type ) {
			case "base64" : {
				$value = (object)$value;
				$value->xmlrpc_type = $xmlrpc_type;
				break;
			}
			case "datetime" : {
				$value = (object)$value;
				$value->xmlrpc_type = $xmlrpc_type;
				$value->timestamp = strtotime( $value->scalar );
				$value->timestamp = $value->timestamp === false ? -1 : $value->timestamp;
				break;
			}
		}
	}

	private function decode_rec( $inode ) {
		$ntype = $inode->nodeName;
		$nvalue = $inode->nodeValue;
		switch ( $ntype ) {
			case "string" : {
				$response = $nvalue;
				break;
			}
			case "i4" :
			case "int" : {
				$response = (int)$nvalue;
				break;
			}
			case "struct" : {
				$mnode = $inode->firstChild;
				while ( $mnode != NULL ) {
					$nname = $mnode->firstChild->nodeValue;
					$response[$nname] = $this->decode_rec( $mnode->lastChild->firstChild );
					$mnode = $mnode->nextSibling;
				}
			}
			case "array" : {
				$vnode = $inode->firstChild->firstChild;
				while ( $vnode != NULL ) {
					$response[] = $this->decode_rec( $vnode->firstChild );
					$vnode = $vnode->nextSibling;
				}
			}
		}
		return $response;
	}

	private function decode( $str ) {
		$str = preg_replace( "%<(/{0,1})(i8|ex\.i8)>%", "<\\1string>", $str );
		$str = preg_replace( "/>\s*?</s", "><", $str );
		$xml = new DOMDocument( "1.0", "utf-8" );
		$xml->formatOutput = true;
		$xml->loadXML( $str );

		$root = $xml->firstChild;
		$root->nodeName;

		if ( $root->firstChild->nodeName == "fault" ) {
			$response[faultCode] = (int)$root->firstChild->firstChild->firstChild->firstChild->lastChild->firstChild->nodeValue;
			$response[faultString] = $root->firstChild->firstChild->firstChild->lastChild->lastChild->firstChild->nodeValue;
		} else {
			$vnode = $root->firstChild->firstChild->firstChild;
			$inode = $vnode->firstChild;
			$ntype = $inode->nodeName;
			$nvalue = $inode->nodeValue;
			switch ( $ntype ) {
				case "string" : {
					$response = $nvalue;
					break;
				}
				case "i4" :
				case "int" : {
					$response = (int)$nvalue;
					break;
				}
				case "struct" : {
					$mnode = $inode->firstChild;
					while ( $mnode != NULL ) {
						$nname = $mnode->firstChild->nodeValue;
						$response[$nname] = $this->decode_rec( $mnode->lastChild->firstChild );
						$mnode = $mnode->nextSibling;
					}
				}
				case "array" : {
					$vnode = $inode->firstChild->firstChild;
					while ( $vnode != NULL ) {
						$response[] = $this->decode_rec( $vnode->firstChild );
						$vnode = $vnode->nextSibling;
					}
				}
			}
		}

		return $response;
	}

	private function encode_request_rec( $method, $param, &$xml, $pnode ) {
		$vnode = $pnode->appendChild( $xml->createElement( "value" ) );
		switch ( gettype( $param ) ) {
			case "integer" : {
				$inode = $vnode->appendChild( $xml->createElement( "int", $param ) );
				break;
			}
			case "double" : {
				$inode = $vnode->appendChild( $xml->createElement( "double", $param ) );
				break;
			}
			case "string" : {
				$inode = $vnode->appendChild( $xml->createElement( "string", $param ) );
				break;
			}
			case "array" : {
				$assoc = false;
				foreach ( array_keys( $param ) as $key => $val ) {
					if ( !preg_match( "/^[0-9]*$/", $val ) ) {
						$assoc = true;
					}
				}
				if ( $assoc ) {
					$anode = $vnode->appendChild( $xml->createElement( "struct" ) );
					foreach ( $param as $key => $val ) {
						$mnode = $anode->appendChild( $xml->createElement( "member" ) );
						$nnode = $mnode->appendChild( $xml->createElement( "name", $key ) );
						$this->encode_request_rec( $method, $val, $xml, $mnode );
					}
				} else {
					$anode = $vnode->appendChild( $xml->createElement( "array" ) );
					$dnode = $anode->appendChild( $xml->createElement( "data" ) );
					foreach ( $param as $key => $val ) {
						$this->encode_request_rec( $method, $val, $xml, $dnode );
					}
				}
				break;
			}
			case "object" : {
				switch ( $param->xmlrpc_type ) {
					case "base64" : {
						$inode = $vnode->appendChild( $xml->createElement( "base64", base64_encode( $param->scalar ) ) );
						break;
					}
					case "datetime" : {
						$inode = $vnode->appendChild( $xml->createElement( "datetime", $param->timestamp ) );
						break;
					}
				}
				break;
			}
			default : {
				print "Bibi: ".gettype( $param );
				exit;
				break;
			}
		}
	}

	private function encode_request( $method, $params ) {
		$xml = new DOMDocument( "1.0", "utf-8" );
		$xml->formatOutput = false;

		$root = $xml->appendChild( $xml->createElement( "methodCall" ) );
		$mnode = $root->appendChild( $xml->createElement( "methodName", $method ) );
		
		$psnode = $root->appendChild( $xml->createElement( "params" ) );
		if ( is_array( $params ) ) {
			$assoc = false;
			foreach ( array_keys( $params ) as $key => $val ) {
				if ( !preg_match( "/^[0-9]*$/", $val ) ) {
					$assoc = true;
				}
			}
			if ( $assoc ) {
				$pnode = $psnode->appendChild( $xml->createElement( "param" ) );
				$vnode = $pnode->appendChild( $xml->createElement( "value" ) );
				$anode = $vnode->appendChild( $xml->createElement( "struct" ) );
				foreach ( $params as $key => $val ) {
					$mnode = $anode->appendChild( $xml->createElement( "member" ) );
					$nnode = $mnode->appendChild( $xml->createElement( "name", $key ) );
					$this->encode_request_rec( $method, $val, $xml, $mnode );
				}
			} else {
				foreach ( $params as $key => $val ) {
					$pnode = $psnode->appendChild( $xml->createElement( "param" ) );
					$this->encode_request_rec( $method, $val, $xml, $pnode );
				}
			}
		} else {
			$pnode = $psnode->appendChild( $xml->createElement( "param" ) );
			$this->encode_request_rec( $method, $params, $xml, $pnode );
		}

		return $xml->saveXML();
	}

	function getconntype() {
		return $this->conntype;
	}

	function setaccount( $user, $password ) {
		$this->user = $user;
		$this->password = $password;
	}

	function setmrequest( $methods, $params = array() ) {
		$this->request = array();
		foreach ( $methods as $methodkey => $methodval ) {
			$this->request[] = array( "methodName" => $methodval, "params" => $params );
		}
		$this->request = $this->encode_request( "system.multicall", array( $this->request ) );
	}

	function setumrequest( $methods, $params ) {
		$this->request = array();
		$num = count( $methods );
		for ( $i = 0; $i < $num; $i++ ) {
			$this->request[] = array( "methodName" => $methods[$i], "params" => $params[$i] );
		}
		$this->request = $this->encode_request( "system.multicall", array( $this->request ) );
	}

	function setrequest( $method, $attributes ) {
		$this->request = $this->encode_request( $method, $attributes );
	}

	function scgi_call() {
		$st = getmicrotime();

		$len = strlen( $this->request );
		$headers = "CONTENT_LENGTH\0{$len}\0";
		$headers .= "SCGI\01\0";
		$len = strlen( $headers );
		$out = "{$len}:{$headers},{$this->request}";

		$fp = fsockopen( $this->host, $this->port, $errno, $errstr, $this->timeout );
		if ( $fp ) {
			fwrite( $fp, $out );
			do {
				$line = fgets( $fp );
			} while ( trim( $line ) != "" );
			
			if ( ( $this->response = stream_get_contents( $fp ) ) !== false ) {
				$tt = getmicrotime();
				$this->calls++;
				$this->times = $this->times + $tt - $st;

				return true;
			} else {
				$tt = getmicrotime();
				$this->calls++;
				$this->times = $this->times + $tt - $st;

				return false;
			}
		} else {
			$tt = getmicrotime();
			$this->calls++;
			$this->times = $this->times + $tt - $st;

			return false;
		}
	}

	function gw_call() {
		$st = getmicrotime();

		$len = strlen( $this->request );
		$headers = "CONTENT_LENGTH\0{$len}\0";
		$headers .= "SCGI\01\0";
		$len = strlen( $headers );
		$out = "{$len}:{$headers},{$this->request}";

		$ch = curl_init( $this->host );
		//curl_setopt( $ch, CURLOPT_HEADER, true );
		curl_setopt( $ch, CURLOPT_RETURNTRANSFER, true );
		curl_setopt( $ch, CURLOPT_POST, true );
		curl_setopt( $ch, CURLOPT_POSTFIELDS, $this->request );
		curl_setopt( $ch, CURLOPT_USERPWD, "{$this->user}:{$this->password}" );
		$this->response = curl_exec( $ch ); 
		$tt = getmicrotime();
		$this->calls++;
		$this->times = $this->times + $tt - $st;

		return true;
	}

	function call(){
		switch ( $this->conntype ) {
			case "" : {
				return false;

				break;
			}
			case "http" : {
				return $this->gw_call();

				break;
			}
			case "port" :
			case "localport" :
			case "socket" : {
				return $this->scgi_call();

				break;
			}
			default : {
				return false;

				break;
			}
		}
	}

	function parse() {
		if ( ( $this->response = $this->decode( $this->response ) ) !== false ) {
			return true;
		} else {
			return false;
		}
	}

	function mfetch( $methods ) {
		$r = -1;
		$responses = array();
		foreach ( $methods as $methodkey => $methodval ) {
			if ( $methodval[1] == "." ) {
				$prefix = substr( $methodval, 0, 1 );
				$methodval = substr( $methodval, 5 );
				$methodval = "{$prefix}{$methodval}";
			} elseif ( strlen( $methodval ) > 6 && $methodval[6] == "." ) {
				$prefix = substr( $methodval, 0, 1 );
				$methodval = substr( $methodval, 7 );
				$methodval = "{$methodval}";
			} elseif ( $methodval == "view_list" ) {
			} elseif ( substr( $methodval, 0, 3 ) == "dht" ) {
			} else {
				$methodval = substr( $methodval, 4 );
			}
			$r++;

			if ( isset( $this->response[$r]["faultCode"] ) && isset( $this->response[$r]["faultString"] ) ) {
				print "(Error: {$response[$r]["faultCode"]} {$this->response[$r]["faultString"]})<br />\r\n";
			} else {
				if ( $methodval == "dht_statistics" ) {
					foreach ( $this->response[$r][0] as $dkey => $dval ) {
						$responses["{$methodval}_{$dkey}"] = $dval;
					}
				} else {
					$responses[$methodval] = $this->response[$r][0];
				}
			}
		}

		return $responses;
	}

	function fetch() {
		return $this->response;
	}

}

?>
