<?php

class xmlrpc_handler {
	var $socket;
	var $host;
	var $port;
	var $timeout;
	var $request;
	var $response;
	var $calls;
	var $mcalls;
	var $times;
	var $mtimes;

	function __construct( $xmlrpc_array ) {
		if ( isset( $xmlrpc_array["socket"] ) ) {
			$this->socket	= $xmlrpc_array["socket"];
		} else {
			$this->host		= $xmlrpc_array["host"];
			$this->port		= $xmlrpc_array["port"];
		}
		$this->timeout	= $xmlrpc_array["timeout"];
		$this->request	= null;
		$this->response	= null;
		$this->calls	= 0;
		$this->mcalls	= 0;
	}

	function setmrequest( $methods, $params = array() ) {
		$this->request = array();
		foreach ( $methods as $methodkey => $methodval ) {
			$this->request[] = array( "methodName" => $methodval, "params" => $params );
		}
		$this->request = xmlrpc_encode_request( "system.multicall", array( $this->request ) );
	}

	function setrequest( $method, $attributes ) {
		$this->request = xmlrpc_encode_request( $method, $attributes );
	}

	function call() {
		$st = getmicrotime();

		$len = strlen( $this->request );
		$headers = "CONTENT_LENGTH\0{$len}\0";
		$headers .= "SCGI\01\0";
		$len = strlen( $headers );
		$out = "{$len}:{$headers},{$this->request}";

		if ( isset( $this->socket ) ) {
			$fp = fsockopen( "unix://{$this->socket}", $this->port, $errno, $errstr, $this->timeout );
		} else {
			$fp = fsockopen( $this->host, $this->port, $errno, $errstr, $this->timeout );
		}
		if ( $fp ) {
			fwrite( $fp, $out );
			do {
				$line = fgets( $fp );
			} while ( trim( $line ) != "" );
			
			if ( ( $this->response = stream_get_contents( $fp ) ) !== false ) {
				$tt = getmicrotime();
				$this->calls++;
				$this->times = $this->times + $tt - $st;

				return true;
			} else {
				$tt = getmicrotime();
				$this->calls++;
				$this->times = $this->times + $tt - $st;

				return false;
			}
		} else {
			$tt = getmicrotime();
			$this->calls++;
			$this->times = $this->times + $tt - $st;

			return false;
		}
	}

	function parse() {
		$this->response = preg_replace( "/i8|ex\.i8/", "string", $this->response );
		if ( ( $this->response = xmlrpc_decode( $this->response ) ) !== false ) {
			return true;
		} else {
			return false;
		}
	}

	function mfetch( $methods ) {
		$r = -1;
		$responses = array();
//print_r( $this->response );
		foreach ( $methods as $methodkey => $methodval ) {
			if ( $methodval[1] == "." ) {
				$prefix = substr( $methodval, 0, 1 );
				$methodval = substr( $methodval, 5 );
				$methodval = "{$prefix}{$methodval}";
			} elseif ( strlen( $methodval ) > 6 && $methodval[6] == "." ) {
				$prefix = substr( $methodval, 0, 1 );
				$methodval = substr( $methodval, 7 );
				$methodval = "{$methodval}";
			} elseif ( $methodval == "view_list" ) {
			} elseif ( substr( $methodval, 0, 3 ) == "dht" ) {
			} else {
				$methodval = substr( $methodval, 4 );
			}
			$r++;

			if ( isset( $this->response[$r]["faultCode"] ) && isset( $this->response[$r]["faultString"] ) ) {
				print "(Error: {$response[$r]["faultCode"]} {$this->response[$r]["faultString"]})<br />\r\n";
			} else {
				if ( $methodval == "dht_statistics" ) {
					foreach ( $this->response[$r][0] as $dkey => $dval ) {
						$responses["{$methodval}_{$dkey}"] = $dval;
					}
				} else {
					$responses[$methodval] = $this->response[$r][0];
				}
			}
		}

		return $responses;
	}

	function fetch() {
		return $this->response;
	}

}

?>
