﻿<xsl:stylesheet version="1.1"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                lang="en">
 <xsl:output method="xml"
             indent="no"
             encoding="utf-8"
             doctype-public="-//W3C//DTD XHTML 1.0 Transitional//EN"
             doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd" />

 <xsl:template match="root">
  <html lang="en">
   <head>
    <meta http-equiv="content-type" content="text/html; charset=utf-8" />
    <meta http-equiv="content-language" content="en" />
    <meta http-equiv="cache-control" content="no-store, no-cache, must-revalidate, post-check=0, pre-check=0" />
    <meta http-equiv="pragma" content="no-cache" />
    <meta http-equiv="expires" content="thu, 1 jan 1970 00:00:00 gmt" />
    <meta http-equiv="imagetoolbar" content="no" />  
    <xsl:choose>
     <xsl:when test="/root/torrents/@refreshrate != 0">
      <meta http-equiv="refresh" content="{/root/torrents/@refreshrate}; url={curl}" />  
     </xsl:when>
    </xsl:choose>
    <meta name="author" content="{/root/labels/author}" />
    <meta name="description" content="{/root/labels/description}" />
    <meta name="doc-type" content="web page" />
    <meta name="rating" content="general" />
    <meta name="robots" content="all" />
    <link rel="stylesheet" type="text/css" href="themes/default_ajax/inc/style.css" />
    <script type="text/javascript" src="themes/default_ajax/inc/afunc.js"></script>
    <script type="text/javascript" src="themes/default_ajax/inc/hfunc.js"></script>
    <title><xsl:value-of select="/root/labels/title" /></title>
   </head>
   <body onload="toggle( '{/root/mod}_{/root/page}' );">
    <div id="top">
    </div>
    <div id="main">
     <div id="balh">
      <div id="fomenu">
       <ul>
        <li class="first"><a href="{/root/url}" title="Main">Main</a></li>
        <li><a href="?mod=loadtorrent" title="Load torrent">Load torrent</a></li>
        <li><a href="?mod=savetorrent" title="Save torrent">Save torrent</a></li>
       </ul>
      </div>
     </div>
     <div id="kozeph">
      <xsl:apply-templates select="err" />
      <xsl:apply-templates select="torrent" />
     </div>
     <div class="clr1"></div>
    </div>
   </body>
  </html>
 </xsl:template>

 <xsl:template match="err">
  <div id="err">
   <span title="Click to hide" onmouseover="this.style.cursor='pointer';" onclick="document.getElementById( 'err' ).style.display='none';">
    <xsl:value-of select="errmsg" />
   </span>
  </div>
 </xsl:template>

 <xsl:template match="loadtorrent">
  <form id="loadtorrent" name="loadtorrent" enctype="multipart/form-data" method="post" action="{/root/iurl}?mod=loadtorrent">
   <ul class="tuform">
    <li>
     <div class="tufleft">Open from:</div>
     <div class="tufright">
      <select name="tfmethod" title="Open from" onchange="if ( this.value == 'url' ) {{ document.getElementById( 'torrenturl' ).style.display=''; document.getElementById( 'torrentfile' ).style.display='none'; }} else {{ document.getElementById( 'torrenturl' ).style.display='none'; document.getElementById( 'torrentfile' ).style.display=''; }}">
       <option value="file">File upload</option>
       <option value="url">URL</option>
      </select>
     </div>
     <div class="clr"></div>
    </li>
    <li id="torrentfile">
     <div class="tufleft">Torrent file:</div>
     <div class="tufright">
      <input type="hidden" name="MAX_FILE_SIZE" value="1000000" />
      <input type="file" name="torrentfile" title="Torrent File" value="" />
	  <input type="checkbox" name="keeptorrentfile" title="Keep the .torrent file" />
	  <span>Keep the .torrent file</span>
     </div>
     <div class="clr"></div>
    </li>
    <li id="torrenturl">
     <div class="tufleft">Torrent URL:</div>
     <div class="tufright">
      <input type="text" name="torrenturl" title="Torrent url" value="" />
     </div>
     <div class="clr"></div>
    </li>
    <li class="formsend">
     <input class="inputok" type="submit" name="loadtorrent" title="Load torrent" value="Load torrent" />
    </li>
   </ul>
  </form>
 </xsl:template>

</xsl:stylesheet>
