= Installation guide =

 * Prerequisites
 * Installation
 * Troubleshooting

== Prerequisites ==

 * rTorrent 0.8.0
  * compiled with "--with-xmlrpc-c"
  * sigc++-2.0
 * XMLRPC-C >= 1.00 ( >= 1.07 recommended)
 * some webserver
  * php5, with the following extensions:
   * curl (when using an SCGI gateway)
   * xml
   * xsl (libxslt1.1)

== Installation ==

 * rTorrent side
  * Preparing the system
  * Installing XMLRPC-C
  * Installing libTorrent
  * Installing rTorrent
  * Setting up rTorrent
 * rTWi side
  * Installing rTWi
  * Adding users
  * GeoIP support (optional)

=== rTorrent side ===

==== Preparing the system ====

You'll need the following packages to install xmlrpc-c, libtorrent and rtorrent
 * make
 * pkg-config
 * sigc++-2.0-dev
 * libncurses-dev
 * libcurl-openssl-dev

==== Installing XMLRPC-C ====

To install xmlrpc, get the source from The XMLRPC-C page at http://sourceforge.net/project/showfiles.php?group_id=16847
In my case, i could only compile the 1.11.00 version (due to a known bug, you may try to configure with --disable-cplusplus, if the compiling stops with some syntax error)
Of course, you can try any version, over 1.07 (or any version over 1.00, but you'll get incorrect data for values bigger than 2^31^-1, since it does not support 64bit integers)

Follow the next steps:

cd /usr/src
wget http://dfn.dl.sourceforge.net/sourceforge/xmlrpc-c/xmlrpc-c-1.11.00.tgz
tar xvf xmlrpc-c-1.11.00.tgz
cd xmlrpc-c-1.11.00
./configure
make
make install


==== Installing libTorrent ====

To install libtorrent, follow the next steps:

mkdir /usr/src/libtorrent
wget http://libtorrent.rakshasa.no/downloads/libtorrent-0.12.0.tar.gz
tar xvf libtorrent-0.12.0.tar.gz
cd /usr/src/libtorrent-0.12.0
./configure
make
make install


==== Installing rTorrent ====

To install rtorrent, follow the next steps:

mkdir /usr/src/rtorrent
wget http://libtorrent.rakshasa.no/downloads/rtorrent-0.8.0.tar.gz
tar xvf rtorrent-0.8.0.tar.gz
cd /usr/src/rtorrent-0.8.0
./configure --with-xmlrpc-c
make
make install


==== Setting up rTorrent ====

If you don't have a .rtorrent.rc file, create one into your home directory.
You can find an example .rtorrent.rc] file on the rTorrent page at http://libtorrent.rakshasa.no/browser/trunk/rtorrent/doc/rtorrent.rc?rev=latest
Edit your .rtorrent.rc (create on into your home directory, if it's a fresh install):
 * set up how rtorrent should listen for connections (there are 3 ways to do this)
  * to use a unix socket, add the line ''scgi_local = ~/torrent/.socket/rpc.socket'' (this is the recommended way)
  * to listen for connections from localhost on port 12345 add the line ''scgi_port = :12345''
  * to listen for connections from a specific interface on port 12345 add the line ''scgi_port = 123.123.123.123:12345''
 * if you have more than one user, set a different scgi_port/scgi_local value in each user's .rtorrent.rc file
 * set your download directory ''directory = ~/torrent/''
 * absolute paths are always welcome, however rTWi should handle relative paths, like above (if it does not, submit a ticket
 * make sure, you have your session directory set and it exists, so rtorrent will remember your torrents after it's restarted ''session = ~/torrent/.session'' (be aware to set different session directories for the users)
 
Now, you can start rTorrent. On the bottom, you should see something like this:

(20:55:52) XMLRPC initialized with 356 functions.


=== rTWi side ===

==== Installing and setting up rTWi ====

Download the latest rTWi at https://rtwi.jmk.hu/downloads/rtwi-latest.tar.gz and extract it to some place where your webserver can see it.
Edit your configuration file (includes/rtwi.conf):
 * set the ''base'' variable to your rTWi installation's URL (without index file, and with a trailing slash) ''base = "http://example.com/"''
 * set the ''user_conf'' variable to the path of your user.conf file (it's always safe, to keep it outside your webroot)
 * if your want to rename your index.php and/or input.php you need to set the ''index'' and/or ''input'' variable(s)
 * If a value in the conf file contains any non-alphanumeric characters it needs to be enclosed in double-quotes (")

==== Adding users ====

Edit your users.conf file:
 * create a new section for every user ''[user1]'' (this will be your login name - this must be the *nix username)
 * set the address rTWi can connect to the user's rTorrent (there are 3 ways to do it)
  * if you're using a unix socket enter ''address = "!unix://~/torrent/.socket/rpc.socket"''
  * if you're using scgi_port enter ''address = "123.123.123.123:12345"'' (''address = ":12345"'' works for localhost)
  * if you're using an SCGI gateway enter ''address = "!http://example.com/RPC2"'' (also works when Basic HTTP Authentication is on for the URL)
 * enter ''pass = "1234567890abcdef1234567890abcdef12345678"'' where the right side is the sha1 hash of the choosen password for the user (you can generate the sha1 hash online at http://www.johnmaguire.us/tools/hashcalc/index.php)
 * if a value in the conf file contains any non-alphanumeric characters it needs to be enclosed in double-quotes (")
 * if you have more than one user, you have to repeat these steps for each one of them, so you'll get something like this:

[user1]
address =  "unix://~/torrent/.socket/rpc.socket"
pass =     "1234567890abcdef1234567890abcdef12345678"

[user2]
address =  "123.123.123.123:12345"
pass =     "1234567890abcdef1234567890abcdef12345678"

[user3]
address =  "http://example.com/RPC2"
pass =     "1234567890abcdef1234567890abcdef12345678"


==== GeoIP support (optional) ====

You need to install the GeoIP c library (http://www.maxmind.com/app/c), and the GeoIP PECL module (http://pecl.php.net/package/geoip)
You'll need the following packages to to add GeoIP support to rTWi
 * libgeoip-dev
 * php-pear
 * php5-dev

If you have the packages installed, type

pecl install geoip


After you finished, you might want to add "extension=geoip.so" to php.ini

== Troubleshooting ==

XMLRPC-C 1.11 compilation stops with some syntax error
 * Configure with --disable-cplusplus
 * Check the XMLRPC-C site at http://xmlrpc-c.sourceforge.net/ 

rTorrent compilation stops with an errer, which says, i have no libtorrent installed (No package 'libtorrent' found), but i'm sure, i do
 * Find your libtorrent.pc file (try /usr/local/lib/pkgconfig), and set the PKG_CONFIG_PATH environmental variable to it's path (export PKG_CONFIG_PATH=/usr/local/lib/pkgconfig)

rTorrent compilation stops with an error, which says, my libTorrent's version is an empty string (Requested 'libtorrent >= 0.11.8' but version of libtorrent is )
 * Upgrade you automake (you need 1.5 at least)

I can see the php code in the browser
 * Your php settings does not allows you to to have a php file named .html - change these settings, or rename the index.html to index.php, and set the $default_ext variable to "php" in rtwi's /includes/config.inc.php
 * Php modul is not loaded by the webserver, take a look at your webserver's manual, to find out, how to enable it

I get some php errors about XSL, or XSLT...
 * Install (or if it's installed, than enable) the xsl php extension

I get some php errors about XMLRPC-C...
 * Install (or if it's installed, than enable) the xmlrpc php extension

I've set my username and my password in the config.inc.php, but i cannot log in
 * Did you use the password? You should use the sha1 hash of the password (you can generate the sha1 hash online at http://www.johnmaguire.us/tools/hashcalc/index.php)
 * Enable cookies (or at least session cookies)

I get the "No connection" message in rTWi
 * Set the same port in your .rtorrent.rc file, at the scgi_port=, and in the rTWi's /includes/config.inc.php at your user's line
 * Check, if rTottent is listening on the port, you've set (netstat -na | grep 12345)
  It is
   * Check your firewall
   * Recheck the port set in rtwi's incudes/config.inc.php
  It is not
   * Recheck your .rtorrent.rc - it should have a line like this: scgi_port = 127.0.0.1:12345
   * Try to set the scgi port in runtime (Ctrl+X, then entre "scgi_port = 127.0.0.1:12345")
   * If rtorrent stops with an error, that says xmlrpc is not supported, configure xmlrpc-c with --with-xmlrpc-c, and recompile
