<?php

class xmlrpc_handler {
	var $conntype;
	var $host;
	var $port;
	var $timeout;
	var $request;
	var $response;
	var $calls;
	var $mcalls;
	var $times;
	var $mtimes;
	var $user;
	var $password;

	function __construct( $address, $timeout ) {
		if ( preg_match( "|^unix://(.+)$|", $address, $match ) ) {
			$this->conntype = "socket";
			$this->host = $match[1];
			$this->port = 0;
			if ( ( $perms = @fileperms( $this->host ) ) === false ) {
				$this->conntype = "";
				$this->host = "";
			} else {
				if ( ( fileperms( $this->host ) & 0xC000 ) !== 0xC000 ) {
					$this->conntype = "";
					$this->host = "";
				} elseif ( !is_writable( $this->host ) ) {
					$this->conntype = "";
					$this->host = "";
				} else {
					$this->host = $match[0];
				}
			}
		} elseif ( preg_match( "<^(http|https)://(.*)$>", $address, $match ) ) {
			$this->conntype = "http";
			$this->host = $match[0];
			$this->port = 0;
		} elseif ( preg_match( "|^:(\d{1,5})$|", $address, $match ) ) {
			$this->conntype = "localport";
			$this->port = $match[1];
			settype( $this->port, "int" );
			if ( $this->port < 1 || $this->port > 65535 ) {
				$this->conntype = "";
				$this->host = "";
				$this->port = 0;
			} else {
				$this->host = "127.0.0.1";
			}
		} elseif ( preg_match( "|^(\d{1,3})\.(\d{1,3})\.(\d{1,3})\.(\d{1,3}):(\d{1,5})$|", $address, $match ) ) {
			$this->conntype = "port";
			$this->host = "{$match[1]}.{$match[2]}.{$match[3]}.{$match[4]}";
			$this->port = $match[5];
			settype( $this->port, "int" );
			if ( ip2long( $this->host ) === false ) {
				$this->conntype = "";
				$this->host = "";
				$this->port = 0;
			} elseif ( $this->host != long2ip( ip2long( $this->host ) ) ) {
				$this->conntype = "";
				$this->host = "";
				$this->port = 0;
			}
			if ( $this->port < 1 || $this->port > 65535 ) {
				$this->conntype = "";
				$this->host = "";
				$this->port = 0;
			}
		} else {
			$this->conntype = "";
			$this->host = "";
			$this->port = 0;
		}

		$this->timeout	= $timeout;
		$this->request	= null;
		$this->response	= null;
		$this->calls	= 0;
		$this->mcalls	= 0;
	}

	function getconntype() {
		return $this->conntype;
	}

	function setaccount( $user, $password ) {
		$this->user = $user;
		$this->password = $password;
	}

	function setmrequest( $methods, $params = array() ) {
		$this->request = array();
		foreach ( $methods as $methodkey => $methodval ) {
			$this->request[] = array( "methodName" => $methodval, "params" => $params );
		}
		$this->request = xmlrpc_encode_request( "system.multicall", array( $this->request ) );
	}

	function setumrequest( $methods, $params ) {
		$this->request = array();
		$num = count( $methods );
		for ( $i = 0; $i < $num; $i++ ) {
			$this->request[] = array( "methodName" => $methods[$i], "params" => $params[$i] );
		}
		$this->request = xmlrpc_encode_request( "system.multicall", array( $this->request ) );
	}

	function setrequest( $method, $attributes ) {
		$this->request = xmlrpc_encode_request( $method, $attributes );
	}

	function scgi_call() {
		$st = getmicrotime();

		$len = strlen( $this->request );
		$headers = "CONTENT_LENGTH\0{$len}\0";
		$headers .= "SCGI\01\0";
		$len = strlen( $headers );
		$out = "{$len}:{$headers},{$this->request}";

		$fp = fsockopen( $this->host, $this->port, $errno, $errstr, $this->timeout );
		if ( $fp ) {
			fwrite( $fp, $out );
			do {
				$line = fgets( $fp );
			} while ( trim( $line ) != "" );
			
			if ( ( $this->response = stream_get_contents( $fp ) ) !== false ) {
				$tt = getmicrotime();
				$this->calls++;
				$this->times = $this->times + $tt - $st;

				return true;
			} else {
				$tt = getmicrotime();
				$this->calls++;
				$this->times = $this->times + $tt - $st;

				return false;
			}
		} else {
			$tt = getmicrotime();
			$this->calls++;
			$this->times = $this->times + $tt - $st;

			return false;
		}
	}

	function gw_call() {
		$st = getmicrotime();

		$len = strlen( $this->request );
		$headers = "CONTENT_LENGTH\0{$len}\0";
		$headers .= "SCGI\01\0";
		$len = strlen( $headers );
		$out = "{$len}:{$headers},{$this->request}";

		$ch = curl_init( $this->host );
		//curl_setopt( $ch, CURLOPT_HEADER, true );
		curl_setopt( $ch, CURLOPT_RETURNTRANSFER, true );
		curl_setopt( $ch, CURLOPT_POST, true );
		curl_setopt( $ch, CURLOPT_POSTFIELDS, $this->request );
		curl_setopt( $ch, CURLOPT_USERPWD, "{$this->user}:{$this->password}" );
		$this->response = curl_exec( $ch ); 
		$tt = getmicrotime();
		$this->calls++;
		$this->times = $this->times + $tt - $st;

		return true;
	}

	function call(){
		switch ( $this->conntype ) {
			case "" : {
				return false;

				break;
			}
			case "http" : {
				return $this->gw_call();

				break;
			}
			case "port" :
			case "localport" :
			case "socket" : {
				return $this->scgi_call();

				break;
			}
			default : {
				return false;

				break;
			}
		}
	}

	function parse() {
		$this->response = preg_replace( "/i8|ex\.i8/", "string", $this->response );
		if ( ( $this->response = xmlrpc_decode( $this->response ) ) !== false ) {
			return true;
		} else {
			return false;
		}
	}

	function mfetch( $methods ) {
		$r = -1;
		$responses = array();
//print_r( $this->response );
		foreach ( $methods as $methodkey => $methodval ) {
			if ( $methodval[1] == "." ) {
				$prefix = substr( $methodval, 0, 1 );
				$methodval = substr( $methodval, 5 );
				$methodval = "{$prefix}{$methodval}";
			} elseif ( strlen( $methodval ) > 6 && $methodval[6] == "." ) {
				$prefix = substr( $methodval, 0, 1 );
				$methodval = substr( $methodval, 7 );
				$methodval = "{$methodval}";
			} elseif ( $methodval == "view_list" ) {
			} elseif ( substr( $methodval, 0, 3 ) == "dht" ) {
			} else {
				$methodval = substr( $methodval, 4 );
			}
			$r++;

			if ( isset( $this->response[$r]["faultCode"] ) && isset( $this->response[$r]["faultString"] ) ) {
				print "(Error: {$response[$r]["faultCode"]} {$this->response[$r]["faultString"]})<br />\r\n";
			} else {
				if ( $methodval == "dht_statistics" ) {
					foreach ( $this->response[$r][0] as $dkey => $dval ) {
						$responses["{$methodval}_{$dkey}"] = $dval;
					}
				} else {
					$responses[$methodval] = $this->response[$r][0];
				}
			}
		}

		return $responses;
	}

	function fetch() {
		return $this->response;
	}

}

?>
