<?php

class bittorrent_handler {
	var $bt_data;
	var $bt_content;

	function __construct( $bt_data, $bt_content ) {
		$this->bt_data = $bt_data;
		$this->bt_content = $bt_content;
	}

	private function encode_string( $content ) {
		$len = strlen( $content );
		$ret = "{$len}:{$content}";
		return $ret;
	}

	private function encode_integer( $content ) {
		$ret = "i{$content}e";
		return $ret;
	}

	private function encode_list( $content ) {
		$ret = "l";
		foreach ( $content as $val ) {
			$ret .= $this->encode( $val );
		}
		$ret .= "e";
		return $ret;
	}

	private function encode_dictionary( $content ) {
		$ret = "d";
		$keys = array_keys( $content );
		sort( $keys );
		foreach ( $keys as $val ) {
			$value = $content[$val];
			$ret .= $this->encode_string( $val );
			$ret .= $this->encode( $value );
		}
		$ret .= "e";
		return $ret;
	}

	private function encode( $content ) {
		if ( is_array( $content ) && isset( $content["type"] ) && isset( $content["value"] ) ) {
			$value = $content["value"];
			switch ( $content["type"] ) {
				case "string" : {
					$ret =  $this->encode_string( $value );
					break;
				}
				case "integer" : {
					$ret = $this->encode_integer( $value );
					break;
				}
				case "list" : {
					$ret = $this->encode_list( $value );
					break;
				}
				case "dictionary" : {
					$ret = $this->encode_dictionary( $value );
					break;
				}
				default : {
					$ret = "XX";
					break;
				}
			}
		} else {
			$ret = "";
		}

		return $ret;
	}

	private function decode_list( $data ) {
		$len = strlen( $data );
		$i = 1;
		$value = array();
		$text = "l";
		for (;;) {
			if ( $i >= $len )
				return;
			if ( $data[$i] == "e" )
				break;
			$ret = $this->decode( substr( $data, $i ) );
			if ( !isset( $ret ) || !is_array( $ret ) )
				return;
			$value[] = $ret;
			$i += $ret["strlen"];
			$text .= $ret["string"];
		}
		$text .= "e";
		$ret = array( "type" => "list", "value" => $value, "strlen" => strlen( $text ), "string" => $text );

		return $ret;
	}

	private function decode_dictionary( $data ) {
		$len = strlen( $data );
		$i = 1;
		$value = array();
		$text = "d";
		for ( ; ; ) {
			if ( $i < $len ) {
				if ( $data[$i] == "e" ) {
					break;
				} else {
					$ret = $this->decode( substr( $data, $i ) );
					if ( isset( $ret ) && is_array( $ret ) && $ret["type"] == "string" ) {
						$subval = $ret["value"];
						$i += $ret["strlen"];
						$text .= $ret["string"];
						if ( $i < $len ) {
							$ret = $this->decode( substr( $data, $i ) );
							if ( isset( $ret ) && is_array( $ret ) ) {
								$value[$subval] = $ret;
								$i += $ret["strlen"];
								$text .= $ret["string"];
							}
						}
					}
				}
			}
		}
		$text .= "e";
		$ret = array( "type" => "dictionary", "value" => $value, "strlen" => strlen( $text ), "string" => $text );

		return $ret;
	}

	private function decode( $data ) {
		switch ( $data[0] ) {
			case "l" : {
				$ret = $this->decode_list( $data );
				break;
			}
			case "d" : {
				$ret = $this->decode_dictionary( $data );
				break;
			}
			default : {
				if ( preg_match( "/^(\d+):/", $data, $match ) ) {
					$valuelen = $match[1];
					$headlen = strlen( $valuelen ) + 1;
					$value = substr( $data, $headlen, $valuelen );
					$text = substr( $data, 0, $headlen + $valuelen );
					if ( strlen( $value ) == $valuelen ) {
						$ret = array( "type" => "string", "value" => $value, "strlen" => strlen( $text ), "string" => $text );
					} else {
						$ret = "";
					}
				} elseif ( preg_match( "/^i(\d+)e/", $data, $match ) ) {
					$value = $match[1];
					$text = "i{$value}e";
					if ( $value !== "-0" && ( $value[0] != "0" || strlen( $value ) == 1 ) ) {
						$ret = array( "type" => "integer", "value" => $value, "strlen" => strlen( $text ), "string" => $text );
					} else {
						$ret = "";
					}
				} else {
					$ret = "";
				}
				break;
			}
		}

		return $ret;
	}

	function decode_data() {
		$this->bt_content = $this->decode( $this->bt_data );
	}

	function encode_content() {
		$this->bt_data = $this->encode( $this->bt_content );
	}

	function fetch_data() {
		return $this->bt_data;
	}

	function fetch_content() {
		return $this->bt_content;
	}

}

?>
