<?php

namespace hu\jmk;

class AutoLoader {
  private static $basePaths;

  public static function register() {
    self::addBasePath(__DIR__ . "../../");
    spl_autoload_register(array(new self(), "autoload"));
  }

  public static function addBasePath($path) {
    if (is_null(self::$basePaths)) {
      self::$basePaths = array();
    }
    if (!array_search($path, self::$basePaths)) {
      self::$basePaths[] = $path;
    }
  }

  public static function autoload($className) {
    $fileName = self::processClassName($className);
    if (is_readable($fileName)) {
      require_once($fileName);
    } else {
      foreach (self::$basePaths as $basePath) {
        if (is_readable("${basePath}/${fileName}")) {
          require_once("${basePath}/${fileName}");
        }
      }
    }
  }

  private static function processClassName($className) {
    $className = ltrim($className, "\\");
    $fileName = "";
    $namespace = "";
    if ($lastNsPos = strrpos($className, "\\")) {
      $namespace = substr($className, 0, $lastNsPos);
      $className = substr($className, $lastNsPos + 1);
      $fileName = str_replace("\\", DIRECTORY_SEPARATOR, $namespace) . DIRECTORY_SEPARATOR;
    }
    return $fileName . str_replace("_", DIRECTORY_SEPARATOR, $className) . ".php";
  }
}

AutoLoader::register();
