﻿<xsl:stylesheet version="1.1"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                lang="en">
 <xsl:output method="xml"
             indent="no"
             encoding="utf-8"
             doctype-public="-//W3C//DTD XHTML 1.0 Transitional//EN"
             doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd" />

 <xsl:template match="root">
  <html xml:lang="{language}" lang="{language}">
   <head>
    <meta http-equiv="content-type" content="text/html; charset=utf-8" />
    <meta http-equiv="content-language" content="{language}" />
    <meta http-equiv="cache-control" content="no-store, no-cache, must-revalidate, post-check=0, pre-check=0" />
    <meta http-equiv="pragma" content="no-cache" />
    <meta http-equiv="expires" content="thu, 1 jan 1970 00:00:00 gmt" />
    <meta http-equiv="imagetoolbar" content="no" />  
    <xsl:choose>
     <xsl:when test="@refreshrate != 0">
      <meta http-equiv="refresh" content="{@refreshrate}; url={curl}" />  
     </xsl:when>
    </xsl:choose>
    <meta name="author" content="{labels/author}" />
    <meta name="description" content="{labels/description}" />
    <meta name="doc-type" content="web page" />
    <meta name="rating" content="general" />
    <meta name="robots" content="all" />
    <link rel="stylesheet" type="text/css" href="themes/default_ajax/inc/style.css" />
    <script type="text/javascript" src="themes/default_ajax/inc/afunc.js"></script>
    <script type="text/javascript" src="themes/default_ajax/inc/hfunc.js"></script>
    <title><xsl:value-of select="labels/title" /></title>
   </head>
   <body onload="toggle( '{mod}_{page}' );">
    <div id="top">
    </div>
    <div id="main">
     <div id="leftcol">
      <div id="mainmenu">
       <ul>
        <li class="first"><a href="{url}" title="{labels/torrents}"><xsl:value-of select="labels/torrents" /></a></li>
        <xsl:choose>
         <xsl:when test="mod = 'torrent'">
          <li class="submenu">
           <a href="?mod=torrent&amp;hash={hash}&amp;page=peers" title="{labels/peerlist}"><xsl:value-of select="labels/peerlist" /></a>
          </li>
          <li class="submenu">
           <a href="?mod=torrent&amp;hash={hash}&amp;page=info" title="{labels/info}"><xsl:value-of select="labels/info" /></a>
          </li>
          <li class="submenu">
           <a href="?mod=torrent&amp;hash={hash}&amp;page=files" title="{labels/filelist}"><xsl:value-of select="labels/filelist" /></a>
          </li>
          <li class="submenu">
           <a href="?mod=torrent&amp;hash={hash}&amp;page=trackers" title="{labels/trackerlist}"><xsl:value-of select="labels/trackerlist" /></a>
          </li>
          <li class="submenu notshown">
           <a href="?mod=torrent&amp;hash={hash}&amp;page=chunks" title="{labels/chunksseen}"><xsl:value-of select="labels/chunksseen" /></a>
          </li>
          <li class="submenu notshown">
           <a href="?mod=torrent&amp;hash={hash}&amp;page=transfers" title="{labels/transferlist}"><xsl:value-of select="labels/transferlist" /></a>
          </li>
         </xsl:when>
        </xsl:choose>
        <li><a href="?mod=addtorrent" title="{labels/addtorrent}"><xsl:value-of select="labels/addtorrent" /></a></li>
        <li><a href="?mod=serverinfo" title="{labels/serverinfo}"><xsl:value-of select="labels/serverinfo" /></a></li>
        <li><a href="{iurl}?mod=logout" title="{labels/logout}"><xsl:value-of select="labels/logout" /></a></li>
       </ul>
      </div>
     </div>
     <div id="maincol">
      <xsl:apply-templates select="err" />
      <xsl:apply-templates select="addtorrent" />
      <xsl:apply-templates select="torrents" />
     </div>
     <div class="clr1"></div>
    </div>
    <div id="footer">
     <span><a href="http://projects.cyla.homeip.net/rtwi/" title="{labels/homepage}"><xsl:value-of select="labels/homepage" /></a></span>
    </div>
   </body>
  </html>
 </xsl:template>

 <xsl:template match="err">
  <div id="err" title="{/root/labels/clicktohide}" onmouseover="this.style.cursor='pointer';" onclick="this.parentNode.removeChild( this );">
   <xsl:apply-templates select="errmsg" />
  </div>
 </xsl:template>
 
 <xsl:template match="errmsg">
  <div>
   <xsl:value-of select="msg" />
  </div>
 </xsl:template>


 <xsl:template match="addtorrent">
  <div class="spacer">
   <xsl:apply-templates select="languages" />
  </div>
  <form id="addtorrent" name="addtorrent" enctype="multipart/form-data" method="post" action="{/root/iurl}?mod=addtorrent">
   <ul class="tuform">
    <li>
     <div class="tufleft"><xsl:value-of select="/root/labels/openfrom" />:</div>
     <div class="tufright">
      <select name="tfmethod" title="{/root/labels/openfrom}" onchange="if ( this.value == 'url' ) {{ document.getElementById( 'torrenturl' ).style.display=''; document.getElementById( 'torrentfile' ).style.display='none'; }} else {{ document.getElementById( 'torrenturl' ).style.display='none'; document.getElementById( 'torrentfile' ).style.display=''; }}">
       <option value="file"><xsl:value-of select="/root/labels/fileupload" /></option>
       <option value="url"><xsl:value-of select="/root/labels/url" /></option>
      </select>
     </div>
     <div class="clr"></div>
    </li>
    <li id="torrentfile">
     <div class="tufleft"><xsl:value-of select="/root/labels/torrentfile" />:</div>
     <div class="tufright">
      <input type="hidden" name="MAX_FILE_SIZE" value="1000000" />
      <input type="file" name="torrentfile" title="{/root/labels/torrentfile}" value="" />
     </div>
     <div class="clr"></div>
    </li>
    <li id="torrenturl">
     <div class="tufleft"><xsl:value-of select="/root/labels/torrenturl" />:</div>
     <div class="tufright">
      <input type="text" name="torrenturl" title="{/root/labels/torrenturl}" value="" />
     </div>
     <div class="clr"></div>
    </li>
    <li>
     <div class="tufleft"><xsl:value-of select="/root/labels/starttorrent" />:</div>
     <div class="tufright">
      <input type="checkbox" name="torrentstart" title="{/root/labels/starttorrentafteradded}" value="start" checked="checked" />
     </div>
     <div class="clr"></div>
    </li>
    <li>
     <div class="tufleft"><xsl:value-of select="/root/labels/downloadto" />:</div>
     <div class="tufright">
      <input type="hidden" name="dlpath" value="{@path}" />
      <ul class="tufupload">
       <li onmouseover="this.style.background='#eeeeee';" onmouseout="this.style.background='';">
        <div class="tufpath">
         <a href="?mod=addtorrent&amp;path={@ppath}">..</a>
        </div>
        <div class="tufspace">
         <xsl:value-of select="@freespace_value" />
         <xsl:text> </xsl:text>
         <xsl:value-of select="@freespace_suffix" />
        </div>
        <div class="clr"></div>
       </li>
       <xsl:apply-templates select="dlpath" />
      </ul>
     </div>
     <div class="clr"></div>
    </li>
    <li class="formsend">
     <input class="inputok" type="submit" name="addtorrent" title="{/root/labels/addtorrent}" value="{/root/labels/addtorrent}" />
    </li>
   </ul>
  </form>
 </xsl:template>

 <xsl:template match="torrents">
  <ul>
   <li class="tline first">
    <xsl:apply-templates select="viewtypes" />
    <xsl:apply-templates select="refreshrates" />
    <xsl:apply-templates select="languages" />
    <xsl:choose>
     <xsl:when test="/root/mod = ''">
      <form id="doonalltorrentform" name="doonalltorrentform" method="post" action="{/root/iurl}?mod=doonalltorrent">
       <select class="whiteselect" name="task" title="{/root/labels/selecttask}" onchange="window.location='{/root/iurl}?mod=doonalltorrent&amp;task='+this.value;">
        <option value="select" title="{/root/labels/selecttask}" selected="selected"><xsl:value-of select="/root/labels/selecttask" /></option>
        <option value="start" title="{/root/labels/startall}"><xsl:value-of select="/root/labels/startall" /></option>
        <option value="stop" title="{/root/labels/stopall}"><xsl:value-of select="/root/labels/stopall" /></option>
        <option value="open" title="{/root/labels/openall}"><xsl:value-of select="/root/labels/openall" /></option>
        <option value="close" title="{/root/labels/closeall}"><xsl:value-of select="/root/labels/closeall" /></option>
        <option value="checkhash" title="{/root/labels/checkall}"><xsl:value-of select="/root/labels/checkall" /></option>
        <option value="remove" title="{/root/labels/removeall}"><xsl:value-of select="/root/labels/removeall" /></option>
       </select>
       <noscript>
        <input class="submit" id="doatsubmit" type="submit" name="doatsubmit" title="{/root/labels/ok}" value="{/root/labels/ok}" />
       </noscript>
      </form>
     </xsl:when>
    </xsl:choose>
    <div class="clr"></div>
   </li>
   <xsl:apply-templates select="torrent">
    <xsl:sort select="d_name" lang="utf-8" data-type="text" order="ascending" />
   </xsl:apply-templates>
   <xsl:apply-templates select="torrent_info_root" />
   <xsl:apply-templates select="torrent_files_root" />
   <xsl:apply-templates select="torrent_peers_root" />
   <xsl:apply-templates select="torrent_trackers_root" />
   <xsl:apply-templates select="server_info" />
   <li class="tline last">
    <xsl:choose>
     <xsl:when test="/root/allow_throttle = 'true'">
      <div class="tthrottle" onmouseover="this.style.cursor='pointer';" onclick="toggle( '_info_restore' );">
       <form id="changethrottleform" name="changethrottleform" method="post" action="{/root/iurl}?mod=changethrottle">
        <span title="{/root/labels/clicktochange}">
         <xsl:text>[</xsl:text>
         <xsl:value-of select="/root/labels/throttle" />
         <xsl:text> </xsl:text>
        </span>
        <span title="{/root/labels/uploadlimit}">
         <span id="throttleup" style="display: none;"><xsl:value-of select="upload_rate/@value" /></span>
         <input type="text" id="throttleupinput" name="upspeed" value="{upload_rate/@value}" />
         <xsl:text> KB</xsl:text>
        </span>
        <xsl:text> / </xsl:text>
        <span title="{/root/labels/downloadlimit}">
         <span id="throttledown" style="display: none;"><xsl:value-of select="download_rate/@value" /></span>
         <input type="text" id="throttledowninput" name="downspeed" value="{download_rate/@value}" />
         <xsl:text> KB</xsl:text>
        </span>
        <input class="submit" id="tsubmit" type="submit" name="tsubmit" title="{/root/labels/ok}" value="{/root/labels/ok}" />
        <xsl:text>]</xsl:text>
       </form>
      </div>
     </xsl:when>
     <xsl:otherwise>
      <div class="tthrottle">
        <span>
         <xsl:text>[</xsl:text>
         <xsl:value-of select="/root/labels/throttle" />
         <xsl:text> </xsl:text>
        </span>
       <span title="{/root/labels/uploadlimit}"><xsl:value-of select="upload_rate/@value" /> KB</span>
       <xsl:text> / </xsl:text>
       <span title="{/root/labels/downloadlimit}"><xsl:value-of select="download_rate/@value" /> KB</span>
       <xsl:text>]</xsl:text>
      </div>
     </xsl:otherwise>
    </xsl:choose>
    <div class="trates_total">
     <xsl:text>[</xsl:text>
     <xsl:value-of select="/root/labels/rate" />
     <xsl:text> </xsl:text>
     <span title="{/root/labels/uploadspeed}">
      <xsl:value-of select="bytes_up/@value" />
      <xsl:text> </xsl:text>
      <xsl:value-of select="bytes_up/@suffix" />
     </span>
     <xsl:text> / </xsl:text>
     <span title="{/root/labels/downloadspeed}">
      <xsl:value-of select="bytes_down/@value" />
      <xsl:text> </xsl:text>
      <xsl:value-of select="bytes_down/@suffix" />
     </span>
     <xsl:text>]</xsl:text>
    </div>
    <div class="clr"></div>
   </li>
  </ul>
 </xsl:template>

 <xsl:template match="viewtypes">
  <form id="changeviewform" name="changeviewform" method="post" action="{/root/iurl}?mod=changeview">
   <xsl:text>[</xsl:text>
   <xsl:value-of select="/root/labels/view" />
   <xsl:text>: </xsl:text>
   <select class="whiteselect" name="viewtype" title="{/root/labels/selectviewtype}" onchange="window.location='{/root/iurl}?mod=changeview&amp;viewtype='+this.value;">
    <xsl:apply-templates select="viewtype" />
   </select>
   <noscript>
    <input class="submit" id="vtsubmit" type="submit" name="vtsubmit" title="{/root/labels/ok}" value="{/root/labels/ok}" />
   </noscript>
   <xsl:text>]</xsl:text>
  </form>
 </xsl:template>

 <xsl:template match="viewtype">
  <xsl:choose>
   <xsl:when test="/root/@viewtype = @value">
    <option value="{@value}" title="{@title}" selected="selected"><xsl:value-of select="@title" /></option>
   </xsl:when>
   <xsl:otherwise>
    <option value="{@value}" title="{@title}"><xsl:value-of select="@title" /></option>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>

 <xsl:template match="refreshrates">
  <form id="changerefreshform" name="changerefreshform" method="post" action="{/root/iurl}?mod=changerefresh">
   <xsl:text>[</xsl:text>
   <xsl:value-of select="/root/labels/refresh" />
   <xsl:text>: </xsl:text>
   <select class="whiteselect" name="refreshrate" title="{/root/labels/selectrefreshrate}" onchange="window.location='{/root/iurl}?mod=changerefresh&amp;refreshrate='+this.value;">
    <xsl:apply-templates select="refreshrate" />
   </select>
   <noscript>
    <input class="submit" id="rrsubmit" type="submit" name="rrsubmit" title="{/root/labels/ok}" value="{/root/labels/ok}" />
   </noscript>
   <xsl:text>]</xsl:text>
  </form>
 </xsl:template>

 <xsl:template match="refreshrate">
  <xsl:choose>
   <xsl:when test="/root/@refreshrate = @value">
    <option value="{@value}" title="{@title}" selected="selected"><xsl:value-of select="@title" /></option>
   </xsl:when>
   <xsl:otherwise>
    <option value="{@value}" title="{@title}"><xsl:value-of select="@title" /></option>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>

 <xsl:template match="languages">
  <form id="changelanguageform" name="changelanguageform" method="post" action="{/root/iurl}?mod=changelanguage">
   <xsl:text>[</xsl:text>
   <xsl:value-of select="/root/labels/language" />
   <xsl:text>: </xsl:text>
   <select class="whiteselect" name="language" title="{/root/labels/selectlanguage}" onchange="window.location='{/root/iurl}?mod=changelanguage&amp;language='+this.value;">
    <xsl:apply-templates select="language" />
   </select>
   <noscript>
    <input class="submit" id="lsubmit" type="submit" name="lsubmit" title="{/root/labels/ok}" value="{/root/labels/ok}" />
   </noscript>
   <xsl:text>]</xsl:text>
  </form>
 </xsl:template>

 <xsl:template match="language">
  <xsl:choose>
   <xsl:when test="/root/@language = @value">
    <option value="{@value}" title="{@title}" selected="selected"><xsl:value-of select="@title" /></option>
   </xsl:when>
   <xsl:otherwise>
    <option value="{@value}" title="{@title}"><xsl:value-of select="@title" /></option>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>

 <xsl:template match="torrent">
  <li class="tline">
   <div class="ticon">
    <xsl:choose>
     <xsl:when test="d_active != 0">
      <img class="icon" src="themes/default_ajax/pics/{d_connection_current}ing.png" alt="{d_connection_current}" title="{d_connection_current/@value} {/root/labels/sincepre} {d_state_changed/@value} {/root/labels/sincepost}" />
     </xsl:when>
     <xsl:when test="d_hashing != 0">
      <img class="icon" src="themes/default_ajax/pics/hashing.png" alt="{/root/labels/hashing}" title="{/root/labels/hashingsince} {d_state_changed/@value}" />
     </xsl:when>
     <xsl:when test="d_complete != 0">
      <xsl:choose>
       <xsl:when test="d_open != 0">
        <img class="icon" src="themes/default_ajax/pics/finished.png" alt="{/root/labels/finished}" title="{/root/labels/finishedsince} {d_state_changed/@value}" />
       </xsl:when>
       <xsl:otherwise>
        <img class="icon" src="themes/default_ajax/pics/finished_c.png" alt="{/root/labels/finished}" title="{/root/labels/finishedsince} {d_state_changed/@value}" />
       </xsl:otherwise>
      </xsl:choose>
     </xsl:when>
     <xsl:when test="d_open != 0">
      <img class="icon" src="themes/default_ajax/pics/stopped.png" alt="{/root/labels/stopped}" title="{/root/labels/stoppedsince} {d_state_changed/@value}" />
     </xsl:when>
     <xsl:otherwise>
      <img class="icon" src="themes/default_ajax/pics/closed.png" alt="{/root/labels/closed}" title="{/root/labels/closedsince} {d_state_changed/@value}" />
     </xsl:otherwise>
    </xsl:choose>
   </div>
   <div class="tname">
    <xsl:choose>
     <xsl:when test="/root/allow_ajax = 'true'">
      <a href="?mod=torrent&amp;hash={d_hash}" title="{/root/labels/details}" onclick="if ( document.getElementById( 'torrent_{d_hash}' ).style.display == '' ) {{ document.getElementById( 'torrent_{d_hash}' ).style.display = 'none' }} else {{ document.getElementById( 'torrent_{d_hash}' ).style.display = ''}} return false;"><xsl:value-of select="d_name" /></a>
     </xsl:when>
     <xsl:otherwise>
      <a href="?mod=torrent&amp;hash={d_hash}" title="{/root/labels/details}"><xsl:value-of select="d_name" /></a>
     </xsl:otherwise>
    </xsl:choose>
   </div>
   <div class="tops">
    <xsl:choose>
     <xsl:when test="d_hashing != 0">
      <xsl:value-of select="d_hashing/@value" />
     </xsl:when>
     <xsl:otherwise>
      <a href="{/root/iurl}?mod=torrentcheckhash&amp;hash={d_hash}" title="{/root/labels/checkhash}"><xsl:value-of select="/root/labels/checkhash" /></a>
     </xsl:otherwise>
    </xsl:choose>
    <xsl:choose>
     <xsl:when test="d_active != 0">
      <a href="{/root/iurl}?mod=torrentstop&amp;hash={d_hash}" title="{/root/labels/stop}"><xsl:value-of select="/root/labels/stop" /></a>
     </xsl:when>
     <xsl:otherwise>
      <xsl:choose>
       <xsl:when test="d_hashing != 0">
        <a href="{/root/iurl}?mod=torrentstop&amp;hash={d_hash}" title="{/root/labels/stop}"><xsl:value-of select="/root/labels/stop" /></a>
       </xsl:when>
       <xsl:otherwise>
        <a href="{/root/iurl}?mod=torrentstart&amp;hash={d_hash}" title="{/root/labels/start}"><xsl:value-of select="/root/labels/start" /></a>
       </xsl:otherwise>
      </xsl:choose>
     </xsl:otherwise>
    </xsl:choose>
    <xsl:choose>
     <xsl:when test="d_open = 0">
      <a href="{/root/iurl}?mod=torrentopen&amp;hash={d_hash}" title="{/root/labels/open}"><xsl:value-of select="/root/labels/open" /></a>
     </xsl:when>
     <xsl:otherwise>
      <a href="{/root/iurl}?mod=torrentclose&amp;hash={d_hash}" title="{/root/labels/close}"><xsl:value-of select="/root/labels/close" /></a>
     </xsl:otherwise>
    </xsl:choose>
    <a href="{/root/iurl}?mod=torrentremove&amp;hash={d_hash}" title="{/root/labels/remove}" onclick="var answer = confirm( '{/root/labels/areyousure}' ); if ( !answer ) return false;"><xsl:value-of select="/root/labels/remove" /></a>
    <xsl:choose>
     <xsl:when test="/root/allow_erase = 'true'">
      <a href="{/root/iurl}?mod=torrenterase&amp;hash={d_hash}" title="{/root/labels/erase}" onclick="var answer = confirm( '{/root/labels/areyousureerase}\n{d_base_path}\n{/root/labels/alldatawillbedestroyed}' ); if ( !answer ) return false;"><xsl:value-of select="/root/labels/erase" /></a>
     </xsl:when>
    </xsl:choose>
   </div>
   <div class="clr"></div>
   <div class="tbytes">
    <xsl:choose>
     <xsl:when test="d_complete = 1">
      <span title="{/root/labels/downloadfinished}"><xsl:value-of select="/root/labels/done" /> </span>
     </xsl:when>
     <xsl:otherwise>
      <span title="{/root/labels/downloadeddata}">
       <xsl:value-of select="d_bytes_done/@value" />
       <xsl:text> </xsl:text>
       <xsl:value-of select="d_bytes_done/@suffix" />
      </span>
      <xsl:text> / </xsl:text>
     </xsl:otherwise>
    </xsl:choose>
    <span title="{/root/labels/torrentsize}">
     <xsl:value-of select="d_size_bytes/@value" />
     <xsl:text> </xsl:text>
     <xsl:value-of select="d_size_bytes/@suffix" />
    </span>
   </div>
   <div class="trates">
    <xsl:value-of select="/root/labels/rate" />
    <xsl:text>: </xsl:text>
    <span title="{/root/labels/uploadspeed}">
     <xsl:value-of select="d_up_rate/@value" />
     <xsl:text> </xsl:text>
     <xsl:value-of select="d_up_rate/@suffix" />
    </span>
    <xsl:text> / </xsl:text>
    <span title="{/root/labels/downloadspeed}">
     <xsl:value-of select="d_down_rate/@value" />
     <xsl:text> </xsl:text>
     <xsl:value-of select="d_down_rate/@suffix" />
    </span>
   </div>
   <div class="tupbytes">
    <span><xsl:value-of select="/root/labels/uploaded" />: </span>
    <span title="{/root/labels/uploadeddata}">
     <xsl:value-of select="d_up_total/@value" />
     <xsl:text> </xsl:text>
     <xsl:value-of select="d_up_total/@suffix" />
    </span>
   </div>
   <xsl:choose>
    <xsl:when test="d_percentage != 1">
     <xsl:choose>
      <xsl:when test="d_hashing != 0">
       <div class="tpercentage">
        <span title="{d_hpercentage/@value} {/root/labels/percenthashed}">
         <xsl:text>[</xsl:text>
         <xsl:value-of select="d_hpercentage/@value" />
         <xsl:text> %]</xsl:text>
        </span>
       </div>
       <div class="tpercentage">
        <span title="{d_percentage/@value} {/root/labels/percentcompleted}">
         <xsl:text>[</xsl:text>
         <xsl:value-of select="d_percentage/@value" />
         <xsl:text> %]</xsl:text>
        </span>
       </div>
      </xsl:when>
      <xsl:otherwise>
       <div class="tpercentage">
        <span title="{d_percentage/@value} {/root/labels/percentcompleted}">
         <xsl:text>[</xsl:text>
         <xsl:value-of select="d_percentage/@value" />
         <xsl:text> %]</xsl:text>
        </span>
       </div>
      </xsl:otherwise>
     </xsl:choose>
     <xsl:choose>
      <xsl:when test="d_estimated_time != ''">
       <div class="testimate">
        <span title="{/root/labels/estimatedtimeremaining}">
         <xsl:value-of select="d_estimated_time/@value" />
        </span>
       </div>
      </xsl:when>
     </xsl:choose>
    </xsl:when>
   </xsl:choose>
   <div class="tratio">
    <xsl:text>[</xsl:text>
    <xsl:choose>
     <xsl:when test="d_tied_to_file != ''">
      <span title="{/root/labels/tiedtofile}">T</span>
     </xsl:when>
    </xsl:choose>
    <xsl:choose>
     <xsl:when test="d_ignore_commands != 0">
      <span title="{/root/labels/ignoringcommands}">I</span>
     </xsl:when>
    </xsl:choose>
    <span title="{/root/labels/ratio}">
     <xsl:text> R: </xsl:text>
     <xsl:value-of select="d_ratio/@value" />
    </span>
    <xsl:text>]</xsl:text>
   </div>
   <div class="tpriority">
    <form class="changepriorityform" name="changepriorityform_{d_hash}" method="post" action="{/root/iurl}?mod=changepriority&amp;hash={d_hash}">
     <select class="whiteselect" name="priority" title="{/root/labels/selectpriority}" onchange="window.location='{/root/iurl}?mod=changepriority&amp;hash={d_hash}&amp;priority='+this.value;">
      <xsl:choose>
       <xsl:when test="d_priority = 0">
        <option value="0" title="{/root/labels/off}" selected="selected"><xsl:value-of select="/root/labels/off" /></option>
        <option value="1" title="{/root/labels/low}"><xsl:value-of select="/root/labels/low" /></option>
        <option value="2" title="{/root/labels/normal}"><xsl:value-of select="/root/labels/normal" /></option>
        <option value="3" title="{/root/labels/high}"><xsl:value-of select="/root/labels/high" /></option>
       </xsl:when>
       <xsl:when test="d_priority = 1">
        <option value="0" title="{/root/labels/off}"><xsl:value-of select="/root/labels/off" /></option>
        <option value="1" title="{/root/labels/low}" selected="selected"><xsl:value-of select="/root/labels/low" /></option>
        <option value="2" title="{/root/labels/normal}"><xsl:value-of select="/root/labels/normal" /></option>
        <option value="3" title="{/root/labels/high}"><xsl:value-of select="/root/labels/high" /></option>
       </xsl:when>
       <xsl:when test="d_priority = 3">
        <option value="0" title="{/root/labels/off}"><xsl:value-of select="/root/labels/off" /></option>
        <option value="1" title="{/root/labels/low}"><xsl:value-of select="/root/labels/low" /></option>
        <option value="2" title="{/root/labels/normal}"><xsl:value-of select="/root/labels/normal" /></option>
        <option value="3" title="{/root/labels/high}" selected="selected"><xsl:value-of select="/root/labels/high" /></option>
       </xsl:when>
       <xsl:otherwise>
        <option value="0" title="{/root/labels/off}"><xsl:value-of select="/root/labels/off" /></option>
        <option value="1" title="{/root/labels/low}"><xsl:value-of select="/root/labels/low" /></option>
        <option value="2" title="{/root/labels/normal}" selected="selected"><xsl:value-of select="/root/labels/normal" /></option>
        <option value="3" title="{/root/labels/high}"><xsl:value-of select="/root/labels/high" /></option>
       </xsl:otherwise>
      </xsl:choose>
     </select>
     <noscript>
      <input class="submit" type="submit" name="submit" value="{/root/labels/ok}" title="{/root/labels/ok}" />
     </noscript>
    </form>
   </div>
   <div class="clr"></div>
   <div class="tmessage">
    <span><xsl:value-of select="/root/labels/message" />: <xsl:value-of select="d_message" /></span>
   </div>
   <div class="clr"></div>
   <xsl:choose>
    <xsl:when test="/root/allow_ajax = 'true'">
     <div class="tcontainer" id="torrent_{d_hash}" style="display: none;">
      <a class="subpage" href="?mod=torrent&amp;hash={d_hash}&amp;page=peers" title="{/root/labels/peerlist}" onclick="loadcontent( '{d_hash}', 'peers' ); return false;"><xsl:value-of select="/root/labels/peerlist" /></a>
      <a class="subpage" href="?mod=torrent&amp;hash={d_hash}&amp;page=info" title="{/root/labels/info}" onclick="loadcontent( '{d_hash}', 'info' ); return false;"><xsl:value-of select="/root/labels/info" /></a>
      <a class="subpage" href="?mod=torrent&amp;hash={d_hash}&amp;page=files" title="{/root/labels/filelist}" onclick="loadcontent( '{d_hash}', 'files' ); return false;"><xsl:value-of select="/root/labels/filelist" /></a>
      <a class="subpage" href="?mod=torrent&amp;hash={d_hash}&amp;page=trackers" title="{/root/labels/trackerlist}" onclick="loadcontent( '{d_hash}', 'trackers' ); return false;"><xsl:value-of select="/root/labels/trackerlist" /></a>
      <div class="clr"></div>
      <div class="tcontent" id="torrent_{d_hash}_content"></div>
     </div>
    </xsl:when>
   </xsl:choose>
   <div class="clr"></div>
  </li>
 </xsl:template>

 <xsl:template match="torrent_info_root">
  <xsl:apply-templates select="torrent_info" />
 </xsl:template>

 <xsl:template match="torrent_info">
  <li class="line spacer">
   <div class="infoleft">
    <xsl:value-of select="/root/labels/name" />
   </div>
   <div class="inforight">
    <xsl:value-of select="d_name" />
   </div>
   <div class="clr"></div>
  </li>
  <li class="line">
   <div class="infoleft">
    <xsl:value-of select="/root/labels/infohash" />
   </div>
   <div class="inforight">
    <xsl:value-of select="d_hash" />
   </div>
   <div class="clr"></div>
  </li>
  <li class="line">
   <div class="infoleft">
    <xsl:value-of select="/root/labels/localid" />
   </div>
   <div class="inforight">
    <xsl:value-of select="d_local_id" />
   </div>
   <div class="clr"></div>
  </li>
  <li class="line spacer">
   <div class="infoleft">
    <xsl:value-of select="/root/labels/localidhtml" />
   </div>
   <div class="inforight">
    <xsl:value-of select="d_local_id_html" />
   </div>
   <div class="clr"></div>
  </li>
  <li class="line">
   <div class="infoleft">
    <xsl:value-of select="/root/labels/directory" />
   </div>
   <div class="inforight">
    <xsl:value-of select="d_directory/@value" />
   </div>
   <div class="clr"></div>
  </li>
  <li class="line">
   <div class="infoleft">
    <xsl:value-of select="/root/labels/tiedtofile" />
   </div>
   <div class="inforight">
    <xsl:choose>
     <xsl:when test="d_tied_to_file != ''">
      <xsl:value-of select="d_tied_to_file/@value" />
     </xsl:when>
     <xsl:otherwise>
      <xsl:value-of select="/root/labels/no" />
     </xsl:otherwise>
    </xsl:choose>
   </div>
   <div class="clr"></div>
  </li>
  <li class="line">
   <div class="infoleft">
    <xsl:value-of select="/root/labels/filestats" />
   </div>
   <div class="inforight">
    <xsl:value-of select="d_multi_file/@value" />
    <xsl:choose>
     <xsl:when test="d_multi_file != 0">
      <xsl:text> </xsl:text>
      <xsl:value-of select="d_size_files" />
      <xsl:text> </xsl:text>
      <xsl:value-of select="/root/labels/files" />
     </xsl:when>
    </xsl:choose>
   </div>
   <div class="clr"></div>
  </li>
  <li class="line spacer">
   <div class="infoleft">
    <xsl:value-of select="/root/labels/private" />
   </div>
   <div class="inforight">
    <xsl:value-of select="d_private/@value" />
   </div>
   <div class="clr"></div>
  </li>
  <li class="line">
   <div class="infoleft">
    <xsl:value-of select="/root/labels/chunks" />
   </div>
   <div class="inforight">
    <xsl:value-of select="d_completed_chunks" />
    <xsl:text> / </xsl:text>
    <xsl:value-of select="d_chunks_hashed" />
    <xsl:text> * </xsl:text>
    <xsl:value-of select="d_chunk_size/@value" />
    <xsl:text> </xsl:text>
    <xsl:value-of select="d_chunk_size/@suffix" />
   </div>
   <div class="clr"></div>
  </li>
  <li class="line">
   <div class="infoleft">
    <xsl:value-of select="/root/labels/priority" />
   </div>
   <div class="inforight">
    <xsl:value-of select="d_priority/@value" />
   </div>
   <div class="clr"></div>
  </li>
  <li class="line spacer">
   <div class="infoleft">
    <xsl:value-of select="/root/labels/statechanged" />
   </div>
   <div class="inforight">
    <xsl:value-of select="d_state_changed/@value" />
   </div>
   <div class="clr"></div>
  </li>
  <li class="line spacer">
   <div class="infoleft">
    <xsl:value-of select="/root/labels/freediskspace" />
   </div>
   <div class="inforight">
    <xsl:value-of select="d_free_diskspace/@value" />
    <xsl:text> </xsl:text>
    <xsl:value-of select="d_free_diskspace/@suffix" />
   </div>
   <div class="clr"></div>
  </li>
  <li class="line">
   <div class="infoleft">
    <xsl:value-of select="/root/labels/connectiontype" />
   </div>
   <div class="inforight">
    <xsl:value-of select="d_connection_current/@value" />
   </div>
   <div class="clr"></div>
  </li>
  <li class="line">
   <div class="infoleft">
    <xsl:value-of select="/root/labels/trackers" />
   </div>
   <div class="inforight">
    <xsl:value-of select="d_tracker_size" />
   </div>
   <div class="clr"></div>
  </li>
  <li class="line">
   <div class="infoleft">
    <xsl:value-of select="/root/labels/peersconnected" />
   </div>
   <div class="inforight">
    <span title="{/root/labels/dminpeers}: {d_peers_min} - {/root/labels/dmaxpeers}: {d_peers_max}">
     <xsl:value-of select="d_peers_connected" />
    </span>
   </div>
   <div class="clr"></div>
  </li>
  <li class="line">
   <div class="infoleft">
    <xsl:value-of select="/root/labels/leechers" />
   </div>
   <div class="inforight">
    <xsl:value-of select="d_peers_accounted" />
   </div>
   <div class="clr"></div>
  </li>
  <li class="line spacer">
   <div class="infoleft">
    <xsl:value-of select="/root/labels/seeders" />
   </div>
   <div class="inforight">
    <xsl:value-of select="d_peers_complete" />
   </div>
   <div class="clr"></div>
  </li>
  <li class="line">
   <div class="infoleft">
    <xsl:value-of select="/root/labels/pexenabled" />
   </div>
   <div class="inforight">
    <xsl:value-of select="d_pex_active/@value" />
   </div>
   <div class="clr"></div>
  </li>
  <li class="line spacer">
   <div class="infoleft">
    <xsl:value-of select="/root/labels/pexsize" />
   </div>
   <div class="inforight">
    <xsl:value-of select="d_size_pex" />
    <xsl:text> / </xsl:text>
    <xsl:value-of select="d_max_size_pex" />
   </div>
   <div class="clr"></div>
  </li>
  <li class="line">
   <div class="infoleft">
    <xsl:value-of select="/root/labels/upload" />
   </div>
   <div class="inforight">
    <xsl:value-of select="d_up_rate/@value" />
    <xsl:text> </xsl:text>
    <xsl:value-of select="d_up_rate/@suffix" />
    <xsl:text> / </xsl:text>
    <xsl:value-of select="d_up_total/@value" />
    <xsl:text> </xsl:text>
    <xsl:value-of select="d_up_total/@suffix" />
   </div>
   <div class="clr"></div>
  </li>
  <li class="line">
   <div class="infoleft">
    <xsl:value-of select="/root/labels/download" />
   </div>
   <div class="inforight">
    <xsl:value-of select="d_down_rate/@value" />
    <xsl:text> </xsl:text>
    <xsl:value-of select="d_down_rate/@suffix" />
    <xsl:text> / </xsl:text>
    <xsl:value-of select="d_down_total/@value" />
    <xsl:text> </xsl:text>
    <xsl:value-of select="d_down_total/@suffix" />
   </div>
   <div class="clr"></div>
  </li>
  <li class="line">
   <div class="infoleft">
    <xsl:value-of select="/root/labels/skipped" />
   </div>
   <div class="inforight">
    <xsl:value-of select="d_skip_rate/@value" />
    <xsl:text> </xsl:text>
    <xsl:value-of select="d_skip_rate/@suffix" />
    <xsl:text> / </xsl:text>
    <xsl:value-of select="d_skip_total/@value" />
    <xsl:text> </xsl:text>
    <xsl:value-of select="d_skip_total/@suffix" />
   </div>
   <div class="clr"></div>
  </li>
 </xsl:template>

 <xsl:template match="torrent_files_root">
  <xsl:apply-templates select="torrent_files" />
 </xsl:template>

 <xsl:template match="torrent_files">
  <xsl:apply-templates select="files_root" />
 </xsl:template>

 <xsl:template match="torrent_trackers_root">
  <xsl:apply-templates select="torrent_trackers" />
 </xsl:template>

 <xsl:template match="torrent_trackers">
  <xsl:apply-templates select="tracker" />
 </xsl:template>

 <xsl:template match="torrent_peers_root">
  <xsl:apply-templates select="torrent_peers" />
 </xsl:template>

 <xsl:template match="torrent_peers">
  <li class="phead">
   <div class="paddress">
    <xsl:value-of select="/root/labels/address" />
   </div>
   <div class="pup">
    <xsl:value-of select="/root/labels/up_rate" />
   </div>
   <div class="pdown">
    <xsl:value-of select="/root/labels/down_rate" />
   </div>
   <div class="prate">
    <xsl:value-of select="/root/labels/peer_rate" />
   </div>
   <div class="pdone">
    <xsl:value-of select="/root/labels/pdone" />
   </div>
   <div class="pincoming">
    <xsl:value-of select="/root/labels/incoming" />
   </div>
   <div class="pencrypted">
    <xsl:value-of select="/root/labels/encrypted" />
   </div>
   <div class="pclient">
    <xsl:value-of select="/root/labels/pclientversion" />
   </div>
   <div class="clr"></div>
  </li>
  <xsl:apply-templates select="peer" />
 </xsl:template>

 <xsl:template match="server_info">
  <li class="line">
   <div class="infoleft">
    <xsl:value-of select="/root/labels/hostname" />
   </div>
   <div class="inforight">
    <xsl:value-of select="hostname" />
   </div>
   <div class="clr"></div>
  </li>
  <li class="line spacer">
   <div class="infoleft">
    <xsl:value-of select="/root/labels/pid" />
   </div>
   <div class="inforight">
    <xsl:value-of select="pid" />
   </div>
   <div class="clr"></div>
  </li>
  <li class="line">
   <div class="infoleft">
    <xsl:value-of select="/root/labels/clientversion" />
   </div>
   <div class="inforight">
    <xsl:value-of select="client_version" />
   </div>
   <div class="clr"></div>
  </li>
  <li class="line spacer">
   <div class="infoleft">
    <xsl:value-of select="/root/labels/libraryversion" />
   </div>
   <div class="inforight">
    <xsl:value-of select="library_version" />
   </div>
   <div class="clr"></div>
  </li>
  <li class="line">
   <div class="infoleft">
    <xsl:value-of select="/root/labels/workingdirectory" />
   </div>
   <div class="inforight">
    <xsl:value-of select="get_cwd" />
   </div>
   <div class="clr"></div>
  </li>
  <li class="line">
   <div class="infoleft">
    <xsl:value-of select="/root/labels/downloaddirectory" />
   </div>
   <div class="inforight">
    <xsl:value-of select="directory/@value" />
   </div>
   <div class="clr"></div>
  </li>
  <li class="line spacer">
   <div class="infoleft">
    <xsl:value-of select="/root/labels/sessiondirectory" />
   </div>
   <div class="inforight">
    <xsl:value-of select="session/@value" />
   </div>
   <div class="clr"></div>
  </li>
  <li class="line">
   <div class="infoleft">
    <xsl:value-of select="/root/labels/listeningipaddress" />
   </div>
   <div class="inforight">
    <xsl:value-of select="bind/@value" />
   </div>
   <div class="clr"></div>
  </li>
  <li class="line">
   <div class="infoleft">
    <xsl:value-of select="/root/labels/reportedipaddress" />
   </div>
   <div class="inforight">
    <xsl:value-of select="ip/@value" />
   </div>
   <div class="clr"></div>
  </li>
  <li class="line">
   <div class="infoleft">
    <xsl:value-of select="/root/labels/portopened" />
   </div>
   <div class="inforight">
    <xsl:value-of select="port_open/@value" />
   </div>
   <div class="clr"></div>
  </li>
  <li class="line">
   <div class="infoleft">
    <xsl:value-of select="/root/labels/randomport" />
   </div>
   <div class="inforight">
    <xsl:value-of select="port_random/@value" />
   </div>
   <div class="clr"></div>
  </li>
  <li class="line">
   <div class="infoleft">
    <xsl:value-of select="/root/labels/portrange" />
   </div>
   <div class="inforight">
    <xsl:value-of select="port_range/@value" />
   </div>
   <div class="clr"></div>
  </li>
  <li class="line spacer">
   <div class="infoleft">
    <xsl:value-of select="/root/labels/udptrackers" />
   </div>
   <div class="inforight">
    <xsl:value-of select="use_udp_trackers/@value" />
   </div>
   <div class="clr"></div>
  </li>
  <xsl:choose>
   <xsl:when test="/root/allow_dht = 'true'">
    <xsl:choose>
     <xsl:when test="dht_statistics_active = 0">
      <li class="line spacer">
       <div class="infoleft">
        <xsl:value-of select="/root/labels/dht" />
       </div>
       <div class="inforight" onmouseover="this.style.cursor='pointer';" onclick="toggle( 'serverinfo_info_restore' );">
        <form class="changedhtstatusform" name="changedhtstatusform" method="post" action="{/root/iurl}?mod=changedhtstatus">
         <span id="changedhtselect">
          <select class="whiteselect" name="dhtstatus" title="{/root/labels/changedhtstatus}" onchange="window.location='{/root/iurl}?mod=changedhtstatus&amp;dhtstatus='+this.value;">
           <option value="0" title="{/root/labels/stopped}" selected="selected"><xsl:value-of select="/root/labels/stopped" /></option>
           <option value="1" title="{/root/labels/start}"><xsl:value-of select="/root/labels/start" /></option>
          </select>
         </span>
         <noscript>
          <input class="submit" type="submit" name="{/root/labels/ok}" value="{/root/labels/ok}" title="{/root/labels/ok}" />
         </noscript>
         <span id="changedht" title="{/root/labels/clicktochange}">
          <xsl:value-of select="dht_statistics_active/@value" />
         </span>
        </form>
       </div>
       <div class="clr"></div>
      </li>
     </xsl:when>
     <xsl:otherwise>
      <li class="line">
       <div class="infoleft">
        <xsl:value-of select="/root/labels/dht" />
       </div>
       <div class="inforight" onmouseover="this.style.cursor='pointer';" onclick="toggle( 'serverinfo_info_restore' );">
        <form class="changedhtstatusform" name="changedhtstatusform" method="post" action="{/root/iurl}?mod=changedhtstatus">
         <span id="changedhtselect">
          <select class="whiteselect" name="dhtstatus" title="{/root/labels/changedhtstatus}" onchange="window.location='{/root/iurl}?mod=changedhtstatus&amp;dhtstatus='+this.value;">
           <option value="0" title="{/root/labels/stop}"><xsl:value-of select="/root/labels/stop" /></option>
           <option value="1" title="{/root/labels/started}" selected="selected"><xsl:value-of select="/root/labels/started" /></option>
          </select>
         </span>
         <noscript>
          <input class="submit" type="submit" name="{/root/labels/ok}" value="{/root/labels/ok}" title="{/root/labels/ok}" />
         </noscript>
         <span id="changedht" title="{/root/labels/clicktochange}">
          <xsl:value-of select="dht_statistics_active/@value" />
         </span>
        </form>
       </div>
       <div class="clr"></div>
      </li>
      <li class="line">
       <div class="infoleft">
        <xsl:value-of select="/root/labels/dhtport" />
       </div>
       <div class="inforight">
        <xsl:value-of select="dht_port" />
       </div>
       <div class="clr"></div>
      </li>
      <li class="line">
       <div class="infoleft">
        <xsl:value-of select="/root/labels/dhtcycle" />
       </div>
       <div class="inforight">
        <xsl:value-of select="dht_statistics_cycle" />
       </div>
       <div class="clr"></div>
      </li>
      <li class="line">
       <div class="infoleft">
        <xsl:value-of select="/root/labels/dhtqueries" />
       </div>
       <div class="inforight">
        <xsl:value-of select="dht_statistics_queries_received" />
        <xsl:text> / </xsl:text>
        <xsl:value-of select="dht_statistics_queries_sent" />
       </div>
       <div class="clr"></div>
      </li>
      <li class="line">
       <div class="infoleft">
        <xsl:value-of select="/root/labels/dhtreplies" />
       </div>
       <div class="inforight">
        <xsl:value-of select="dht_statistics_replies_received" />
       </div>
       <div class="clr"></div>
      </li>
      <li class="line">
       <div class="infoleft">
        <xsl:value-of select="/root/labels/dhtbytes" />
       </div>
       <div class="inforight">
        <xsl:value-of select="dht_statistics_bytes_read/@value" />
        <xsl:text> </xsl:text>
        <xsl:value-of select="dht_statistics_bytes_read/@suffix" />
        <xsl:text> / </xsl:text>
        <xsl:value-of select="dht_statistics_bytes_written/@value" />
        <xsl:text> </xsl:text>
        <xsl:value-of select="dht_statistics_bytes_written/@suffix" />
       </div>
       <div class="clr"></div>
      </li>
      <li class="line">
       <div class="infoleft">
        <xsl:value-of select="/root/labels/dhtnodes" />
       </div>
       <div class="inforight">
        <xsl:value-of select="dht_statistics_nodes" />
        <xsl:text> </xsl:text>
        <xsl:value-of select="/root/labels/in" />
        <xsl:text> </xsl:text>
        <xsl:value-of select="dht_statistics_buckets" />
        <xsl:text> </xsl:text>
        <xsl:value-of select="/root/labels/buckets" />
       </div>
       <div class="clr"></div>
      </li>
      <li class="line">
       <div class="infoleft">
        <xsl:value-of select="/root/labels/dhtpeers" />
       </div>
       <div class="inforight">
        <xsl:value-of select="dht_statistics_peers" />
        <xsl:text> (</xsl:text>
        <xsl:value-of select="/root/labels/highest" />
        <xsl:text>: </xsl:text>
        <xsl:value-of select="dht_statistics_peers_max" />
        <xsl:text>)</xsl:text>
       </div>
       <div class="clr"></div>
      </li>
      <li class="line spacer">
       <div class="infoleft">
        <xsl:value-of select="/root/labels/dhttorrents" />
       </div>
       <div class="inforight">
        <xsl:value-of select="dht_statistics_torrents" />
       </div>
       <div class="clr"></div>
      </li>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:when>
  </xsl:choose>
  <li class="line">
   <div class="infoleft">
    <xsl:value-of select="/root/labels/maxuploads" />
   </div>
   <div class="inforight">
    <xsl:value-of select="max_uploads/@value" />
   </div>
   <div class="clr"></div>
  </li>
  <li class="line">
   <div class="infoleft">
    <xsl:value-of select="/root/labels/minpeers" />
   </div>
   <div class="inforight">
    <xsl:value-of select="min_peers/@value" />
   </div>
   <div class="clr"></div>
  </li>
  <li class="line">
   <div class="infoleft">
    <xsl:value-of select="/root/labels/maxpeers" />
   </div>
   <div class="inforight">
    <xsl:value-of select="max_peers/@value" />
   </div>
   <div class="clr"></div>
  </li>
  <li class="line">
   <div class="infoleft">
    <xsl:value-of select="/root/labels/memoryusage" />
   </div>
   <div class="inforight">
    <xsl:value-of select="memory_usage/@value" />
    <xsl:text> </xsl:text>
    <xsl:value-of select="memory_usage/@suffix" />
   </div>
   <div class="clr"></div>
  </li>
  <li class="line spacer">
   <div class="infoleft">
    <xsl:value-of select="/root/labels/maxmemoryusage" />
   </div>
   <div class="inforight">
    <xsl:value-of select="max_memory_usage/@value" />
    <xsl:text> </xsl:text>
    <xsl:value-of select="max_memory_usage/@suffix" />
   </div>
   <div class="clr"></div>
  </li>
  <li class="line">
   <div class="infoleft">
    <xsl:value-of select="/root/labels/hashcheck" />
   </div>
   <div class="inforight">
    <xsl:value-of select="check_hash/@value" />
   </div>
   <div class="clr"></div>
  </li>
  <li class="line">
   <div class="infoleft">
    <xsl:value-of select="/root/labels/safesync" />
   </div>
   <div class="inforight">
    <xsl:value-of select="safe_sync/@value" />
   </div>
   <div class="clr"></div>
  </li>
  <li class="line">
   <div class="infoleft">
    <xsl:value-of select="/root/labels/sendbuffer" />
   </div>
   <div class="inforight">
    <xsl:value-of select="receive_buffer_size/@value" />
    <xsl:text> </xsl:text>
    <xsl:value-of select="receive_buffer_size/@suffix" />
   </div>
   <div class="clr"></div>
  </li>
  <li class="line">
   <div class="infoleft">
    <xsl:value-of select="/root/labels/receivebuffer" />
   </div>
   <div class="inforight">
    <xsl:value-of select="receive_buffer_size/@value" />
    <xsl:text> </xsl:text>
    <xsl:value-of select="receive_buffer_size/@suffix" />
   </div>
   <div class="clr"></div>
  </li>
 </xsl:template>

 <xsl:template match="files_root">
  <xsl:apply-templates select="directory" />
  <xsl:apply-templates select="file" />
 </xsl:template>

 <xsl:template match="directory">
  <li>
   <div class="dopenlink">
    <a title="{/root/labels/clicktoopenclose}" onmouseover="this.style.cursor='pointer';" onclick="if ( this.parentNode.parentNode.getElementsByTagName( 'ul' ).item( 0 ).style.display == '' ) {{ this.parentNode.parentNode.getElementsByTagName( 'ul' ).item( 0 ).style.display = 'none' }} else {{ this.parentNode.parentNode.getElementsByTagName( 'ul' ).item( 0 ).style.display = '' }};"><xsl:value-of select="@dirname" /></a>
   </div>
   <div class="dpriority">
    <form class="changedirpriorityform" name="changedirpriorityform_{@id}" method="post" action="{/root/iurl}?mod=changedirpriority&amp;hash={/root/hash}&amp;dir={@dirpath}">
     <select class="whiteselect" name="dirpriority" title="{/root/labels/selectdirpriority}" onchange="window.location='{/root/iurl}?mod=changedirpriority&amp;hash={/root/hash}&amp;dir={@dirpath}&amp;dirpriority='+this.value;">
      <option value="-1" title="{/root/labels/selectone}" selected="selected"><xsl:value-of select="/root/labels/selectone" /></option>
      <option value="0" title="{/root/labels/off}"><xsl:value-of select="/root/labels/off" /></option>
      <option value="1" title="{/root/labels/normal}"><xsl:value-of select="/root/labels/normal" /></option>
      <option value="2" title="{/root/labels/high}"><xsl:value-of select="/root/labels/high" /></option>
     </select>
     <noscript>
      <input class="submit" type="submit" name="{/root/labels/ok}" value="{/root/labels/ok}" title="{/root/labels/ok}" />
     </noscript>
    </form>
   </div>
   <div class="clr"></div>
   <xsl:choose>
    <xsl:when test="/root/allow_hidedirtree = 'true'">
     <ul class="directory">
      <xsl:apply-templates select="directory" />
      <xsl:apply-templates select="file" />
     </ul>
    </xsl:when>
    <xsl:otherwise>
     <ul class="directory nohide">
      <xsl:apply-templates select="directory" />
      <xsl:apply-templates select="file" />
     </ul>
    </xsl:otherwise>
   </xsl:choose>
  </li>
 </xsl:template>

 <xsl:template match="file">
  <li onmouseover="this.style.background='#eeeeee';" onmouseout="this.style.background='';">
   <div class="fname">
    <span title="{/root/labels/lasttouched}: {f_last_touched}">
     <xsl:value-of select="@filename" />
    </span>
   </div>
   <div class="fpercentage">
    <span title="{f_percentage/@value} {/root/labels/percentcompleted}">
     <xsl:text>[</xsl:text>
     <xsl:value-of select="f_percentage/@value" />
     <xsl:text> %]</xsl:text>
    </span>
   </div>
   <div class="fpriority">
    <form class="changefilepriorityform" name="changefilepriorityform_{@id}" method="post" action="{/root/iurl}?mod=changefilepriority&amp;hash={/root/hash}&amp;id={@id}">
     <select class="whiteselect" name="filepriority" title="{/root/labels/selectfilepriority}" onchange="window.location='{/root/iurl}?mod=changefilepriority&amp;hash={/root/hash}&amp;id={@id}&amp;filepriority='+this.value;">
      <xsl:choose>
       <xsl:when test="f_priority = 0">
        <option value="0" title="{/root/labels/off}" selected="selected"><xsl:value-of select="/root/labels/off" /></option>
        <option value="1" title="{/root/labels/normal}"><xsl:value-of select="/root/labels/normal" /></option>
        <option value="2" title="{/root/labels/high}"><xsl:value-of select="/root/labels/high" /></option>
       </xsl:when>
       <xsl:when test="f_priority = 2">
        <option value="0" title="{/root/labels/off}"><xsl:value-of select="/root/labels/off" /></option>
        <option value="1" title="{/root/labels/normal}"><xsl:value-of select="/root/labels/normal" /></option>
        <option value="2" title="{/root/labels/high}" selected="selected"><xsl:value-of select="/root/labels/high" /></option>
       </xsl:when>
       <xsl:otherwise>
        <option value="0" title="{/root/labels/off}"><xsl:value-of select="/root/labels/off" /></option>
        <option value="1" title="{/root/labels/normal}" selected="selected"><xsl:value-of select="/root/labels/normal" /></option>
        <option value="2" title="{/root/labels/high}"><xsl:value-of select="/root/labels/high" /></option>
       </xsl:otherwise>
      </xsl:choose>
     </select>
     <noscript>
      <input class="submit" type="submit" name="{/root/labels/ok}" value="{/root/labels/ok}" title="{/root/labels/ok}" />
     </noscript>
    </form>
   </div>
   <div class="fsize">
    <span title="{/root/labels/filesize}">
     <xsl:value-of select="f_size_bytes/@value" />
     <xsl:text> </xsl:text>
     <xsl:value-of select="f_size_bytes/@suffix" />
    </span>
   </div>
   <div class="fchunks">
    <span title="{/root/labels/chunks}">
     <xsl:choose>
      <xsl:when test="f_range_first != f_range_second">
       <xsl:value-of select="f_range_first" />
       <xsl:text> - </xsl:text>
       <xsl:value-of select="f_range_second" />
      </xsl:when>
      <xsl:otherwise>
       <xsl:value-of select="f_range_first" />
      </xsl:otherwise>
     </xsl:choose>
    </span>
   </div>
   <xsl:choose>
    <xsl:when test="f_percentage = 1 and /root/allow_download = 'true'">
     <div class="fdownload">
      <a href="?mod=getfile&amp;hash={/root/hash}&amp;id={@id}" title="{/root/labels/downloadfile}"><xsl:value-of select="/root/labels/download" /></a>
     </div>
    </xsl:when>
   </xsl:choose>
   <div class="clr"></div>
  </li>
 </xsl:template>

 <xsl:template match="dlpath">
  <li onmouseover="this.style.background='#eeeeee';" onmouseout="this.style.background='';">
   <div class="tufpath">
    <a href="?mod=addtorrent&amp;path={@path}">
     <xsl:value-of select="@name" />
    </a>
   </div>
   <div class="tufspace">
    <xsl:value-of select="@freespace_value" />
    <xsl:text> </xsl:text>
    <xsl:value-of select="@freespace_suffix" />
   </div>
   <div class="clr"></div>
  </li>
 </xsl:template>

 <xsl:template match="tracker">
  <li>
   <ul>
    <li>
     <div class="tgroup">
      <span title="{/root/labels/trackergroup}">
       <xsl:value-of select="t_group" />
       <xsl:text>:</xsl:text>
      </span>
     </div>
     <div class="turl">
      <span title="{/root/labels/type}: {t_type/@value}">
       <xsl:value-of select="t_url" />
      </span>
     </div>
     <div class="clr"></div>
    </li>
    <li>
     <div class="tfocus">
      <xsl:choose>
       <xsl:when test="root/tottents/torrent_trackers_root/torrent_trackers/d_tracker_focus = @id">
        <xsl:value-of select="/root/labels/focus" />
        <xsl:text>: </xsl:text>
        <xsl:value-of select="/root/labels/yes" />
       </xsl:when>
       <xsl:otherwise>
        <xsl:value-of select="/root/labels/focus" />
        <xsl:text>: </xsl:text>
        <xsl:value-of select="/root/labels/no" />
       </xsl:otherwise>
      </xsl:choose>
     </div>
     <div class="tenabled">
      <form class="changetrackerenabledform" name="changetrackerenabledform_{@id}" method="post" action="{/root/iurl}?mod=changetrackerenabled&amp;hash={/root/hash}&amp;id={@id}">
       <xsl:value-of select="/root/labels/enabled" />
       <xsl:text>: </xsl:text>
       <select class="whiteselect" name="trackerenabled" title="{/root/labels/selecttrackerenabled}" onchange="window.location='{/root/iurl}?mod=changetrackerenabled&amp;hash={/root/hash}&amp;id={@id}&amp;trackerenabled='+this.value;">
        <xsl:choose>
         <xsl:when test="t_enabled = 0">
          <option value="1" title="{/root/labels/yes}"><xsl:value-of select="/root/labels/yes" /></option>
          <option value="0" title="{/root/labels/no}" selected="selected"><xsl:value-of select="/root/labels/no" /></option>
         </xsl:when>
         <xsl:otherwise>
          <option value="1" title="{/root/labels/yes}" selected="selected"><xsl:value-of select="/root/labels/yes" /></option>
          <option value="0" title="{/root/labels/no}"><xsl:value-of select="/root/labels/no" /></option>
         </xsl:otherwise>
        </xsl:choose>
       </select>
       <noscript>
        <input class="submit" type="submit" name="submit" value="{/root/labels/ok}" title="{/root/labels/ok}" />
       </noscript>
      </form>
     </div>
     <div class="topen">
      <xsl:value-of select="/root/labels/opened" />
      <xsl:text>: </xsl:text>
      <xsl:choose>
       <xsl:when test="t_open != 0">
        <xsl:value-of select="/root/labels/yes" />
       </xsl:when>
       <xsl:otherwise>
        <xsl:value-of select="/root/labels/no" />
       </xsl:otherwise>
      </xsl:choose>
     </div>
     <div class="tpeers">
      <xsl:value-of select="/root/labels/seedersleechers" />
      <xsl:text>: </xsl:text>
      <xsl:value-of select="t_scrape_complete" />
      <xsl:text> / </xsl:text>
      <xsl:value-of select="t_scrape_incomplete" />
     </div>
     <div class="clr"></div>
    </li>
    <li>
     <div class="tscrape">
      <span title="{/root/labels/mininterval}: {t_min_interval/@value} - Normal interval: {t_normal_interval/@value}">
       <xsl:value-of select="/root/labels/lasttimescraped" />
       <xsl:text>: </xsl:text>
       <xsl:value-of select="t_scrape_time_last/@value" />
      </span>
     </div>
     <div class="clr"></div>
    </li>
   </ul>
  </li>
 </xsl:template>

 <xsl:template match="peer">
  <li>
   <div class="paddress">
    <xsl:choose>
     <xsl:when test="p_country != ''">
      <img src="flags/{p_country}.gif" alt="flag" title="{p_country/@value}" />
     </xsl:when>
    </xsl:choose>
    <xsl:value-of select="p_address" />
   </div>
   <div class="pup">
    <xsl:value-of select="p_up_rate/@value" />
    <xsl:text> </xsl:text>
    <xsl:value-of select="p_up_rate/@suffix" />
   </div>
   <div class="pdown">
    <xsl:value-of select="p_down_rate/@value" />
    <xsl:text> </xsl:text>
    <xsl:value-of select="p_down_rate/@suffix" />
   </div>
   <div class="prate">
    <xsl:value-of select="p_peer_rate/@value" />
    <xsl:text> </xsl:text>
    <xsl:value-of select="p_peer_rate/@suffix" />
   </div>
   <div class="pdone">
    <xsl:value-of select="p_completed_percent" />
    <xsl:text> %</xsl:text>
   </div>
   <div class="pincoming">
    <xsl:value-of select="p_incoming/@value" />
   </div>
   <div class="pencrypted">
    <xsl:value-of select="p_encrypted/@value" />
   </div>
   <div class="pclient">
    <xsl:value-of select="p_client_version" />
   </div>
   <div class="clr"></div>
  </li>
 </xsl:template>

</xsl:stylesheet>
