﻿<xsl:stylesheet version="1.1"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                lang="hu">
 <xsl:output method="xml"
             indent="no"
             encoding="utf-8"
             doctype-public="-//W3C//DTD XHTML 1.0 Transitional//EN"
             doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd" />

 <xsl:template match="root">
  <html lang="hu">
   <head>
    <meta http-equiv="content-type" content="text/html; charset=utf-8" />
    <meta http-equiv="content-language" content="hu" />
    <meta http-equiv="cache-control" content="no-store, no-cache, must-revalidate, post-check=0, pre-check=0" />
    <meta http-equiv="pragma" content="no-cache" />
    <meta http-equiv="expires" content="thu, 1 jan 1970 00:00:00 gmt" />
    <meta http-equiv="imagetoolbar" content="no" />  
    <meta name="author" content="{/root/author}" />
    <meta name="description" content="{/root/description}" />
    <meta name="keywords" content="{/root/keywords}" />
    <meta name="doc-type" content="web page" />
    <meta name="rating" content="general" />
    <meta name="robots" content="all" />
    <link rel="stylesheet" type="text/css" href="themes/default_ajax/inc/style.css" />
    <title><xsl:value-of select="/root/title" /></title>
   </head>
   <body onload="document.getElementById( 'lfname' ).focus();">
    <div id="top">
    </div>
    <div id="loginbox">
     <xsl:apply-templates select="err" />
     <form id="login" method="post" action="{/root/iurl}?mod=login">
      <ul>
       <li>
        <div class="lftitle">Username:</div>
        <div class="lffield">
         <input id="lfname" type="text" title="Username" name="loginname" />
        </div>
       </li>
       <li>
        <div class="lftitle">Password:</div>
        <div class="lffield">
         <input id="lfpass" type="password" title="Password" name="loginpass" />
        </div>
       </li>
       <li class="formsend">
        <input class="inputok" type="image" src="themes/default_ajax/pics/btn_ok.gif" title="Login" alt="[OK]" value="ok" />
       </li>
      </ul>
     </form>
    </div>
   </body>
  </html>
 </xsl:template>

 <xsl:template match="err">
  <div id="err">
   <span title="Click to hide" onmouseover="this.style.cursor='pointer';" onclick="document.getElementById( 'err' ).style.display='none';">
    <xsl:value-of select="errmsg" />
   </span>
  </div>
 </xsl:template>

</xsl:stylesheet>
