<?php

/*******************************
* path settings
*******************************/

// default extension for php files (html/php)
$default_ext = "html";

// paths
$abs_path	= "/var/www";		// webroot (with heading slash)
$domain		= "cyla.homelinux.net";	// site domain (or ip)
$subdomain	= "rtwi";		// subdomain (if exists)
$site_path	= "/";			// site path (with heading and trailing slash)
$include_path	= "includes";		// include path (include files can be found here)

// URLs
$url = array(
	"base"	=> "http://{$subdomain}.{$domain}{$site_path}",	// base url (if you do not have a subdomain, you might want to edit this line)
	"index"	=> "index.{$default_ext}",			// index page
	"input"	=> "input.php",					// input file (for forms)
);
$url["full"] = 	"{$url["base"]}/index.{$default_ext}";		// absolute url, of the index page

/*******************************
* xmlrpc settings
*******************************/

$xmlrpc_array = array(
	"host"		=> "127.0.0.1",	// ip address of the rtorrent
	"port"		=> 0,		// scgi port - we will set this depending on the user's settings
	"timeout"	=> 10,		// connection timeout
);

/*******************************
* user settings
*******************************/

// home directories (with heading and trailing slash)
$home_path = "/home/";

// array of users, each, with the sha1 hash of the password, and the scgi port of the rtorrent
$users = array(
	"username"		=> array( "pass" => "sha1has of the password", "port"	=> "36100" ),
);

/*******************************
* other settings
*******************************/

// language (only english is available atm)
$lang = "en";

// site theme (look for themes in the "themes" directory)
$site_theme = "default_ajax";

?>
