<?php

class page_handler {
	var $content;
	var $page_data;
	var $main_file;
	var $theme;
	var $xml_data;

	function __construct( $theme, $main_file, $page_data ) {
		$this->page_data = $page_data;
		$this->main_file = $main_file;
		$this->theme = $theme;
	}

	function parse() {
		$xsl = new DOMDocument;
		$xsl->load( "themes/{$this->theme}/{$this->main_file}" );

		$this->content = new XSLTprocessor();
		$this->content->importStyleSheet( $xsl );

		$this->xml_data = $this->content->transformToXML( $this->page_data );
	}

	function parse_c() {
		$this->xml_data = $this->page_data->saveXML();
	}

	function fetch() {
		$this->xml_data = preg_replace( "/\<\?xml( version=\"[\d\.]+\")*( encoding=\".*\")*\?\>[\\r\\n]*/", "", $this->xml_data );
		$this->xml_data = preg_replace( "/\<\!\[CDATA\[(.*?)\]\]\>/", "\r\n\\1", $this->xml_data );
		return $this->xml_data;
	}

	function fetch_c() {
		$this->xml_data = preg_replace( "/\<\?xml( version=\"[\d\.]+\")*( encoding=\".*\")*\?\>[\\r\\n]*/", "\\0<?xml-stylesheet type=\"text/xsl\" href=\"themes/{$this->theme}/{$this->main_file}\"?>\r\n", $this->xml_data );
		return $this->xml_data;
	}

}

?>
