<?php

function myrealpath( $path, $home, $cwd ) {
	if ( substr( $path, 0, 2 ) == "~/" ) {
		$path = substr( $path, 2 );
		$path = "{$home}{$_SESSION["rtwi_nick"]}/{$path}";
	}

	$oldcwd = getcwd();
	chdir( $cwd );
	$newpath = realpath( $path );
	chdir( $oldcwd );

	return $newpath;
}

function switch_bytes( $bytes, $d_suffix = "" ) {
	switch ( $d_suffix ) {
		case "GB" : {
			$ret = $bytes / 1024 / 1024 / 1024;
			$suffix = "GB";
			break;
		}
		case "MB" : {
			$ret = $bytes / 1024 / 1024;
			$suffix = "MB";
			break;
		}
		case "KB" : {
			$ret = $bytes / 1024;
			$suffix = "KB";
			break;
		}
		default : {
			if ( $bytes >= 1024 * 1024 * 1024 ) {
				$ret = $bytes / 1024 / 1024 / 1024;
				$suffix = "GB";
			} elseif ( $bytes >= 1024 * 1024 ) {
				$ret = $bytes / 1024 / 1024;
				$suffix = "MB";
			} elseif ( $bytes >= 1024 ) {
				$ret = $bytes / 1024;
				$suffix = "KB";
			} else {
				$ret = $bytes;
				$suffix = "B";
			}
		}
	}

	return array( $ret, $suffix );
}

function prepare_serverinfo_responses( &$responses, &$message, &$config ) {
	$bytes_down_arr = switch_bytes( $responses["bytes_down"] );
	$bytes_up_arr = switch_bytes( $responses["bytes_up"] );
	$download_rate_arr = switch_bytes( $responses["download_rate"], "KB" );
	$max_memory_usage_arr = switch_bytes( $responses["max_memory_usage"] );
	$memory_usage_arr = switch_bytes( $responses["memory_usage"] );
	$preload_min_size_arr = switch_bytes( $responses["preload_min_size"] );
	$preload_required_rate_arr = switch_bytes( $responses["preload_required_rate"] );
	$receive_buffer_size_arr = switch_bytes( $responses["receive_buffer_size"] );
	$send_buffer_size_arr = switch_bytes( $responses["send_buffer_size"] );
	$upload_rate_arr = switch_bytes( $responses["upload_rate"], "KB" );

	$responses["bytes_down_value"] = sprintf( "%.1f", $bytes_down_arr[0] );
	$responses["bytes_down_suffix"] = $bytes_down_arr[1];
	$responses["bytes_up_value"] = sprintf( "%.1f", $bytes_up_arr[0] );
	$responses["bytes_up_suffix"] = $bytes_up_arr[1];
	$responses["download_rate_value"] = sprintf( "%.0f", $download_rate_arr[0] );
	$responses["download_rate_suffix"] = $download_rate_arr[1];
	$responses["max_memory_usage_value"] = sprintf( "%.1f", $max_memory_usage_arr[0] );
	$responses["max_memory_usage_suffix"] = $max_memory_usage_arr[1];
	$responses["memory_usage_value"] = sprintf( "%.1f", $memory_usage_arr[0] );
	$responses["memory_usage_suffix"] = $memory_usage_arr[1];
	$responses["preload_min_size_value"] = sprintf( "%.1f", $preload_min_size_arr[0] );
	$responses["preload_min_size_suffix"] = $preload_min_size_arr[1];
	$responses["preload_required_rate_value"] = sprintf( "%.1f", $preload_required_rate_arr[0] );
	$responses["preload_required_rate_suffix"] = $preload_required_rate_arr[1];
	$responses["receive_buffer_size_value"] = sprintf( "%.1f", $receive_buffer_size_arr[0] );
	$responses["receive_buffer_size_suffix"] = $receive_buffer_size_arr[1];
	$responses["send_buffer_size_value"] = sprintf( "%.1f", $send_buffer_size_arr[0] );
	$responses["send_buffer_size_suffix"] = $send_buffer_size_arr[1];
	$responses["upload_rate_value"] = sprintf( "%.0f", $upload_rate_arr[0] );
	$responses["upload_rate_suffix"] = $upload_rate_arr[1];

	$responses["check_hash_value"] = $responses["check_hash"] == 0 ? $message["no"] : $message["yes"];
	$responses["safe_sync_value"] = $responses["safe_sync"] == 0 ? $message["no"] : $message["yes"];
	$responses["use_udp_trackers_value"] = $responses["use_udp_trackers"] == 0 ? $message["no"] : $message["yes"];

	$responses["bind_value"] = $responses["bind"] == "0.0.0.0" ? $message["bind_0000"] : $responses["bind"];
	$responses["ip_value"] = $responses["ip"] == "0.0.0.0" ? $message["ip_0000"] : $responses["ip"];
	$responses["max_peers_value"] = $responses["max_peers"] == -1 ? $message["disabled"] : $responses["max_peers"];
	$responses["max_peers_seed_value"] = $responses["max_peers_seed"] == -1 ? $message["disabled"] : $responses["max_peers_seed"];
	$responses["max_uploads_value"] = $responses["max_uploads"] == -1 ? $message["disabled"] : $responses["max_uploads"];
	$responses["min_peers_value"] = $responses["min_peers"] == -1 ? $message["disabled"] : $responses["min_peers"];
	$responses["min_peers_seed_value"] = $responses["min_peers_seed"] == -1 ? $message["disabled"] : $responses["min_peers_seed"];
	$responses["port_open_value"] = $responses["port_open"] == -1 ? $message["no"] : $message["yes"];
	$responses["port_random_value"] = $responses["port_random"] == -1 ? $message["no"] : $message["yes"];
	$responses["port_range_value"] = $responses["port_range"] == -1 ? $message["disabled"] : $responses["port_range"];
	$responses["proxy_address_value"] = $responses["proxy_address"] == "0.0.0.0" ? $message["proxy_address_0000"] : $responses["proxy_address"];
	$responses["tracker_numwant_value"] = $responses["tracker_numwant"] == -1 ? $message["disabled"] : $responses["tracker_numwant"];

	$responses["directory_value"] = myrealpath( $responses["directory"], $config["home_path"], $responses["cwd"] );
	$responses["session_value"] = myrealpath( $responses["session"], $config["home_path"], $responses["cwd"] );

	if ( $responses["max_file_size"] == -1 ) {
		$responses["max_file_size_value"] = $message["disabled"];
	} else {
		$max_file_size_arr = switch_bytes( $responses["max_file_size"] );
		$responses["max_file_size_value"] = sprintf( "%.1f", $max_file_size_arr[0] );
		$responses["max_file_size_suffix"] = $max_file_size_arr[1];
	}

	if ( $responses["split_file_size"] == -1 ) {
		$responses["split_file_size_value"] = $message["disabled"];
	} else {
		$split_file_size_arr = switch_bytes( $responses["split_file_size"] );
		$responses["split_file_size_value"] = sprintf( "%.1f", $split_file_size_arr[0] );
		$responses["split_file_size_suffix"] = $split_file_size_arr[1];
	}

	if ( $config["dht"] === "1" ) {
		if ( $responses["dht_statistics_active"] != 0 ) {
			$dht_statistics_bytes_read_arr = switch_bytes( $responses["dht_statistics_bytes_read"] );
			$dht_statistics_bytes_written_arr = switch_bytes( $responses["dht_statistics_bytes_written"] );

			$responses["dht_statistics_bytes_read_value"] = sprintf( "%.1f", $dht_statistics_bytes_read_arr[0] );
			$responses["dht_statistics_bytes_read_suffix"] = $dht_statistics_bytes_read_arr[1];
			$responses["dht_statistics_bytes_written_value"] = sprintf( "%.1f", $dht_statistics_bytes_written_arr[0] );
			$responses["dht_statistics_bytes_written_suffix"] = $dht_statistics_bytes_written_arr[1];
		}

		$responses["dht_statistics_active_value"] = $responses["dht_statistics_active"] == 0 ? $message["dht_0"] : $message["dht_1"];
	}

	ksort( $responses );

	return true;
}

function prepare_downloadlist_responses( &$responses, &$message, &$home_path, &$cwd ) {
	$d_bytes_done_arr = switch_bytes( $responses["d_bytes_done"] );
	$d_chunk_size_arr = switch_bytes( $responses["d_chunk_size"] );
	$d_completed_bytes_arr = switch_bytes( $responses["d_completed_bytes"] );
	$d_down_rate_arr = switch_bytes( $responses["d_down_rate"] );
	$d_down_total_arr = switch_bytes( $responses["d_down_total"] );
	$d_free_diskspace_arr = switch_bytes( $responses["d_free_diskspace"] );
	$d_left_bytes_arr = switch_bytes( $responses["d_left_bytes"] );
	$d_max_file_size_arr = switch_bytes( $responses["d_max_file_size"] );
	$d_size_bytes_arr = switch_bytes( $responses["d_size_bytes"] );
	$d_skip_rate_arr = switch_bytes( $responses["d_skip_rate"] );
	$d_skip_total_arr = switch_bytes( $responses["d_skip_total"] );
	$d_up_rate_arr = switch_bytes( $responses["d_up_rate"] );
	$d_up_total_arr = switch_bytes( $responses["d_up_total"] );

	$responses["d_bytes_done_value"] = sprintf( "%.1f", $d_bytes_done_arr[0] );
	$responses["d_bytes_done_suffix"] = $d_bytes_done_arr[1];
	$responses["d_chunk_size_value"] = sprintf( "%.1f", $d_chunk_size_arr[0] );
	$responses["d_chunk_size_suffix"] = $d_chunk_size_arr[1];
	$responses["d_completed_bytes_value"] = sprintf( "%.1f", $d_completed_bytes_arr[0] );
	$responses["d_completed_bytes_suffix"] = $d_completed_bytes_arr[1];
	$responses["d_down_rate_value"] = sprintf( "%.1f", $d_down_rate_arr[0] );
	$responses["d_down_rate_suffix"] = $d_down_rate_arr[1];
	$responses["d_down_total_value"] = sprintf( "%.1f", $d_down_total_arr[0] );
	$responses["d_down_total_suffix"] = $d_down_total_arr[1];
	$responses["d_free_diskspace_value"] = sprintf( "%.1f", $d_free_diskspace_arr[0] );
	$responses["d_free_diskspace_suffix"] = $d_free_diskspace_arr[1];
	$responses["d_left_bytes_value"] = sprintf( "%.1f", $d_left_bytes_arr[0] );
	$responses["d_left_bytes_suffix"] = $d_left_bytes_arr[1];
	$responses["d_max_file_size_value"] = sprintf( "%.1f", $d_max_file_size_arr[0] );
	$responses["d_max_file_size_suffix"] = $d_max_file_size_arr[1];
	$responses["d_size_bytes_value"] = sprintf( "%.1f", $d_size_bytes_arr[0] );
	$responses["d_size_bytes_suffix"] = $d_size_bytes_arr[1];
	$responses["d_skip_rate_value"] = sprintf( "%.1f", $d_skip_rate_arr[0] );
	$responses["d_skip_rate_suffix"] = $d_skip_rate_arr[1];
	$responses["d_skip_total_value"] = sprintf( "%.1f", $d_skip_total_arr[0] );
	$responses["d_skip_total_suffix"] = $d_skip_total_arr[1];
	$responses["d_up_rate_value"] = sprintf( "%.1f", $d_up_rate_arr[0] );
	$responses["d_up_rate_suffix"] = $d_up_rate_arr[1];
	$responses["d_up_total_value"] = sprintf( "%.1f", $d_up_total_arr[0] );
	$responses["d_up_total_suffix"] = $d_up_total_arr[1];

	$responses["d_active_value"] = $responses["d_active"] == 1 ? $message["d_active_1"] : $message["d_active_0"];
	$responses["d_complete_value"] = $responses["d_complete"] == 1 ? $message["d_complete_1"] : $message["d_complete_0"];
	$responses["d_creation_date_value"] = date( "Y-m-d H:i:s", $responses["d_creation_date"] );
	$responses["d_ignore_commands_value"] = $responses["d_ignore_commands"] == 1 ? $message["d_ignore_commands_1"] : $message["d_ignore_commands_0"];
	$responses["d_hash_checked_value"] = $responses["d_hash_checked"] == 1 ? $message["d_hash_checked_1"] : $message["d_hash_checked_0"];
	$responses["d_hash_checking_value"] = $responses["d_hash_checking"] == 1 ? $message["d_hash_checking_1"] : $message["d_hash_checking_0"];
	$responses["d_multi_file_value"] = $responses["d_multi_file"] == 1 ? $message["d_multi_file_multi"] : $message["d_multi_file_single"];
	$responses["d_open_value"] = $responses["d_open"] == 1 ? $message["d_open_1"] : $message["d_open_0"];
	$responses["d_peer_exchange_value"] = $responses["d_peer_exchange"] == 0 ? $message["disabled"] : $message["enabled"];
	$responses["d_peers_max_value"] = $responses["d_peers_max"] == -1 ? $message["disabled"] : $responses["d_peers_max"];
	$responses["d_peers_min_value"] = $responses["d_peers_min"] == -1 ? $message["disabled"] : $responses["d_peers_min"];
	$responses["d_pex_active_value"] = $responses["d_pex_active"] == 1 ? $message["yes"] : $message["no"];
	$responses["d_private_value"] = $responses["d_private"] == 1 ? $message["yes"] : $message["no"];
	$responses["d_state_value"] = $responses["d_state"] == 1 ? $message["d_state_1"] : $message["d_state_0"];
	$responses["d_state_changed_value"] = date( "Y-m-d H:i:s", $responses["d_state_changed"] );
	$responses["d_tracker_numwant_value"] = $responses["d_tracker_numwant"] == -1 ? $message["disabled"] : $responses["d_tracker_numwant"];
	$responses["d_uploads_max_value"] = $responses["d_uploads_max"] == -1 ? $message["disabled"] : $responses["d_uploads_max"];

	$responses["d_base_path_value"] = myrealpath( $responses["d_base_path"], $home_path, $cwd );
	$responses["d_directory_value"] = myrealpath( $responses["d_directory"], $home_path, $cwd );
	$responses["d_tied_to_file_value"] = myrealpath( $responses["d_tied_to_file"], $home_path, $cwd );

	if ( $responses["d_down_rate"] > 0 ) {
		$responses["d_estimated_time"] = $responses["d_left_bytes"] / $responses["d_down_rate"];
		$responses["d_estimated_time_value"] = sprintf( "%dd %02d:%02d", floor( $responses["d_estimated_time"] / 86400 ), floor( $responses["d_estimated_time"] / 3600 ) % 24, floor( $responses["d_estimated_time"] / 60 ) % 60 );
		$responses["d_percentage"] = $responses["d_completed_bytes"] / $responses["d_size_bytes"];
		$responses["d_percentage_value"] = floor( $responses["d_completed_bytes"] / $responses["d_size_bytes"] * 100 );
	} elseif ( $responses["d_hashing"] != 0 ) {
		$responses["d_estimated_time"] = "";
		$responses["d_estimated_time_value"] = "";
		$responses["d_percentage"] = $responses["d_completed_bytes"] / $responses["d_size_bytes"];
		$responses["d_percentage_value"] = floor( $responses["d_completed_bytes"] / $responses["d_size_bytes"] * 100 );
		$responses["d_hpercentage"] = $responses["d_chunks_hashed"] / $responses["d_size_chunks"];
		$responses["d_hpercentage_value"] = floor( $responses["d_chunks_hashed"] / $responses["d_size_chunks"] * 100 );
	} elseif ( $responses["d_complete"] != 1 ) {
		$responses["d_estimated_time"] = "";
		$responses["d_estimated_time_value"] = "";
		$responses["d_percentage"] = $responses["d_completed_bytes"] / $responses["d_size_bytes"];
		$responses["d_percentage_value"] = floor( $responses["d_completed_bytes"] / $responses["d_size_bytes"] * 100 );
	} else {
		$responses["d_estimated_time"] = "";
		$responses["d_estimated_time_value"] = "";
		$responses["d_percentage"] = 1;
		$responses["d_percentage_value"] = 100;
	}

	switch ( $responses["d_connection_current"] ) {
		case "seed" : $responses["d_connection_current_value"] = $message["d_connection_current_seed"]; break;
		case "initial_seed" : $responses["d_connection_current_value"] = $message["d_connection_current_initial_seed"]; break;
		default : $responses["d_connection_current_value"] = $message["d_connection_current_leech"]; break;
	}
	switch ( $responses["d_hashing"] ) {
		case 1 : $responses["d_hashing_value"] = $message["d_hashing_1"]; break;
		case 2 : $responses["d_hashing_value"] = $message["d_hashing_2"]; break;
		case 3 : $responses["d_hashing_value"] = $message["d_hashing_3"]; break;
		default : $responses["d_hashing_value"] = $message["d_hashing_0"]; break;
	}
	switch ( $responses["d_priority"] ) {
		case 1 : $responses["d_priority_value"] = $message["d_priority_1"]; break;
		case 2 : $responses["d_priority_value"] = $message["d_priority_2"]; break;
		case 3 : $responses["d_priority_value"] = $message["d_priority_3"]; break;
		default : $responses["d_priority_value"] = $message["d_priority_0"]; break;
	}

	$responses["d_ratio_value"] = sprintf( "%.3f", $responses["d_ratio"] / 1000 );

	ksort( $responses );

	return true;
}

function prepare_filelist_responses( &$responses, &$message, &$home_path, &$cwd ) {
	$responses["f_last_touched"] = sprintf( "%.0f", $responses["f_last_touched"] );
	$responses["f_range_first"] += 1;

	$f_size_bytes_arr = switch_bytes( $responses["f_size_bytes"] );

	$responses["f_size_bytes_value"] = sprintf( "%.1f", $f_size_bytes_arr[0] );
	$responses["f_size_bytes_suffix"] = $f_size_bytes_arr[1];

	$responses["f_open_value"] = $responses["f_open"] == 1 ? $message["f_open_1"] : $message["f_open_0"];
	$responses["f_last_touched_value"] = date( "Y-m-d H:i:s", substr( $responses["f_last_touched"], 0, -6 ) );

	$responses["f_frozen_path_value"] = myrealpath( $responses["f_frozen_path"], $home_path, $cwd );

	if ( $responses["f_size_chunks"] == 0 ) {
		$responses["f_percentage"] = 1;
		$responses["f_percentage_value"] = 100;
	} else {
		$responses["f_percentage"] = $responses["f_completed_chunks"] / $responses["f_size_chunks"];
		$responses["f_percentage_value"] = floor( $responses["f_completed_chunks"] / $responses["f_size_chunks"] * 100 );
	}

	switch ( $responses["f_priority"] ) {
		case 1 : $responses["f_priority_value"] = $message["f_priority_1"]; break;
		case 2 : $responses["f_priority_value"] = $message["f_priority_2"]; break;
		default : $responses["f_priority_value"] = $message["f_priority_0"]; break;
	}

	ksort( $responses );

	return true;
}

function prepare_peerlist_responses( &$responses, &$message, &$config = array() ) {
	if ( $config["flags"] === "1" ) {
		$responses["p_country"] = strtolower( geoip_country_code_by_name( $responses["p_address"] ) );
		if ( $responses["p_country"] == "" ) {
			$responses["p_country"] = "unknown";
			$responses["p_country_value"] = $message["unknown"];
		} else {
			$responses["p_country_value"] = @geoip_country_name_by_name( $responses["p_address"] );
		}
	}
	
	$p_down_rate_arr = switch_bytes( $responses["p_down_rate"] );
	$p_down_total_arr = switch_bytes( $responses["p_down_total"] );
	$p_peer_rate_arr = switch_bytes( $responses["p_peer_rate"] );
	$p_peer_total_arr = switch_bytes( $responses["p_peer_total"] );
	$p_up_rate_arr = switch_bytes( $responses["p_up_rate"] );
	$p_up_total_arr = switch_bytes( $responses["p_up_total"] );

	$responses["p_down_rate_value"] = sprintf( "%.1f", $p_down_rate_arr[0] );
	$responses["p_down_rate_suffix"] = $p_down_rate_arr[1];
	$responses["p_down_total_value"] = sprintf( "%.1f", $p_down_total_arr[0] );
	$responses["p_down_total_suffix"] = $p_down_total_arr[1];
	$responses["p_peer_rate_value"] = sprintf( "%.1f", $p_peer_rate_arr[0] );
	$responses["p_peer_rate_suffix"] = $p_peer_rate_arr[1];
	$responses["p_peer_total_value"] = sprintf( "%.1f", $p_peer_total_arr[0] );
	$responses["p_peer_total_suffix"] = $p_peer_total_arr[1];
	$responses["p_up_rate_value"] = sprintf( "%.1f", $p_up_rate_arr[0] );
	$responses["p_up_rate_suffix"] = $p_up_rate_arr[1];
	$responses["p_up_total_value"] = sprintf( "%.1f", $p_up_total_arr[0] );
	$responses["p_up_total_suffix"] = $p_up_total_arr[1];

	$responses["p_encrypted_value"] = $responses["p_encrypted"] == 1 ? $message["p_encrypted_1"] : $message["p_encrypted_0"];
	$responses["p_incoming_value"] = $responses["p_incoming"] == 1 ? $message["p_incoming_1"] : $message["p_incoming_0"];

	ksort( $responses );

	return true;
}

function prepare_trackerlist_responses( &$responses, &$message ) {
	$t_scrape_downloaded_arr = switch_bytes( $responses["t_scrape_downloaded"] );

	$responses["t_scrape_time_last"] = sprintf( "%.0f", $responses["t_scrape_time_last"] );

	$responses["t_enabled_value"] = $responses["t_enabled"] == 1 ? $message["t_enabled_1"] : $message["t_enabled_0"];
	$responses["t_open_value"] = $responses["t_open"] == 1 ? $message["t_open_1"] : $message["t_open_0"];
	$responses["t_min_interval_value"] = sprintf( "%02d:%02d:%02d", floor( $responses["t_min_interval"] / 3600 ), $responses["t_min_interval"] / 60 % 60, $responses["t_min_interval"] % 60 );
	$responses["t_normal_interval_value"] = sprintf( "%02d:%02d:%02d", floor( $responses["t_normal_interval"] / 3600 ), $responses["t_normal_interval"] / 60 % 60, $responses["t_normal_interval"] % 60 );

	if ( $responses["t_scrape_time_last"] == 0 ) {
		$responses["t_scrape_time_last_value"] = date( "Y-m-d H:i:s", $responses["t_scrape_time_last"] );
	} else {
		$responses["t_scrape_time_last_value"] = date( "Y-m-d H:i:s", substr( $responses["t_scrape_time_last"], 0, -6 ) );
	}
	$responses["t_type_value"] = $responses["t_type"] == 1 ? $message["t_type_1"] : $message["t_type_2"];

	ksort( $responses );

	return true;
}

function addlanguages( &$xml, &$root, &$node, &$languages ) {
	$root->setAttribute( "language", $_SESSION["rtwi_language"] );

	// adding languages
	$rrrnode = $node->appendChild( $xml->createElement( "languages" ) );
	$rrrnode->setAttribute( "value", $_SESSION["rtwi_language"] );
	foreach ( $languages as $key => $val ) {
		$rrnode = $rrrnode->appendChild( $xml->createElement( "language" ) );
		$rrnode->setAttribute( "value", $key );
		$rrnode->setAttribute( "title", $val );
	}
}

function addrefreshrates( &$xml, &$root, &$node, &$refreshrates ) {
	$root->setAttribute( "refreshrate", $_SESSION["rtwi_refresh"] );

	// adding refresh rates
	$rrrnode = $node->appendChild( $xml->createElement( "refreshrates" ) );
	$rrrnode->setAttribute( "value", $_SESSION["rtwi_refresh"] );
	foreach ( $refreshrates as $key => $val ) {
		$rrnode = $rrrnode->appendChild( $xml->createElement( "refreshrate" ) );
		$rrnode->setAttribute( "value", substr( $key, 12 ) );
		$rrnode->setAttribute( "title", $val );
	}
}

function addviewtypes( &$xml, &$root, &$node, &$view_list, &$viewtypes ) {
	$root->setAttribute( "viewtype", $_SESSION["rtwi_view"] );

	// adding viewtypes
	$vcrnode = $node->appendChild( $xml->createElement( "viewtypes" ) );
	$vcrnode->setAttribute( "value", $_SESSION["rtwi_view"] );
	foreach ( $view_list as $key => $val ) {
		$vcnode = $vcrnode->appendChild( $xml->createElement( "viewtype" ) );
		$vcnode->setAttribute( "value", $val );
		$vcnode->setAttribute( "title", isset( $viewtypes["viewtype_{$val}"] ) ? $viewtypes["viewtype_{$val}"] : $val );
	}
}

function build_xmltree( &$dstruct, &$tree, &$xml, $fullpath, $responses ) {
	foreach ( $dstruct as $key => $val ) {
		if ( is_array( $val ) ) {
			$subtree = $tree->appendChild( $xml->createElement( "directory" ) );
			$subtree->setAttribute( "id", sha1( mt_rand() ) );
			$subtree->setAttribute( "dirname", $key );
			$subtree->setAttribute( "dirpath", urlencode( "{$fullpath}/{$key}" ) );
			$ret = build_xmltree( $val, $subtree, $xml, "{$fullpath}/{$key}", $responses );
		} else {
			$ret = $tree->appendChild( $xml->createElement( "file" ) );
			$ret->setAttribute( "id", $key );
			$ret->setAttribute( "filename", $val );
			xmlrpc_multiappend( $xml, $ret, $responses[$key] );
		}
	}

	return $ret;
}

function xmlrpc_multiappend( &$xml, &$dnode, &$responses ) {
	$keys = array_keys( $responses );
	reset( $responses );
	while ( list( $rkey, $rval ) = each( $responses ) ) {
		$rval = str_replace( "&", "&amp;", $rval );
		if ( array_key_exists( "{$rkey}_suffix", $responses ) ) {
			$node = $dnode->appendChild( $xml->createElement( $rkey, $rval ) );
			$node->setAttribute( "suffix", $responses["{$rkey}_suffix"] );
			$node->setAttribute( "value", $responses["{$rkey}_value"] );
			unset( $responses["{$rkey}_suffix"] );
			unset( $responses["{$rkey}_value"] );
		} elseif ( array_key_exists( "{$rkey}_value", $responses ) ) {
			$node = $dnode->appendChild( $xml->createElement( $rkey, $rval ) );
			$node->setAttribute( "value", $responses["{$rkey}_value"] );
			unset( $responses["{$rkey}_value"] );
		} elseif ( is_array( $rval ) ) {
		} else {
			$node = $dnode->appendChild( $xml->createElement( $rkey, $rval ) );
		}
	}

	return true;
}

error_reporting( E_ALL );
error_reporting( E_ALL ^ E_NOTICE );

set_time_limit( 10 );

// setting default
session_start();

// reading config files
$config = parse_ini_file( "includes/rtwi.conf", true );
$users = parse_ini_file( $config["user_conf"], true );

// set language from cookie if exists
if ( !isset( $_SESSION["rtwi_language"] ) ) {
	$_SESSION["rtwi_language"] = isset( $_COOKIE["rtwi_language"] ) ? $_COOKIE["rtwi_language"] : $config["lang"];
}


// including neccessary files
require_once( "includes/classes/xmlrpc_handler.inc.php" );
require_once( "includes/messages.{$_SESSION["rtwi_language"]}.inc.php" );
require_once( "includes/tools/functions.time.inc.php" );

$callnum = 0;
$calltime = 0;
$multicallnum = 0;

// initializing xmlrpc methods
$xmlrpc_methods = array(
	"si"	=> $config["dht"] === "1" ? 
			array( "dht_statistics", "get_bind", "get_check_hash", "get_connection_leech", "get_connection_seed", "get_dht_port", "get_directory", "get_download_rate", "get_http_cacert", "get_http_capath", "get_http_proxy", "get_ip", "get_max_downloads_div", "get_max_downloads_global", "get_max_file_size", "get_max_memory_usage", "get_max_open_files", "get_max_open_http", "get_max_open_sockets", "get_max_peers", "get_max_peers_seed", "get_max_uploads", "get_max_uploads_div", "get_max_uploads_global", "get_memory_usage", "get_min_peers", "get_min_peers_seed", "get_name", "get_peer_exchange", "get_port_open", "get_port_random", "get_port_range", "get_preload_min_size", "get_preload_required_rate", "get_preload_type", "get_proxy_address", "get_receive_buffer_size", "get_safe_sync", "get_scgi_dont_route", "get_send_buffer_size", "get_session", "get_session_lock", "get_session_on_completion", "get_split_file_size", "get_split_suffix", "get_stats_not_preloaded", "get_stats_preloaded", "get_timeout_safe_sync", "get_timeout_sync", "get_tracker_numwant", "get_upload_rate", "get_use_udp_trackers", "system.client_version", "system.cwd", "system.hostname", "system.library_version", "system.pid", "view_list" ) :
			array( "get_bind", "get_check_hash", "get_connection_leech", "get_connection_seed", "get_directory", "get_download_rate", "get_http_cacert", "get_http_capath", "get_http_proxy", "get_ip", "get_max_downloads_div", "get_max_downloads_global", "get_max_file_size", "get_max_memory_usage", "get_max_open_files", "get_max_open_http", "get_max_open_sockets", "get_max_peers", "get_max_peers_seed", "get_max_uploads", "get_max_uploads_div", "get_max_uploads_global", "get_memory_usage", "get_min_peers", "get_min_peers_seed", "get_name", "get_peer_exchange", "get_port_open", "get_port_random", "get_port_range", "get_preload_min_size", "get_preload_required_rate", "get_preload_type", "get_proxy_address", "get_receive_buffer_size", "get_safe_sync", "get_scgi_dont_route", "get_send_buffer_size", "get_session", "get_session_lock", "get_session_on_completion", "get_split_file_size", "get_split_suffix", "get_stats_not_preloaded", "get_stats_preloaded", "get_timeout_safe_sync", "get_timeout_sync", "get_tracker_numwant", "get_upload_rate", "get_use_udp_trackers", "system.client_version", "system.cwd", "system.hostname", "system.library_version", "system.pid", "view_list" ),
	"d"	=> array( "d.get_base_filename=", "d.get_base_path=", "d.get_bytes_done=", "d.get_chunk_size=", "d.get_chunks_hashed=", "d.get_complete=", "d.get_completed_bytes=", "d.get_completed_chunks=", "d.get_connection_current=", "d.get_connection_leech=", "d.get_connection_seed=", "d.get_creation_date=", "d.get_custom1=", "d.get_custom2=", "d.get_custom3=", "d.get_custom4=", "d.get_custom5=", "d.get_directory=", "d.get_down_rate=", "d.get_down_total=", "d.get_free_diskspace=", "d.get_hash=", "d.get_hashing=", "d.get_ignore_commands=", "d.get_left_bytes=", "d.get_local_id=", "d.get_local_id_html=", "d.get_max_file_size=", "d.get_max_size_pex=", "d.get_message=", "d.get_name=", "d.get_peer_exchange=", "d.get_peers_accounted=", "d.get_peers_complete=", "d.get_peers_connected=", "d.get_peers_max=", "d.get_peers_min=", "d.get_peers_not_connected=", "d.get_priority=", "d.get_priority_str=", "d.get_ratio=", "d.get_size_bytes=", "d.get_size_chunks=", "d.get_size_files=", "d.get_size_pex=", "d.get_skip_rate=", "d.get_skip_total=", "d.get_state=", "d.get_state_changed=", "d.get_tied_to_file=", "d.get_tracker_focus=", "d.get_tracker_numwant=", "d.get_tracker_size=", "d.get_up_rate=", "d.get_up_total=", "d.get_uploads_max=", "d.is_active=", "d.is_hash_checked=", "d.is_hash_checking=", "d.is_multi_file=", "d.is_open=", "d.is_pex_active=", "d.is_private=" ),
	"f"	=> array( "f.get_completed_chunks=", "f.get_frozen_path=", "f.is_created=", "f.is_open=", "f.get_last_touched=", "f.get_match_depth_next=", "f.get_match_depth_prev=", "f.get_offset=", "f.get_path=", "f.get_path_components=", "f.get_path_depth=", "f.get_priority=", "f.get_range_first=", "f.get_range_second=", "f.get_size_bytes=", "f.get_size_chunks=" ),
	"p"	=> array( "p.get_address=", "p.get_client_version=", "p.get_completed_percent=", "p.get_down_rate=", "p.get_down_total=", "p.get_id=", "p.get_id_html=", "p.get_options_str=", "p.get_peer_rate=", "p.get_peer_total=", "p.get_port=", "p.get_up_rate=", "p.get_up_total=", "p.is_encrypted=", "p.is_incoming=", "p.is_obfuscated=", "p.is_snubbed=" ),
	"t"	=> array( "t.get_group=", "t.get_id=", "t.get_min_interval=", "t.get_normal_interval=", "t.get_scrape_complete=", "t.get_scrape_downloaded=", "t.get_scrape_incomplete=", "t.get_scrape_time_last=", "t.get_type=", "t.get_url=", "t.is_enabled=", "t.is_open=" ),
	"g"	=> array( "d.get_name", "d.get_directory", "f.get_path", "f.get_frozen_path", "f.get_size_bytes" ),
);

// getting request values
if ( isset( $_REQUEST["format"] ) ) {
	$format = $_REQUEST["format"];
} else {
	$format = "";
}

if ( isset( $_REQUEST["mod"] ) ) {
	$mod = $_REQUEST["mod"];
} else {
	$mod = "";
}

if ( isset( $_REQUEST["hash"] ) ) {
	$hash = $_REQUEST["hash"];
} else {
	$hash = "";
}

if ( isset( $_REQUEST["page"] ) ) {
	switch ( $_REQUEST["page"] ) {
		case "transfers" : {
			$page = "transfers";
			break;
		}
		case "chunks" : {
			$page = "chunks";
			break;
		}
		case "trackers" : {
			$page = "trackers";
			break;
		}
		case "files" : {
			$page = "files";
			break;
		}
		case "peers" : {
			$page = "peers";
			break;
		}
		default : {
			$page = "info";
			break;
		}
	}
} else {
	$page = "info";
}

if ( isset( $_REQUEST["id"] ) ) {
	$id = $_REQUEST["id"];
	settype( $id, "int" );
} else {
	$id = -1;
}

if ( isset( $_REQUEST["path"] ) ) {
	$path = $_REQUEST["path"];
} else {
	$path = "";
}

if ( isset( $_REQUEST["ajax"] ) && $_REQUEST["ajax"] === "true" && $config["ajax"] === "1" ) {
	$ajax = true;
} else {
	$ajax = false;
}

// checking if user is logged in
if ( ( isset( $_SESSION["rtwi_auth"] ) && $_SESSION["rtwi_auth"] === 1 ) || ( isset( $_COOKIE["rtwi_auth"] ) && $_COOKIE["rtwi_auth"] == 1 && isset( $_COOKIE["rtwi_nick"] ) && array_key_exists( $_COOKIE["rtwi_nick"], $users ) && $users[$_COOKIE["rtwi_nick"]]["pass"] == $_COOKIE["rtwi_pass"] ) ) {
	// setting values from cookie if exists
	if ( !isset( $_SESSION["rtwi_auth"] ) || $_SESSION["rtwi_auth"] !== 1 ) {
		$_SESSION["rtwi_auth"] = 1;
		$_SESSION["rtwi_nick"] = $_COOKIE["rtwi_nick"];
		$_SESSION["rtwi_cadr"] = $users[$_COOKIE["rtwi_nick"]]["address"];

		// setting rtorrent's connection address
		if ( substr( $_SESSION["rtwi_cadr"], 0, 7 ) === "unix://" ) {
			$_SESSION["rtwi_cadr"] = myrealpath( substr( $_SESSION["rtwi_cadr"], 7 ), $config["home_path"], "{$config["home_path"]}{$_SESSION["rtwi_nick"]}" );
			$_SESSION["rtwi_cadr"] = "unix://{$_SESSION["rtwi_cadr"]}";
		}
	}

	// initializing rtorrent connection
	$xmlrpc = new xmlrpc_handler( $_SESSION["rtwi_cadr"], 10 );

	if ( $xmlrpc->getconntype() == "http" ) {
		$xmlrpc->setaccount( $_SESSION["rtwi_nick"], $_SESSION["rtwi_password"] );
	}

	// setting sort view mode from cookie if exists
	if ( !isset( $_SESSION["rtwi_view"] ) ) {
		$_SESSION["rtwi_view"] = isset( $_COOKIE["rtwi_view"] ) ? $_COOKIE["rtwi_view"] : "default";
	}
	// setting auto-refresh rate from cookie if exists
	if ( !isset( $_SESSION["rtwi_refresh"] ) ) {
		$_SESSION["rtwi_refresh"] = isset( $_COOKIE["rtwi_refresh"] ) ? $_COOKIE["rtwi_refresh"] : 0;
	}
} else {
	// show login page if not logged in
	$mod = "login";
}

// initializing xml
$xml = new DOMDocument( "1.0", "utf-8" );
$xml->formatOutput = true;

$root = $xml->appendChild( $xml->createElement( "root" ) );

$root->appendChild( $xml->createElement( "mod", $mod ) );
$root->appendChild( $xml->createElement( "hash", $hash ) );
$root->appendChild( $xml->createElement( "page", $page ) );
$root->appendChild( $xml->createElement( "id", $id ) );
$root->appendChild( $xml->createElement( "burl", $config["base"] ) );
$root->appendChild( $xml->createElement( "url", $config["index"] ) );
$root->appendChild( $xml->createElement( "iurl", $config["input"] ) );
$root->appendChild( $xml->createElement( "curl", str_replace( "&", "&amp;", $_SERVER["REQUEST_URI"] ) ) );
$root->appendChild( $xml->createElement( "purl", isset( $_SESSION["rtwi_lastpage"] ) ? str_replace( "&", "&amp;", $_SESSION["rtwi_lastpage"] ) : "" ) );
$root->appendChild( $xml->createElement( "datetime", date( "Y. m. d. H:i:s", time() ) ) );
$root->appendChild( $xml->createElement( "language", $_SESSION["rtwi_language"] ) );

// adding allowed settings in xml
foreach ( $config as $key => $val ) {
	if ( $val === "1" ) {
		$root->appendChild( $xml->createElement( "allow_{$key}", "true" ) );
	}
}

// adding translation to xml
$labels = $root->appendChild( $xml->createElement( "labels" ) );
foreach ( $label as $key => $val ) {
	$labels->appendChild( $xml->createElement( $key, $val ) );
}
$labels->getElementsByTagName( "mailto" )->item( 0 )->nodeValue = str_rot13( base64_encode( str_rot13( $labels->getElementsByTagName( "mailto" )->item( 0 )->nodeValue ) ) );

//print_r( $_SESSION );
//print_r( $_REQUEST );

// deciding what to do
if ( $ajax === true ) {
	$layout_file = "layout.ajax.index.xsl";
} else {
	$layout_file = "layout.main.index.xsl";
}
if ( ( isset( $xmlrpc ) && ( $xmlrpc->geterrorsnum() == 0 ) ) || ( $mod == "login" ) ) {
	switch ( $mod ) {
		case "login" : { // login
			// adding language select
			if ( $config["language"] ) {
				addlanguages( $xml, $root, $root, $languages );
			}

			$layout_file = "layout.main.login.xsl";

			break;
		}
		case "serverinfo" : { // server info
			// creating torrents node
			$tnode = $root->appendChild( $xml->createElement( "torrents" ) );
			// adding auto-refresh select
			if ( $config["refresh"] ) {
				addrefreshrates( $xml, $root, $tnode, $refreshrates );
			}
			// adding language select
			if ( $config["language"] ) {
				addlanguages( $xml, $root, $tnode, $languages );
			}

			// retrieving server info
			if ( !$xmlrpc->setmrequest( $xmlrpc_methods["si"] ) || !$xmlrpc->call() || !$xmlrpc->parse() ) {
				$_SESSION["rtwi_err"] = $xmlrpc->geterrors();
				break;
			}
			$si_responses = $xmlrpc->mfetch( $xmlrpc_methods["si"] );

			// getting up/down rates for totals
			$methodlist = array( "d.get_down_rate=", "d.get_up_rate=" );
			if ( !$xmlrpc->setrequest( "d.multicall", array_merge( array( $_SESSION["rtwi_view"] ), $methodlist ) ) || !$xmlrpc->call() || !$xmlrpc->parse() ) {
				$_SESSION["rtwi_err"] = $xmlrpc->geterrors();
				break;
			}
			$response = $xmlrpc->fetch();

			// counting totals
			$bytes_down = 0;
			$bytes_up = 0;
			for ( $i = 0; $i < count( $response ); $i++ ) {
				for ( $r = 0; $r < count( $methodlist ); $r++ ) {
					$methodval = preg_replace( "/(.)\.get_(.*)=/", "$1_$2", $methodlist[$r] );
					$d_responses[$i][$methodval] = $response[$i][$r];
				}
				$bytes_down += $d_responses[$i]["d_down_rate"];
				$bytes_up += $d_responses[$i]["d_up_rate"];
			}

			$si_responses["bytes_down"] = $bytes_down;
			$si_responses["bytes_up"] = $bytes_up;

			// preparing values
			prepare_serverinfo_responses( $si_responses, $message, $config );

			// addng some more values to xml (total up/down rate, limits)
			$node = $tnode->appendChild( $xml->createElement( "bytes_down", $si_responses["bytes_down"] ) );
			$node->setAttribute( "suffix", $si_responses["bytes_down_suffix"] );
			$node->setAttribute( "value", $si_responses["bytes_down_value"] );
			$node = $tnode->appendChild( $xml->createElement( "bytes_up", $si_responses["bytes_up"] ) );
			$node->setAttribute( "suffix", $si_responses["bytes_up_suffix"] );
			$node->setAttribute( "value", $si_responses["bytes_up_value"] );
			$node = $tnode->appendChild( $xml->createElement( "download_rate", $si_responses["download_rate"] ) );
			$node->setAttribute( "suffix", $si_responses["download_rate_suffix"] );
			$node->setAttribute( "value", $si_responses["download_rate_value"] );
			$node = $tnode->appendChild( $xml->createElement( "upload_rate", $si_responses["upload_rate"] ) );
			$node->setAttribute( "suffix", $si_responses["upload_rate_suffix"] );
			$node->setAttribute( "value", $si_responses["upload_rate_value"] );

			// addng some more values to xml (total up/down rate, limits)
			$inode = $tnode->appendChild( $xml->createElement( "server_info" ) );
			xmlrpc_multiappend( $xml, $inode, $si_responses );

			$layout_file = "layout.main.index.xsl";

			break;
		}
		case "addtorrent" : { // add a new torrent
			// getting download directory
			if ( !$xmlrpc->setmrequest( array( "get_directory", "system.cwd" ) ) || !$xmlrpc->call() || !$xmlrpc->parse() ) {
				$_SESSION["rtwi_err"] = $xmlrpc->geterrors();
				break;
			}
			$directories = $xmlrpc->fetch();
			$directory = $directories[0];
			$cwd = $directories[1];

			// full download directory path
			$directory = myrealpath( $directories[0][0], $config["home_path"], $directories[1][0] );

			$ppath = substr( $path, 0, strrpos( $path, "/" ) );
			// scanning for subdirectories
			$scan = scandir( myrealpath( "{$directory}/{$path}", $config["home_path"], $directories[1][0] ) );
			// checking free space
			$freespace = switch_bytes( disk_free_space( myrealpath( "{$directory}/{$ppath}", $config["home_path"], $directories[1][0] ) ) );

			// adding values to xml
			$atnode = $root->appendChild( $xml->createElement( "addtorrent" ) );
			$atnode->setAttribute( "name", $ppath );
			$atnode->setAttribute( "path", $path );
			$atnode->setAttribute( "ppath", urlencode( $ppath ) );
			$atnode->setAttribute( "freespace", disk_free_space( "{$directory}/{$ppath}" ) );
			$atnode->setAttribute( "freespace_value", sprintf( "%.1f", $freespace[0] ) );
			$atnode->setAttribute( "freespace_suffix", $freespace[1] );

			// adding language select
			if ( $config["language"] === "1" ) {
				addlanguages( $xml, $root, $atnode, $languages );
			}

			// checking subdirectories for free space
			foreach( $scan as $key => $val ) {
				$dpath = str_replace( "//", "/", "{$path}/{$val}" );
				$fdpath = str_replace( "//", "/", "{$directory}/{$dpath}" );
				if ( ( is_dir( $fdpath ) || ( is_link( $fdpath ) && is_dir( readlink( $fdpath ) ) ) ) && substr( $val, 0, 1 ) != "."  ) {
					$freespace = switch_bytes( disk_free_space( $fdpath ) );

					$dnode = $atnode->appendChild( $xml->createElement( "dlpath" ) );
					$dnode->setAttribute( "name", $val );
					$dnode->setAttribute( "path", urlencode( $dpath ) );
					$dnode->setAttribute( "freespace", disk_free_space( $fdpath ) );
					$dnode->setAttribute( "freespace_value", sprintf( "%.1f", $freespace[0] ) );
					$dnode->setAttribute( "freespace_suffix", $freespace[1] );
				}
			}

			$layout_file = "layout.main.index.xsl";

			break;
		}
		case "torrent" : { // torrent
			// creating torrents node
			$tnode = $root->appendChild( $xml->createElement( "torrents" ) );
			// adding auto-refresh select
			if ( $config["refresh"] ) {
				addrefreshrates( $xml, $root, $tnode, $refreshrates );
			}
			// adding language select
			if ( $config["language"] ) {
				addlanguages( $xml, $root, $tnode, $languages );
			}

			// retrieving server info
			if ( !$xmlrpc->setmrequest( $xmlrpc_methods["si"] ) || !$xmlrpc->call() || !$xmlrpc->parse() ) {
				$_SESSION["rtwi_err"] = $xmlrpc->geterrors();
				break;
			}
			$si_responses = $xmlrpc->mfetch( $xmlrpc_methods["si"] );

			// retrieving download info
			if ( !$xmlrpc->setrequest( "d.multicall", array_merge( array( $_SESSION["rtwi_view"] ), $xmlrpc_methods["d"] ) ) || !$xmlrpc->call() || !$xmlrpc->parse() ) {
				$_SESSION["rtwi_err"] = $xmlrpc->geterrors();
				break;
			}
			$response = $xmlrpc->fetch();

			// counting totals
			$bytes_down = 0;
			$bytes_up = 0;
			$torrent = false;
			for ( $i = 0; $i < count( $response ); $i++ ) {
				for ( $r = 0; $r < count( $xmlrpc_methods["d"] ); $r++ ) {
					$methodval = preg_replace( "/(.)\.(get|is)_(.*)=/", "$1_$3", $xmlrpc_methods["d"][$r] );
					$d_responses[$i][$methodval] = $response[$i][$r];
				}
				$bytes_down += $d_responses[$i]["d_down_rate"];
				$bytes_up += $d_responses[$i]["d_up_rate"];

				// if hash matches save the download data
				if ( $d_responses[$i]["d_hash"] == $hash ) {
					$torrent = $d_responses[$i];
				}
			}
			unset( $d_responses );

			// when we have a match
			if ( is_array( $torrent ) ) {
				// prepare download variables
				prepare_downloadlist_responses( $torrent, $message, $config["home_path"], $si_responses["cwd"] );
				// decide what to do
				switch ( $page ) {
					case "peers" : { // peer list page
						// create peer nodes
						$node = $tnode->appendChild( $xml->createElement( "torrent_peers_root" ) );
						$node = $node->appendChild( $xml->createElement( "torrent_peers" ) );

						// retrieve peer list info
						if ( !$xmlrpc->setrequest( "p.multicall", array_merge( array( $torrent["d_hash"], 0 ), $xmlrpc_methods["p"] ) ) || !$xmlrpc->call() || !$xmlrpc->parse() ) {
							$_SESSION["rtwi_err"] = $xmlrpc->geterrors();
							break;
						}
						$response = $xmlrpc->fetch();
						
						// process the peer info
						for ( $i = 0; $i < count( $response ); $i++ ) {
							for ( $r = 0; $r < count( $xmlrpc_methods["p"] ); $r++ ) {
								$methodval = preg_replace( "/(.)\.(get|is)_(.*)=/", "$1_$3", $xmlrpc_methods["p"][$r] );
								$responses[$i][$methodval] = $response[$i][$r];
							}
						}
						// adding an ID to each peer in the list
						for ( $i = 0; $i < $torrent["d_peers_connected"]; $i++ ) {
							prepare_peerlist_responses( $responses[$i], $message, $config );
							$pnode = $node->appendChild( $xml->createElement( "peer" ) );
							$pnode->setAttribute( "id", $i );
							xmlrpc_multiappend( $xml, $pnode, $responses[$i] );
						}


						break;
					}
					case "info" : {
						// crate info nodes
						$node = $tnode->appendChild( $xml->createElement( "torrent_info_root" ) );
						$node = $node->appendChild( $xml->createElement( "torrent_info" ) );

						break;
					}
					case "files" : {
						// create file list nodes
						$node = $tnode->appendChild( $xml->createElement( "torrent_files_root" ) );
						$node = $node->appendChild( $xml->createElement( "torrent_files" ) );

						// create downloads root direcrory node
						$node = $node->appendChild( $xml->createElement( "files_root" ) );
						$node = $node->appendChild( $xml->createElement( "directory" ) );
						$node->setAttribute( "dirname", $torrent["d_base_filename"] );

						$fst = getmicrotime();

						// retreive file list info
						if ( !$xmlrpc->setrequest( "f.multicall", array_merge( array( $torrent["d_hash"], 0 ), $xmlrpc_methods["f"] ) ) || !$xmlrpc->call() || !$xmlrpc->parse() ) {
							$_SESSION["rtwi_err"] = $xmlrpc->geterrors();
							break;
						}
						$response = $xmlrpc->fetch();

						// process the file info
						for ( $i = 0; $i < count( $response ); $i++ ) {
							for ( $r = 0; $r < count( $xmlrpc_methods["f"] ); $r++ ) {
								$methodval = preg_replace( "/(.)\.(get|is)_(.*)=/", "$1_$3", $xmlrpc_methods["f"][$r] );
								$responses[$i][$methodval] = $response[$i][$r];
							}
						}

						// build som kind of struct
						$dstruct = array();
						for ( $i = 0; $i < $torrent["d_size_files"]; $i++ ) {
							prepare_filelist_responses( $responses[$i], $message, $home_path, $si_responses["cwd"] );

							$n = 0;
							$tmp = &$dstruct;
							foreach ( $responses[$i]["f_path_components"] as $key => $val ) {
								if ( count( $responses[$i]["f_path_components"] ) == ++$n ) {
									$tmp[$i] = $val;
								} else {
									if ( !isset( $tmp[$val] ) ) {
										$tmp[$val] = array();
									}
									$tmp = &$tmp[$val];
								}
							}

						}
						// build an xml tree of the files
						$fnode = build_xmltree( $dstruct, $node, $xml, $torrent["d_directory_value"], $responses );

						$ftt = getmicrotime();

						break;
					}
					case "trackers" : {
						// creating tracker list nodes
						$node = $tnode->appendChild( $xml->createElement( "torrent_trackers_root" ) );
						$node = $node->appendChild( $xml->createElement( "torrent_trackers" ) );

						// retrieving tracker list info
						if ( !$xmlrpc->setrequest( "t.multicall", array_merge( array( $torrent["d_hash"], 0 ), $xmlrpc_methods["t"] ) ) || !$xmlrpc->call() || !$xmlrpc->parse() ) {
							$_SESSION["rtwi_err"] = $xmlrpc->geterrors();
							break;
						}
						$response = $xmlrpc->fetch();
						// processing the tracker info
						for ( $i = 0; $i < count( $response ); $i++ ) {
							for ( $r = 0; $r < count( $xmlrpc_methods["t"] ); $r++ ) {
								$methodval = preg_replace( "/(.)\.(get|is)_(.*)=/", "$1_$3", $xmlrpc_methods["t"][$r] );
								$responses[$i][$methodval] = $response[$i][$r];
							}
						}
						// adding an ID to each tracker in the list
						for ( $i = 0; $i < $torrent["d_tracker_size"]; $i++ ) {
							prepare_trackerlist_responses( $responses[$i], $message, $config["home_path"] );
							$tracnode = $node->appendChild( $xml->createElement( "tracker" ) );
							$tracnode->setAttribute( "id", $i );
							xmlrpc_multiappend( $xml, $tracnode, $responses[$i] );
						}

						break;
					}
					case "chunks" : { // unimplemented
						$node = $tnode->appendChild( $xml->createElement( "torrent_chunks_root" ) );
						$node = $node->appendChild( $xml->createElement( "torrent_chunks" ) );

						break;
					}
					case "transfers" : { // unimplemented
						$node = $tnode->appendChild( $xml->createElement( "torrent_transfers_root" ) );
						$node = $node->appendChild( $xml->createElement( "torrent_transfers" ) );

						break;
					}
				}
				// adding the download info to the xml
				xmlrpc_multiappend( $xml, $node, $torrent );
			} else {
				$_SESSION["rtwi_err"] = "nohashfound";
			}

			$si_responses["bytes_down"] = $bytes_down;
			$si_responses["bytes_up"] = $bytes_up;

			// adding values to xml
			prepare_serverinfo_responses( $si_responses, $message, $home_path, $config );

			// addng some more values to xml (total up/down rate, limits)
			$node = $tnode->appendChild( $xml->createElement( "bytes_down", $si_responses["bytes_down"] ) );
			$node->setAttribute( "suffix", $si_responses["bytes_down_suffix"] );
			$node->setAttribute( "value", $si_responses["bytes_down_value"] );
			$node = $tnode->appendChild( $xml->createElement( "bytes_up", $si_responses["bytes_up"] ) );
			$node->setAttribute( "suffix", $si_responses["bytes_up_suffix"] );
			$node->setAttribute( "value", $si_responses["bytes_up_value"] );
			$node = $tnode->appendChild( $xml->createElement( "download_rate", $si_responses["download_rate"] ) );
			$node->setAttribute( "suffix", $si_responses["download_rate_suffix"] );
			$node->setAttribute( "value", $si_responses["download_rate_value"] );
			$node = $tnode->appendChild( $xml->createElement( "upload_rate", $si_responses["upload_rate"] ) );
			$node->setAttribute( "suffix", $si_responses["upload_rate_suffix"] );
			$node->setAttribute( "value", $si_responses["upload_rate_value"] );

			// decide what to send back to the browser
			if ( $ajax === true ) {
				$layout_file = "layout.ajax.index.xsl";
			} else {
				$layout_file = "layout.main.index.xsl";
			}

			break;
		}
		case "getfile" : { // download a file
			// checking if users are allowed to download
			if ( !$config["download"] ) {
				$_SESSION["rtwi_err"] = "downloadnotallowed";
				header( "location: {$url["index"]}" );
				exit;
			} elseif ( $id < 0 ) { // checking if the file id is given and is valid
				$_SESSION["rtwi_err"] = "noidfound";
				header( "location: {$url["index"]}" );
				exit;
			} else {
				// retrieving server info
				if ( !$xmlrpc->setmrequest( $xmlrpc_methods["si"] ) || !$xmlrpc->call() || !$xmlrpc->parse() ) {
					$_SESSION["rtwi_err"] = $xmlrpc->geterrors();
					break;
				}
				$si_responses = $xmlrpc->mfetch( $xmlrpc_methods["si"] );

				// retrieving download info
				if ( !$xmlrpc->setrequest( "download_list", array( $_SESSION["rtwi_view"] ) ) || !$xmlrpc->call() || !$xmlrpc->parse() ) {
					$_SESSION["rtwi_err"] = $xmlrpc->geterrors();
					break;
				}
				$torrents = $xmlrpc->fetch();

				// checking if we've found the torrent
				if ( in_array( $hash, $torrents ) ) {
					// getting the filename
					if ( !$xmlrpc->setmrequest( $xmlrpc_methods["g"], array( $hash, $id ) ) || !$xmlrpc->call() || !$xmlrpc->parse() ) {
						$_SESSION["rtwi_err"] = $xmlrpc->geterrors();
						break;
					}
					$response = $xmlrpc->mfetch( $xmlrpc_methods["g"] );

					// getting the absolute path of the download's directory
					$d_directory_value = myrealpath( $response["d_directory"], $config["home_path"], $si_responses["cwd"] );
				} else {
					$_SESSION["rtwi_err"] = "nohashfound";
					$layout_file = "layout.main.index.xsl";
				}
			}

			break;
		}
		default : { // torrents
			// retrieving server info
			if ( !$xmlrpc->setmrequest( $xmlrpc_methods["si"] ) || !$xmlrpc->call() || !$xmlrpc->parse() ) {
				$_SESSION["rtwi_err"] = $xmlrpc->geterrors();
				break;
			}
			$si_responses = $xmlrpc->mfetch( $xmlrpc_methods["si"] );

			// creating torrents node
			$tnode = $root->appendChild( $xml->createElement( "torrents" ) );
			// adding sort view select
			addviewtypes( $xml, $root, $tnode, $si_responses["view_list"], $viewtypes );
			// adding auto-refresh select
			if ( $config["refresh"] ) {
				addrefreshrates( $xml, $root, $tnode, $refreshrates );
			}
			// adding language select
			if ( $config["language"] ) {
				addlanguages( $xml, $root, $tnode, $languages );
			}
			// retrieving download info
			if ( !$xmlrpc->setrequest( "d.multicall", array_merge( array( $_SESSION["rtwi_view"] ), $xmlrpc_methods["d"] ) ) || !$xmlrpc->call() || !$xmlrpc->parse() ) {
				$_SESSION["rtwi_err"] = $xmlrpc->geterrors();
				break;
			}
			$response = $xmlrpc->fetch();

			// valirables for counting total up/down rate
			$bytes_down = 0;
			$bytes_up = 0;
			// process the download info
			for ( $i = 0; $i < count( $response ); $i++ ) {
				for ( $r = 0; $r < count( $xmlrpc_methods["d"] ); $r++ ) {
					$methodval = preg_replace( "/(.)\.(get|is)_(.*)=/", "$1_$3", $xmlrpc_methods["d"][$r] );
					$d_responses[$i][$methodval] = $response[$i][$r];
				}
				// oincreasing total up/down rate with the current download's rates
				$bytes_down += $d_responses[$i]["d_down_rate"];
				$bytes_up += $d_responses[$i]["d_up_rate"];

				// formatting and inserting values to xml
				prepare_downloadlist_responses( $d_responses[$i], $message, $home_path, $si_responses["cwd"] );
				$ttnode = $tnode->appendChild( $xml->createElement( "torrent" ) );
				xmlrpc_multiappend( $xml, $ttnode, $d_responses[$i] );
			}

			// setting total up/down rate
			$si_responses["bytes_down"] = $bytes_down;
			$si_responses["bytes_up"] = $bytes_up;

			// adding values to xml
			prepare_serverinfo_responses( $si_responses, $message, $config );

			// addng some more values to xml (total up/down rate, limits)
			$node = $tnode->appendChild( $xml->createElement( "bytes_down", $si_responses["bytes_down"] ) );
			$node->setAttribute( "suffix", $si_responses["bytes_down_suffix"] );
			$node->setAttribute( "value", $si_responses["bytes_down_value"] );
			$node = $tnode->appendChild( $xml->createElement( "bytes_up", $si_responses["bytes_up"] ) );
			$node->setAttribute( "suffix", $si_responses["bytes_up_suffix"] );
			$node->setAttribute( "value", $si_responses["bytes_up_value"] );
			$node = $tnode->appendChild( $xml->createElement( "download_rate", $si_responses["download_rate"] ) );
			$node->setAttribute( "suffix", $si_responses["download_rate_suffix"] );
			$node->setAttribute( "value", $si_responses["download_rate_value"] );
			$node = $tnode->appendChild( $xml->createElement( "upload_rate", $si_responses["upload_rate"] ) );
			$node->setAttribute( "suffix", $si_responses["upload_rate_suffix"] );
			$node->setAttribute( "value", $si_responses["upload_rate_value"] );

			$layout_file = "layout.main.index.xsl";

			break;
		}
	}
} elseif ( isset( $xmlrpc ) ) {
	$_SESSION["rtwi_err"] = $xmlrpc->geterrors();

	if ( $ajax === true ) {
		$layout_file = "layout.ajax.index.xsl";
	} else {
		$layout_file = "layout.main.index.xsl";
	}
} else {
	// adding language select
	if ( $config["language"] ) {
		addlanguages( $xml, $root, $root, $languages );
	}

	if ( $ajax === true ) {
		$layout_file = "layout.ajax.index.xsl";
	} else {
		$layout_file = "layout.main.index.xsl";
	}
}

// adding (error) message to xml
if ( isset( $_SESSION["rtwi_err"] ) && $_SESSION["rtwi_err"] != "" ) {
	if ( is_array( $_SESSION["rtwi_err"] ) ) {
		$lasterr = array_pop( $_SESSION["rtwi_err"] );
		$preverr = array_pop( $_SESSION["rtwi_err"] );
		$_SESSION["rtwi_err"] = $lasterr;
	}
	$node = $root->appendChild( $xml->createElement( "err" ) );
	$mnode = $node->appendChild( $xml->createElement( "errmsg" ) );
	$mnode->appendChild( $xml->createElement( "msg", $message[$_SESSION["rtwi_err"]] ) );
	if ( in_array( $_SESSION["rtwi_err"], array( "xmlrpc_fault", "xmlrpc_scgi_connect_failed", "xmlrpc_gw_connect_failed", "xmlrpc_request_invalidtype" ) ) ) {
		$mnode = $node->appendChild( $xml->createElement( "errmsg" ) );
		$mnode->appendChild( $xml->createElement( "msg", isset( $preverr ) ? $preverr : $_SESSION["rtwi_err"] ) );
	}

	$_SESSION["rtwi_err"] = "";
	unset( $_SESSION["rtwi_err"] );
}

// setting referrer
if ( $ajax === false && $mod != "getfile" ) {
	$_SESSION["rtwi_lastpage"] = $_SERVER["REQUEST_URI"];
}

// displaying the page
if ( $mod != "getfile" ) {
	if ( $format == "xml" ) {
		print $xml->SaveXML();
	} else {
		require_once( "includes/classes/xsl_handler.inc.php" );
		$page = new page_handler( $config["site_theme"], $layout_file, $xml );
		$page->parse();
		$text = $page->fetch();
		$len = strlen( $text );

		@header( "content-length: {$len}" );
		@header( "content-type: text/html; charset=utf-8" );
		@header( "content-language: hu" );
		@header( "cache-control: no-store, no-cache, must-revalidate, post-check=0, pre-check=0" );
		@header( "pragma: no-cache" );
		@header( "expires: thu, 1 jan 1970 00:00:00 gmt" );
		@header( "imagetoolbar: no" );

		print $text;
	}
} else { // sending file to download
	// getting the filename
	$path = "{$d_directory_value}/{$response["f_path"]}";
	$filesize = filesize( $path );

	// set time limit to 0, so the user actually can download the whole file
	set_time_limit( 0 );

	// sending headers
	@header( "Content-Description: File Transfer" );
	@header( "Content-Type: application/force-download" );
	@header( "Content-Length: {$filesize}" );
	@header( "Content-Disposition: attachment; filename=\"{$response["f_path"]}\"" );
	
	// sending the file
	readfile( $path );
}

?>
