<?php

function xmlrpc_call( &$xmlrpc_array, &$request, &$callnum, &$calltime ) {
	$st = getmicrotime();

	$len = strlen( $request );
	$headers = "CONTENT_LENGTH\0{$len}\0";
	$headers .= "SCGI\01\0";
	$len = strlen( $headers );
	$out = "{$len}:{$headers},{$request}";

	$fp = fsockopen( $xmlrpc_array["host"], $xmlrpc_array["port"], $errno, $errstr, $xmlrpc_array["timeout"] );
	if ( $fp ) {
		fwrite( $fp, $out );
		do {
			$line = fgets( $fp );
		} while ( trim( $line ) != "" );
		
		$ret = stream_get_contents( $fp );
	} else {
		$_SESSION["rtwi_err"] = "noconn";
		$ret = $errno;
	}

	$tt = getmicrotime();
	$callnum++;
	$calltime += $tt - $st;

	return $ret;
}

error_reporting( E_ALL );
//error_reporting( E_ALL ^ E_NOTICE );

session_start();
if ( !isset( $_SESSION["rtwi_rights"] ) ) {
	$_SESSION["rtwi_rights"] = 0;
}

require_once( "includes/config.inc.php" );
require_once( "{$include_path}/tools/functions.time.inc.php" );
require_once( "{$include_path}/classes/bittorrent_handler.inc.php" );

$st = getmicrotime();
$callnum = 0;
$calltime = 0;

if ( isset( $_REQUEST["mod"] ) ) {
	$mod = $_REQUEST["mod"];
} else {
	$mod = "";
}

if ( isset( $_REQUEST["hash"] ) ) {
	$hash = $_REQUEST["hash"];
} else {
	$hash = "";
}

if ( ( !isset( $_SESSION["rtwi_auth"] ) || $_SESSION["rtwi_auth"] !== 1 ) && $_REQUEST["mod"] != "login" ) {
	header( "location: {$url["index"]}" );
	exit;
} elseif ( $_REQUEST["mod"] != "login" ) {
	$xmlrpc_array["port"] = $users[$_SESSION["rtwi_nick"]]["port"];
}

$xml = new DOMDocument( "1.0", "utf-8" );
$xml->formatOutput = true;

$root = $xml->appendChild( $xml->createElement( "root" ) );

//print_r( $_SESSION );
//print_r( $_REQUEST );

switch ( $_REQUEST["mod"] ) {
	case "login" : { // login
		if ( isset( $_REQUEST["loginname"] ) && isset( $_REQUEST["loginpass"] ) && $_REQUEST["loginname"] != "" && $_REQUEST["loginpass"] != "" && array_key_exists( $_REQUEST["loginname"], $users ) && $users[$_REQUEST["loginname"]]["pass"] == sha1( $_REQUEST["loginpass"] ) ) {
			$_SESSION["rtwi_auth"] = 1;
			$_SESSION["rtwi_nick"] = $_REQUEST["loginname"];
			$_SESSION["rtwi_port"] = $users[$_REQUEST["loginname"]];

			settype( $_SESSION["rtwi_port"], "int" );

			$xmlrpc_array["port"] = $users[$_SESSION["rtwi_nick"]]["port"];

			$request = xmlrpc_encode_request( "system.set_umask", array( $torrents_umask ) );
			$response = xmlrpc_call( $xmlrpc_array, $request, $callnum, $calltime );

			$_SESSION["rtwi_err"] = "succlogin";
			header( "location: {$url["index"]}" );
			exit;
		} else {
			$_SESSION["rtwi_err"] = "badlogin";
			header( "location: {$url["index"]}" );
			exit;
		}

		break;
	}
	case "logout" : { // logout
		$_SESSION["rtwi_auth"] = 0;
		$_SESSION["rtwi_nick"] = "";
		$_SESSION["rtwi_port"] = 0;
		$_SESSION["rtwi_view"] = "";
		$_SESSION["rtwi_refresh"] = 0;

		unset( $_SESSION["rtwi_auth"] );
		unset( $_SESSION["rtwi_nick"] );
		unset( $_SESSION["rtwi_port"] );
		unset( $_SESSION["rtwi_view"] );
		unset( $_SESSION["rtwi_refresh"] );

		$_SESSION["rtwi_err"] = "succlogout";
		header( "location: {$url["index"]}" );
		exit;

		break;
	}
	case "changeview" : { // change view
		if ( isset( $_REQUEST["viewtype"] ) && $_REQUEST["viewtype"] != "" ) {
			switch ( $_REQUEST["viewtype"] ) {
				case "name" : {
					$_SESSION["rtwi_view"] = "name";
					break;
				}
				case "started" : {
					$_SESSION["rtwi_view"] = "started";
					break;
				}
				case "stopped" : {
					$_SESSION["rtwi_view"] = "stopped";
					break;
				}
				case "complete" : {
					$_SESSION["rtwi_view"] = "complete";
					break;
				}
				case "incomplete" : {
					$_SESSION["rtwi_view"] = "incomplete";
					break;
				}
				case "hashing" : {
					$_SESSION["rtwi_view"] = "hashing";
					break;
				}
				case "seeding" : {
					$_SESSION["rtwi_view"] = "seeding";
					break;
				}
				default : {
					$_SESSION["rtwi_view"] = "default";
					break;
				}
			}

			setcookie( "rtwi_view", $_SESSION["rtwi_view"], time() + 60 * 60 * 24 * 30 );

			$_SESSION["rtwi_err"] = "succviewchange";
			header( "location: {$url["index"]}" );
			exit;
		} else {
			$_SESSION["rtwi_err"] = "badviewtype";
			header( "location: {$url["index"]}" );
			exit;
		}

		break;
	}
	case "changerefresh" : { // change view
		if ( isset( $_REQUEST["refreshrate"] ) && $_REQUEST["refreshrate"] != "" ) {
			$refreshrate = $_REQUEST["refreshrate"];
			settype( $refreshrate, "int" );
			if ( $refreshrate < 5 ) {
				$refreshrate = 0;
			}

			$_SESSION["rtwi_refresh"] = $refreshrate;

			setcookie( "rtwi_refresh", $_SESSION["rtwi_refresh"], time() + 60 * 60 * 24 * 30 );

			$_SESSION["rtwi_err"] = "succrefreshchange";
			header( "location: {$_SESSION["rtwi_lastpage"]}" );
			exit;
		} else {
			$_SESSION["rtwi_err"] = "badrefreshrate";
			header( "location: {$_SESSION["rtwi_lastpage"]}" );
			exit;
		}

		break;
	}
	case "changethrottle" : { // change view
		if ( isset( $_REQUEST["upspeed"] ) && $_REQUEST["upspeed"] != "" && isset( $_REQUEST["downspeed"] ) && $_REQUEST["downspeed"] != "" ) {
			$upspeed = $_REQUEST["upspeed"];
			settype( $upspeed, "int" );
			if ( $upspeed < 0 ) {
				$upspeed = 0;
			}
			$downspeed = $_REQUEST["downspeed"];
			settype( $downspeed, "int" );
			if ( $downspeed < 0 ) {
				$downspeed = 0;
			}

			$request = xmlrpc_encode_request( "set_upload_rate", array( $upspeed * 1024 ) );
			$response = xmlrpc_call( $xmlrpc_array, $request, $callnum, $calltime );
			$request = xmlrpc_encode_request( "set_download_rate", array( $downspeed * 1024 ) );
			$response = xmlrpc_call( $xmlrpc_array, $request, $callnum, $calltime );

			header( "location: {$_SESSION["rtwi_lastpage"]}" );
			exit;
		} else {
			$_SESSION["rtwi_err"] = "badrefreshrate";
			header( "location: {$_SESSION["rtwi_lastpage"]}" );
			exit;
		}

		break;
	}
	case "addtorrent" : { // add a torrent
		if ( !isset( $_REQUEST["tfmethod"] ) || !in_array( $_REQUEST["tfmethod"], array( "url", "file" ) ) ) {
			$_SESSION["rtwi_err"] = "badtfmethod";
			header( "location: {$url["index"]}?mod=addtorrent" );
			exit;
		}

		$request = xmlrpc_encode_request( "get_directory", array() );
		$response = xmlrpc_call( $xmlrpc_array, $request, $callnum, $calltime );
		$directory = xmlrpc_decode( $response );
		$request = xmlrpc_encode_request( "system.get_cwd", array() );
		$response = xmlrpc_call( $xmlrpc_array, $request, $callnum, $calltime );
		$cwd = xmlrpc_decode( $response );

		if ( substr( $directory, -1 ) == "/" ) {
			$directory = substr( $directory, 0, -1 );
		}
		if ( in_array( "..", split( "/", $directory ) ) || in_array( ".", split( "/", $directory ) ) ) {
			$_SESSION["rtwi_err"] = "badrtdirectory";
			header( "location: {$url["index"]}?mod=addtorrent" );
			exit;
		} elseif ( substr( $directory, 0, 2 ) == "./" ) {
			$directory = substr( $directory, 2 );
			$directory = "{$cwd}/{$directory}";
		} elseif ( substr( $directory, 0, 2 ) == "~/" ) {
			$directory = substr( $directory, 2 );
			$directory = "{$home_path}{$_SESSION["rtwi_nick"]}/{$directory}";
		}
		$directory = str_replace( "//", "/", $directory );

		if ( $_REQUEST["tfmethod"] == "url" ) {
			if ( !isset( $_REQUEST["torrenturl"] ) || $_REQUEST["torrenturl"] == "" ) {
				$_SESSION["rtwi_err"] = "notorrenturl";
				header( "location: {$url["index"]}?mod=addtorrent" );
				exit;
			} elseif ( substr( $_REQUEST["torrenturl"], 0, 7 ) != "http://" ) {
				$_SESSION["rtwi_err"] = "notanurl";
				header( "location: {$url["index"]}?mod=addtorrent" );
				exit;
			}
			$torrent = $_REQUEST["torrenturl"];
		} else {
			if ( !isset( $_FILES ) || !is_array( $_FILES ) ) {
				$_SESSION["rtwi_err"] = "notorrentfileuploaded";
				header( "location: {$url["index"]}?mod=addtorrent" );
				exit;
			}
			switch ( $_FILES["torrentfile"]["error"] ) {
				case 0 : {
					if ( is_uploaded_file( $_FILES["torrentfile"]["tmp_name"] ) ) {
						if ( isset( $_REQUEST["keeptorrentfile"] ) && $_REQUEST["keeptorrentfile"] == "on" ) {
							$prefix = time() . mt_rand();
							$uploadpath = "{$directory}/!rtwi_files/{$prefix}_{$_FILES["torrentfile"]["name"]}";

							if ( !is_dir( "{$directory}/!rtwi_files" ) && !@mkdir( "{$directory}/!rtwi_files", 0777 ) ) {
								$_SESSION["rtwi_err"] = "notrtfdircreated";
								header( "location: {$url["index"]}?mod=addtorrent" );
								exit;
							}

							if ( @copy( $_FILES["torrentfile"]["tmp_name"], $uploadpath ) ) {
								chmod( $uploadpath, 0666 );
								$torrent = $uploadpath;
							} else {
								if ( !is_dir( $directory ) ) {
									$_SESSION["rtwi_err"] = "notrtfdircreated";
									header( "location: {$url["index"]}?mod=addtorrent" );
									exit;
								} else {
									$_SESSION["rtwi_err"] = "notrtfdirwriteright";
									header( "location: {$url["index"]}?mod=addtorrent" );
									exit;
								}
							}
						} else {
							$torrent = file_get_contents( $_FILES["torrentfile"]["tmp_name"] );
							xmlrpc_set_type( &$torrent, "base64" ); 
						}
					} else {
						print "Possible file upload attack!\n";
					}

					break;
				}
				case 1 : {
					$_SESSION["rtwi_err"] = "rtfileinisize";
					header( "location: {$url["index"]}?mod=addtorrent" );
					exit;
				
					break;
				}
				case 2 : {
					$_SESSION["rtwi_err"] = "rtfileformsize";
					header( "location: {$url["index"]}?mod=addtorrent" );
					exit;
				
					break;
				}
				case 3 : {
					$_SESSION["rtwi_err"] = "rtfilepartial";
					header( "location: {$url["index"]}?mod=addtorrent" );
					exit;
				
					break;
				}
				case 4 : {
					$_SESSION["rtwi_err"] = "rtfilenofile";
					header( "location: {$url["index"]}?mod=addtorrent" );
					exit;
				
					break;
				}
				case 6 : {
					$_SESSION["rtwi_err"] = "rtfilenotmpdir";
					header( "location: {$url["index"]}?mod=addtorrent" );
					exit;
				
					break;
				}
				case 7 : {
					$_SESSION["rtwi_err"] = "rtfilenowrite";
					header( "location: {$url["index"]}?mod=addtorrent" );
					exit;
				
					break;
				}
				default : {
					$_SESSION["rtwi_err"] = "rtfileother";
					header( "location: {$url["index"]}?mod=addtorrent" );
					exit;
				
					break;
				}
			}
		}

		$dlpath = $_REQUEST["dlpath"];
		if ( substr( $dlpath, 0, 1 ) == "/" ) {
			$dlpath = substr( $dlpath, 1 );
		}
		if ( substr( $dlpath, -1 ) == "/" ) {
			$dlpath = substr( $dlpath, 0, -1 );
		}
		if ( in_array( "..", split( "/", $dlpath ) ) || in_array( ".", split( "/", $dlpath ) ) ) {
			$_SESSION["rtwi_err"] = "badatpath";
			header( "location: {$url["index"]}?mod=addtorrent" );
			exit;
		}

		if ( isset( $_REQUEST["torrentstart"] ) && $_REQUEST["torrentstart"] == "start" ) {
			$param = array( $torrent, "d.start=" );
		} else {
			$param = array( $torrent );
		}
		if ( $dlpath != "" ) {
			$dlpath = "{$directory}/{$dlpath}";
			$param[] = ( "d.set_directory={$dlpath}" );
		}

		if ( $_REQUEST["tfmethod"] == "url" || isset( $_REQUEST["keeptorrentfile"] ) && $_REQUEST["keeptorrentfile"] == "on"  ) {
			$request = xmlrpc_encode_request( "load_verbose", $param );
		} else {
			$request = xmlrpc_encode_request( "load_raw_verbose", $param );
		}
		$response = xmlrpc_call( $xmlrpc_array, $request, $callnum, $calltime );

		$_SESSION["rtwi_err"] = "succtorrentload";
		header( "location: {$url["index"]}" );
		exit;

		break;
	}
	case "torrentstart" : { // start a torrent
		$request = xmlrpc_encode_request( "download_list", array() );
		$response = xmlrpc_call( $xmlrpc_array, $request, $callnum, $calltime );
		$response = preg_replace( "/i8|ex\.i8/", "string", $response );
		$torrents = xmlrpc_decode( $response );

		if ( !in_array( $hash, $torrents ) ) {
			$_SESSION["rtwi_err"] = "nohashfound";
			header( "location: {$url["index"]}" );
			exit;
		}

		$request = xmlrpc_encode_request( "d.start", array( $hash ) );
		$response = xmlrpc_call( $xmlrpc_array, $request, $callnum, $calltime );

		sleep( 1 );

		$_SESSION["rtwi_err"] = "succtorrentstart";
		header( "location: {$url["index"]}" );
		exit;

		break;
	}
	case "torrentopen" : { // open a torrent
		$request = xmlrpc_encode_request( "download_list", array() );
		$response = xmlrpc_call( $xmlrpc_array, $request, $callnum, $calltime );
		$response = preg_replace( "/i8|ex\.i8/", "string", $response );
		$torrents = xmlrpc_decode( $response );

		if ( !in_array( $hash, $torrents ) ) {
			$_SESSION["rtwi_err"] = "nohashfound";
			header( "location: {$url["index"]}" );
			exit;
		}

		$request = xmlrpc_encode_request( "d.open", array( $hash ) );
		$response = xmlrpc_call( $xmlrpc_array, $request, $callnum, $calltime );

		sleep( 1 );

		$_SESSION["rtwi_err"] = "succtorrentopen";
		header( "location: {$url["index"]}" );
		exit;

		break;
	}
	case "torrentstop" : { // stop a torrent
		$request = xmlrpc_encode_request( "download_list", array() );
		$response = xmlrpc_call( $xmlrpc_array, $request, $callnum, $calltime );
		$response = preg_replace( "/i8|ex\.i8/", "string", $response );
		$torrents = xmlrpc_decode( $response );

		if ( !in_array( $hash, $torrents ) ) {
			$_SESSION["rtwi_err"] = "nohashfound";
			header( "location: {$url["index"]}" );
			exit;
		}

		$request = xmlrpc_encode_request( "d.stop", array( $hash ) );
		$response = xmlrpc_call( $xmlrpc_array, $request, $callnum, $calltime );

		sleep( 1 );

		$_SESSION["rtwi_err"] = "succtorrentstop";
		header( "location: {$url["index"]}" );
		exit;

		break;
	}
	case "torrentclose" : { // close a torrent
		$request = xmlrpc_encode_request( "download_list", array() );
		$response = xmlrpc_call( $xmlrpc_array, $request, $callnum, $calltime );
		$response = preg_replace( "/i8|ex\.i8/", "string", $response );
		$torrents = xmlrpc_decode( $response );

		if ( !in_array( $hash, $torrents ) ) {
			$_SESSION["rtwi_err"] = "nohashfound";
			header( "location: {$url["index"]}" );
			exit;
		}

		$request = xmlrpc_encode_request( "d.close", array( $hash ) );
		$response = xmlrpc_call( $xmlrpc_array, $request, $callnum, $calltime );

		sleep( 1 );

		$_SESSION["rtwi_err"] = "succtorrentclose";
		header( "location: {$url["index"]}" );
		exit;

		break;
	}
	case "torrentcheckhash" : { // check hash for a torrent
		$request = xmlrpc_encode_request( "download_list", array() );
		$response = xmlrpc_call( $xmlrpc_array, $request, $callnum, $calltime );
		$response = preg_replace( "/i8|ex\.i8/", "string", $response );
		$torrents = xmlrpc_decode( $response );

		if ( !in_array( $hash, $torrents ) ) {
			$_SESSION["rtwi_err"] = "nohashfound";
			header( "location: {$url["index"]}" );
			exit;
		}

		$request = xmlrpc_encode_request( "d.check_hash", array( $hash ) );
		$response = xmlrpc_call( $xmlrpc_array, $request, $callnum, $calltime );

		sleep( 1 );

		$_SESSION["rtwi_err"] = "succtorrentcheckhash";
		header( "location: {$url["index"]}" );
		exit;

		break;
	}
	case "torrentremove" : { // remove a torrent
		$request = xmlrpc_encode_request( "download_list", array() );
		$response = xmlrpc_call( $xmlrpc_array, $request, $callnum, $calltime );
		$response = preg_replace( "/i8|ex\.i8/", "string", $response );
		$torrents = xmlrpc_decode( $response );

		if ( !in_array( $hash, $torrents ) ) {
			$_SESSION["rtwi_err"] = "nohashfound";
			header( "location: {$url["index"]}" );
			exit;
		}

		$request = xmlrpc_encode_request( "d.erase", array( $hash ) );
		$response = xmlrpc_call( $xmlrpc_array, $request, $callnum, $calltime );

		sleep( 1 );

		$_SESSION["rtwi_err"] = "succtorrentremove";
		header( "location: {$url["index"]}" );
		exit;

		break;
	}
	case "torrenterase" : { // erase a torrent and delete the data
		$request = xmlrpc_encode_request( "download_list", array() );
		$response = xmlrpc_call( $xmlrpc_array, $request, $callnum, $calltime );
		$response = preg_replace( "/i8|ex\.i8/", "string", $response );
		$torrents = xmlrpc_decode( $response );

		if ( !in_array( $hash, $torrents ) ) {
			$_SESSION["rtwi_err"] = "nohashfound";
			header( "location: {$url["index"]}" );
			exit;
		}

		$request = xmlrpc_encode_request( "d.multicall", array( "", "d.get_hash=", "d.get_directory=", "d.get_size_files=" ) );
		$response = xmlrpc_call( $xmlrpc_array, $request, $callnum, $calltime );
		$response = preg_replace( "/i8|ex\.i8/", "string", $response );
		$response = xmlrpc_decode( $response );
		foreach ( $response as $key => $val ) {
			if ( $val[0] == $hash ) {
				$response = $val;
			}
		}
		$directory = $response[1];
		$size_files = $response[2];

		$request = xmlrpc_encode_request( "system.get_cwd", array() );
		$response = xmlrpc_call( $xmlrpc_array, $request, $callnum, $calltime );
		$cwd = xmlrpc_decode( $response );
		$request = xmlrpc_encode_request( "get_directory", array() );
		$response = xmlrpc_call( $xmlrpc_array, $request, $callnum, $calltime );
		$dd = xmlrpc_decode( $response );

		if ( substr( $directory, -1 ) == "/" ) {
			$directory = substr( $directory, 0, -1 );
		}
		if ( in_array( "..", split( "/", $directory ) ) || in_array( ".", split( "/", $directory ) ) ) {
			$_SESSION["rtwi_err"] = "badrtdirectory";
			header( "location: {$url["index"]}?mod=addtorrent" );
			exit;
		} elseif ( substr( $directory, 0, 2 ) == "./" ) {
			$directory = substr( $directory, 2 );
			$directory = "{$cwd}/{$directory}";
		} elseif ( substr( $directory, 0, 2 ) == "~/" ) {
			$directory = substr( $directory, 2 );
			$directory = "{$home_path}{$_SESSION["rtwi_nick"]}/{$directory}";
		}
		$directory = str_replace( "//", "/", $directory );

		if ( substr( $dd, -1 ) == "/" ) {
			$dd = substr( $dd, 0, -1 );
		}
		if ( in_array( "..", split( "/", $dd ) ) || in_array( ".", split( "/", $dd ) ) ) {
			$_SESSION["rtwi_err"] = "badrtdirectory";
			header( "location: {$url["index"]}?mod=addtorrent" );
			exit;
		} elseif ( substr( $dd, 0, 2 ) == "./" ) {
			$dd = substr( $dd, 2 );
			$dd = "{$cwd}/{$dd}";
		} elseif ( substr( $dd, 0, 2 ) == "~/" ) {
			$dd = substr( $dd, 2 );
			$dd = "{$home_path}{$_SESSION["rtwi_nick"]}/{$dd}";
		}
		$dd = str_replace( "//", "/", $dd );

		$request = xmlrpc_encode_request( "f.multicall", array( $hash, 0, "f.get_frozen_path=" ) );
		$response = xmlrpc_call( $xmlrpc_array, $request, $callnum, $calltime );
		$response = preg_replace( "/i8|ex\.i8/", "string", $response );
		$files = xmlrpc_decode( $response );

		$unlink_num = 0;
		$dirs = array();
		foreach ( $files as $key => $val ) {
				$dirs[] = dirname( $val[0] );
			if ( is_writable( $val[0] ) ) {
				if ( @unlink( $val[0] ) ) {
					$unlink_num++;
				}
			}
		}

		$dirs = array_unique( $dirs );
		foreach ( $dirs as $key => $val ) {
			$pattern = "'({$directory}.*?)(/[^/]*)$'";
			if ( preg_match( $pattern, $val, $match ) ) {
				$dirs[] = $match[1];
			}
		}
		$dirs = array_unique( $dirs );
		if ( in_array( $dd, $dirs ) ) {
			$key = array_search( $dd, $dirs );
			unset( $dirs[$key] );
		}
		rsort( $dirs );
//		print_r( $dirs );

		$size_dirs = count( $dirs );
		$rmdir_num = 0;
		foreach ( $dirs as $key => $val ) {
			if ( is_writable( $val ) ) {
				if ( @rmdir( $val ) ) {
					$rmdir_num++;
				}
			}
		}

		$request = xmlrpc_encode_request( "d.erase", array( $hash ) );
		$response = xmlrpc_call( $xmlrpc_array, $request, $callnum, $calltime );

		sleep( 1 );

		if ( $unlink_num != $size_files && $rmdir_num != $size_dirs ) {
			$_SESSION["rtwi_err"] = "warntorrenterase";
			header( "location: {$url["index"]}" );
			exit;
		} else {
			$_SESSION["rtwi_err"] = "succtorrenterase";
			header( "location: {$url["index"]}" );
			exit;
		}

		break;
	}
	case "doonalltorrent" : { // do some task on all torrent
		switch ( $_REQUEST["task"] ) {
			case "start" : {
				$request = xmlrpc_encode_request( "d.multicall", array( "", "d.start=" ) );
				$response = xmlrpc_call( $xmlrpc_array, $request, $callnum, $calltime );

				sleep( 1 );

				$_SESSION["rtwi_err"] = "succtorrentsstart";
				header( "location: {$url["index"]}" );
				exit;

				break;
			}
			case "stop" : {
				$request = xmlrpc_encode_request( "d.multicall", array( "", "d.stop=" ) );
				$response = xmlrpc_call( $xmlrpc_array, $request, $callnum, $calltime );

				sleep( 1 );

				$_SESSION["rtwi_err"] = "succtorrentsstop";
				header( "location: {$url["index"]}" );
				exit;

				break;
			}
			case "open" : {
				$request = xmlrpc_encode_request( "d.multicall", array( "", "d.open=" ) );
				$response = xmlrpc_call( $xmlrpc_array, $request, $callnum, $calltime );

				sleep( 1 );

				$_SESSION["rtwi_err"] = "succtorrentsopen";
				header( "location: {$url["index"]}" );
				exit;

				break;
			}
			case "close" : {
				$request = xmlrpc_encode_request( "d.multicall", array( "", "d.close=" ) );
				$response = xmlrpc_call( $xmlrpc_array, $request, $callnum, $calltime );

				sleep( 1 );

				$_SESSION["rtwi_err"] = "succtorrentsclose";
				header( "location: {$url["index"]}" );
				exit;

				break;
			}
			case "checkhash" : {
				$request = xmlrpc_encode_request( "d.multicall", array( "", "d.check_hash=" ) );
				$response = xmlrpc_call( $xmlrpc_array, $request, $callnum, $calltime );

				sleep( 1 );

				$_SESSION["rtwi_err"] = "succtorrentscheckhash";
				header( "location: {$url["index"]}" );
				exit;

				break;
			}
			case "remove" : {
				$request = xmlrpc_encode_request( "d.multicall", array( "", "d.erase=" ) );
				$response = xmlrpc_call( $xmlrpc_array, $request, $callnum, $calltime );

				sleep( 1 );

				$_SESSION["rtwi_err"] = "succtorrentsremove";
				header( "location: {$url["index"]}" );
				exit;

				break;
			}
			default : {
				$_SESSION["rtwi_err"] = "nooponalltorrent";
				header( "location: {$url["index"]}" );
				exit;

				break;
			}
		}
		
		break;
	}
	case "changepriority" : { // set priority
		$request = xmlrpc_encode_request( "download_list", array() );
		$response = xmlrpc_call( $xmlrpc_array, $request, $callnum, $calltime );
		$response = preg_replace( "/i8|ex\.i8/", "string", $response );
		$torrents = xmlrpc_decode( $response );

		if ( !in_array( $hash, $torrents ) ) {
			$_SESSION["rtwi_err"] = "nohashfound";
			header( "location: {$url["index"]}" );
			exit;
		}

		if ( isset( $_REQUEST["priority"] ) ) {
			$priority = $_REQUEST["priority"];
		} else {
			$_SESSION["rtwi_err"] = "nopriorityfound";
			header( "location: {$url["index"]}" );
			exit;
		}

		if ( !in_array( $priority, array( 0, 1, 2, 3 ) ) ) {
			$_SESSION["rtwi_err"] = "badpriorityfoiund";
			header( "location: {$url["index"]}" );
			exit;
		}

		$request = xmlrpc_encode_request( "d.set_priority", array( $hash, $priority ) );
		$response = xmlrpc_call( $xmlrpc_array, $request, $callnum, $calltime );

		sleep( 1 );

		$_SESSION["rtwi_err"] = "succprioritychange";
		header( "location: {$url["index"]}" );
		exit;

		break;
	}
	case "changefilepriority" : { // set file priority
		$request = xmlrpc_encode_request( "download_list", array() );
		$response = xmlrpc_call( $xmlrpc_array, $request, $callnum, $calltime );
		$response = preg_replace( "/i8|ex\.i8/", "string", $response );
		$torrents = xmlrpc_decode( $response );

		if ( isset( $_REQUEST["ajax"] ) && $_REQUEST["ajax"] == "true" ) {
			$tourl = "{$url["index"]}?mod=torrent&hash={$hash}&page=files&ajax=true";
		} else {
			$tourl = "{$url["index"]}?mod=torrent&hash={$hash}&page=files";
		}

		if ( !in_array( $hash, $torrents ) ) {
			$_SESSION["rtwi_err"] = "nohashfound";
			header( "location: {$tourl}" );
			exit;
		}

		if ( isset( $_REQUEST["id"] ) ) {
			$id = $_REQUEST["id"];
			settype( $id, "int" );
		} else {
			$_SESSION["rtwi_err"] = "noidfound";
			header( "location: {$tourl}" );
			exit;
		}

		$request = xmlrpc_encode_request( "d.get_size_files", array( $hash ) );
		$response = xmlrpc_call( $xmlrpc_array, $request, $callnum, $calltime );
		$response = preg_replace( "/i8|ex\.i8/", "string", $response );
		$response = xmlrpc_decode( $response );

		if ( $id < 0 || $id > $response ) {
			$_SESSION["rtwi_err"] = "badidfound";
			header( "location: {$tourl}" );
			exit;
		}

		if ( isset( $_REQUEST["filepriority"] ) ) {
			$filepriority = $_REQUEST["filepriority"];
			settype( $fpriority, "int" );
		} else {
			$_SESSION["rtwi_err"] = "nopriorityfound";
			header( "location: {$tourl}" );
			exit;
		}

		if ( !in_array( $filepriority, array( 0, 1, 2 ) ) ) {
			$_SESSION["rtwi_err"] = "badpriorityfound";
			header( "location: {$tourl}" );
			exit;
		}

		$request = xmlrpc_encode_request( "f.set_priority", array( $hash, $id, $filepriority ) );
		$response = xmlrpc_call( $xmlrpc_array, $request, $callnum, $calltime );

		$request = xmlrpc_encode_request( "d.update_priorities ", array( $hash ) );
		$response = xmlrpc_call( $xmlrpc_array, $request, $callnum, $calltime );

		sleep( 1 );

		$_SESSION["rtwi_err"] = "succfileprioritychange";
		header( "location: {$tourl}" );
		exit;

		break;
	}
	case "changetrackerenabled" : { // set if tracker is enabled
		$request = xmlrpc_encode_request( "download_list", array() );
		$response = xmlrpc_call( $xmlrpc_array, $request, $callnum, $calltime );
		$response = preg_replace( "/i8|ex\.i8/", "string", $response );
		$torrents = xmlrpc_decode( $response );

		if ( isset( $_REQUEST["ajax"] ) && $_REQUEST["ajax"] == "true" ) {
			$tourl = "{$url["index"]}?mod=torrent&hash={$hash}&page=trackers&ajax=true";
		} else {
			$tourl = "{$url["index"]}?mod=torrent&hash={$hash}&page=trackers";
		}

		if ( !in_array( $hash, $torrents ) ) {
			$_SESSION["rtwi_err"] = "nohashfound";
			header( "location: {$tourl}" );
			exit;
		}

		if ( isset( $_REQUEST["id"] ) ) {
			$id = $_REQUEST["id"];
			settype( $id, "int" );
		} else {
			$_SESSION["rtwi_err"] = "noidfound";
			header( "location: {$tourl}" );
			exit;
		}

		$request = xmlrpc_encode_request( "d.get_size_trackers", array( $hash ) );
		$response = xmlrpc_call( $xmlrpc_array, $request, $callnum, $calltime );
		$response = preg_replace( "/i8|ex\.i8/", "string", $response );
		$response = xmlrpc_decode( $response );

		if ( $id < 0 || $id > $response ) {
			$_SESSION["rtwi_err"] = "badidfound";
			header( "location: {$tourl}" );
			exit;
		}

		if ( isset( $_REQUEST["trackerenabled"] ) ) {
			$trackerenabled = $_REQUEST["trackerenabled"];
			settype( $trackerenabled, "int" );
		} else {
			$_SESSION["rtwi_err"] = "novaluefound";
			header( "location: {$tourl}" );
			exit;
		}

		if ( !in_array( $trackerenabled, array( 0, 1 ) ) ) {
			$_SESSION["rtwi_err"] = "badvaluefound";
			header( "location: {$tourl}" );
			exit;
		}

		$request = xmlrpc_encode_request( "t.set_enabled", array( $hash, $id, $trackerenabled ) );
		$response = xmlrpc_call( $xmlrpc_array, $request, $callnum, $calltime );

		sleep( 1 );

		$_SESSION["rtwi_err"] = "succtrackerenabledchange";
		header( "location: {$tourl}" );
		exit;

		break;
	}
	default : {
		$_SESSION["rtwi_err"] = "noinputmod";
		header( "location: {$url["index"]}" );
		exit;

		break;
	}
}

?>
