<?php

declare(strict_types=1);

use PHPUnit\Framework\TestCase;
use hu\jmk\rtwi\PathProvider;

final class PathProviderTest extends TestCase {
  /**
   * @test
   */
  public function shouldGetUserHome():void {
    $this->assertSame(
      "/home/custom/",
      (new PathProvider(array("home" => "/home/"), array("home" => "/home/custom/"), "user"))->getHome()
    );
  }

  /**
   * @test
   */
  public function shouldAssembleUserHome():void {
    $this->assertSame(
      "/home/user",
      (new PathProvider(array("home" => "/home/"), array(), "user"))->getHome()
    );
  }
}
