<?php

declare(strict_types=1);

namespace hu\jmk;

class AutoLoader {
  private static array $basePaths = array();

  public static function register():void {
    self::addBasePath(__DIR__ . "/../../");
    spl_autoload_register(array(new self(), "autoload"));
  }

  public static function addBasePath($path):void {
    if (!array_search($path, self::$basePaths)) {
      self::$basePaths[] = $path;
    }
  }

  public static function autoload($className):void {
    $fileName = self::processClassName($className);
    if (is_readable($fileName)) {
      require_once($fileName);
    } else {
      foreach (self::$basePaths as $basePath) {
        if (is_readable("${basePath}/${fileName}")) {
          require_once("${basePath}/${fileName}");
        }
      }
    }
  }

  private static function processClassName($className):string {
    $className = ltrim($className, "\\");
    $fileName = "";
    $namespace = "";
    if ($lastNsPos = strrpos($className, "\\")) {
      $namespace = substr($className, 0, $lastNsPos);
      $className = substr($className, $lastNsPos + 1);
      $fileName = str_replace("\\", DIRECTORY_SEPARATOR, $namespace) . DIRECTORY_SEPARATOR;
    }
    return $fileName . str_replace("_", DIRECTORY_SEPARATOR, $className) . ".php";
  }
}

AutoLoader::register();
